/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandlers;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.ItemSlot;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.covers.filter.BaseFilter;
import gregtech.common.covers.filter.MatchResult;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFilterContainer
extends ItemStackHandler {
    private int maxTransferSize = 1;
    private int transferSize;
    @Nullable
    private BaseFilter currentFilter;
    @Nullable
    private Runnable onFilterInstanceChange;
    private final IDirtyNotifiable dirtyNotifiable;

    protected BaseFilterContainer(IDirtyNotifiable dirtyNotifiable) {
        this.dirtyNotifiable = dirtyNotifiable;
    }

    public boolean test(Object toTest) {
        return !this.hasFilter() || this.getFilter().test(toTest);
    }

    public MatchResult match(Object toMatch) {
        if (!this.hasFilter()) {
            return MatchResult.create(true, toMatch, -1);
        }
        return this.getFilter().match(toMatch);
    }

    public int getTransferLimit(Object stack) {
        if (!this.hasFilter() || this.isBlacklistFilter()) {
            return this.getTransferSize();
        }
        return this.getFilter().getTransferLimit(stack, this.getTransferSize());
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public void onFilterInstanceChange() {
        this.dirtyNotifiable.markAsDirty();
        if (this.onFilterInstanceChange != null) {
            this.onFilterInstanceChange.run();
        }
    }

    public void setOnFilterInstanceChange(@Nullable Runnable onFilterInstanceChange) {
        this.onFilterInstanceChange = onFilterInstanceChange;
    }

    @NotNull
    public final ItemStack getFilterStack() {
        return this.getStackInSlot(0);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.getFilterStack())) {
            return;
        }
        if (stack.func_190926_b()) {
            this.setFilter(null);
        } else if (this.isItemValid(stack)) {
            this.setFilter(BaseFilter.getFilterFromStack(stack));
        }
        super.setStackInSlot(slot, stack);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isItemValid(stack);
    }

    protected abstract boolean isItemValid(ItemStack var1);

    @NotNull
    protected abstract IKey getFilterKey();

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(stack)) {
            return stack;
        }
        ItemStack remainder = super.insertItem(slot, stack, simulate);
        if (!simulate) {
            this.setFilter(BaseFilter.getFilterFromStack(stack));
        }
        return remainder;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extracted = super.extractItem(slot, amount, simulate);
        if (!extracted.func_190926_b()) {
            this.setFilter(null);
        }
        return extracted;
    }

    public final void setFilterStack(ItemStack stack) {
        this.setStackInSlot(0, stack);
    }

    public int getMaxTransferSize() {
        return !this.showGlobalTransferLimitSlider() && this.hasFilter() ? this.currentFilter.getMaxTransferSize() : this.maxTransferSize;
    }

    public void setMaxTransferSize(int maxTransferSize) {
        this.maxTransferSize = MathHelper.func_76125_a((int)maxTransferSize, (int)1, (int)Integer.MAX_VALUE);
        this.transferSize = MathHelper.func_76125_a((int)this.transferSize, (int)1, (int)this.maxTransferSize);
        if (this.hasFilter()) {
            this.currentFilter.setMaxTransferSize(this.maxTransferSize);
        }
    }

    public final boolean hasFilter() {
        return this.currentFilter != null;
    }

    @Nullable
    public final BaseFilter getFilter() {
        return this.currentFilter;
    }

    public final void setFilter(@Nullable BaseFilter newFilter) {
        this.currentFilter = newFilter;
        if (this.hasFilter()) {
            this.currentFilter.setDirtyNotifiable(this.dirtyNotifiable);
            this.currentFilter.setMaxTransferSize(this.maxTransferSize);
        }
        if (this.onFilterInstanceChange != null) {
            this.onFilterInstanceChange.run();
        }
    }

    public boolean showGlobalTransferLimitSlider() {
        return this.maxTransferSize > 0 && (!this.hasFilter() || this.getFilter().showGlobalTransferLimitSlider());
    }

    public void setBlacklistFilter(boolean blacklistFilter) {
        if (this.hasFilter()) {
            this.getFilter().setBlacklistFilter(blacklistFilter);
        }
        this.onFilterInstanceChange();
    }

    public final boolean isBlacklistFilter() {
        return this.hasFilter() && this.getFilter().isBlacklistFilter();
    }

    public int getTransferSize() {
        if (!this.showGlobalTransferLimitSlider()) {
            return this.getMaxTransferSize();
        }
        return this.transferSize;
    }

    public int getTransferLimit(int slotIndex) {
        if (this.isBlacklistFilter() || !this.hasFilter()) {
            return this.getTransferSize();
        }
        return this.currentFilter.getTransferLimit(slotIndex, this.getTransferSize());
    }

    public void setTransferSize(int transferSize) {
        this.transferSize = MathHelper.func_76125_a((int)transferSize, (int)1, (int)this.getMaxTransferSize());
        this.onFilterInstanceChange();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74782_a("FilterInventory", (NBTBase)super.serializeNBT());
        tagCompound.func_74768_a("TransferStackSize", this.getTransferSize());
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt.func_74775_l("FilterInventory"));
        this.setFilter(BaseFilter.getFilterFromStack(this.getFilterStack()));
        if (nbt.func_74764_b("TransferStackSize")) {
            this.transferSize = nbt.func_74762_e("TransferStackSize");
        }
    }

    public void handleLegacyNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("FilterInventory")) {
            super.deserializeNBT(nbt.func_74775_l("FilterInventory"));
            this.setFilter(BaseFilter.getFilterFromStack(this.getFilterStack()));
        }
        if (this.hasFilter()) {
            this.getFilter().getFilterReader().handleLegacyNBT(nbt);
        }
    }

    public IWidget initUI(GuiData data, PanelSyncManager manager) {
        IPanelHandler panel = manager.panel("filter_panel", (syncManager, syncHandler) -> {
            BaseFilter filter = this.hasFilter() ? this.getFilter() : BaseFilter.ERROR_FILTER;
            filter.setMaxTransferSize(this.getMaxTransferSize());
            return filter.createPopupPanel(syncManager);
        }, true);
        return (IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().coverChildrenHeight()).marginBottom(2)).widthRel(1.0f)).child((IWidget)((ItemSlot)((ItemSlot)new ItemSlot().slot(SyncHandlers.itemSlot((IItemHandlerModifiable)this, (int)0).filter(this::isItemValid).singletonSlotGroup(101).changeListener((newItem, onlyAmountChanged, client, init) -> {
            if (!this.isItemValid(newItem) && panel.isPanelOpen()) {
                panel.closePanel();
            }
        })).size(18)).marginRight(2)).background(new IDrawable[]{GTGuiTextures.SLOT, GTGuiTextures.FILTER_SLOT_OVERLAY.asIcon().size(16)}))).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().background(new IDrawable[]{GTGuiTextures.MC_BUTTON, GTGuiTextures.FILTER_SETTINGS_OVERLAY.asIcon().size(16)})).hoverBackground(new IDrawable[]{GuiTextures.MC_BUTTON_HOVERED, GTGuiTextures.FILTER_SETTINGS_OVERLAY.asIcon().size(16)})).setEnabledIf(w -> this.hasFilter())).onMousePressed(i -> {
            if (!panel.isPanelOpen()) {
                panel.openPanel();
            } else {
                panel.closePanel();
            }
            return true;
        }))).child((IWidget)((TextWidget)((TextWidget)this.getFilterKey().color(Integer.valueOf(-11184811)).shadow(Boolean.valueOf(false)).alignment(Alignment.CenterRight).asWidget().left(36)).right(0)).height(18));
    }

    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        NetworkUtils.writeItemStack((PacketBuffer)packetBuffer, (ItemStack)this.getFilterStack());
        packetBuffer.writeInt(this.maxTransferSize);
        packetBuffer.writeInt(this.transferSize);
    }

    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        this.setFilterStack(NetworkUtils.readItemStack((PacketBuffer)packetBuffer));
        this.setMaxTransferSize(packetBuffer.readInt());
        this.setTransferSize(packetBuffer.readInt());
    }
}

