/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IIntValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.covers.filter.IFilter;
import gregtech.common.covers.filter.MatchResult;
import gregtech.common.covers.filter.readers.BaseFilterReader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFilter
implements IFilter {
    public static final BaseFilter ERROR_FILTER = new BaseFilter(){
        private final BaseFilterReader filterReader = new BaseFilterReader(ItemStack.field_190927_a, 0);

        @Override
        public BaseFilterReader getFilterReader() {
            return this.filterReader;
        }

        @Override
        @NotNull
        public ModularPanel createPopupPanel(PanelSyncManager syncManager) {
            return (ModularPanel)GTGuis.createPopupPanel("error", 100, 100).child((IWidget)this.createWidgets(syncManager));
        }

        @Override
        @NotNull
        public ModularPanel createPanel(PanelSyncManager syncManager) {
            return (ModularPanel)GTGuis.createPanel("error", 100, 100).child(this.createWidgets(syncManager));
        }

        @Override
        @NotNull
        public Widget<?> createWidgets(PanelSyncManager syncManager) {
            return IKey.lang((String)"INVALID FILTER").alignment(Alignment.Center).asWidget();
        }

        @Override
        public IFilter.FilterType getType() {
            return IFilter.FilterType.ITEM;
        }
    };
    protected IDirtyNotifiable dirtyNotifiable;

    public abstract BaseFilterReader getFilterReader();

    @Override
    public final ItemStack getContainerStack() {
        return this.getFilterReader().getContainer();
    }

    @Nullable
    public static BaseFilter getFilterFromStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof MetaItem) {
            IFilter.Factory factory;
            MetaItem metaItem = (MetaItem)item;
            Object metaValueItem = metaItem.getItem(stack);
            IFilter.Factory factory2 = factory = metaValueItem == null ? null : ((MetaItem.MetaValueItem)metaValueItem).getFilterFactory();
            if (factory != null) {
                return factory.create(stack);
            }
        }
        return null;
    }

    public final void setBlacklistFilter(boolean blacklistFilter) {
        this.getFilterReader().setBlacklistFilter(blacklistFilter);
        this.markDirty();
    }

    @Override
    public final MatchResult match(Object toMatch) {
        if (toMatch instanceof ItemStack) {
            ItemStack stack = (ItemStack)toMatch;
            return this.matchItem(stack);
        }
        if (toMatch instanceof FluidStack) {
            FluidStack stack = (FluidStack)toMatch;
            return this.matchFluid(stack);
        }
        return MatchResult.NONE;
    }

    public MatchResult matchFluid(FluidStack fluidStack) {
        return MatchResult.NONE;
    }

    public MatchResult matchItem(ItemStack itemStack) {
        return MatchResult.NONE;
    }

    @Override
    public final boolean test(Object toTest) {
        boolean b = false;
        if (toTest instanceof ItemStack) {
            ItemStack stack = (ItemStack)toTest;
            b = this.testItem(stack);
        } else if (toTest instanceof FluidStack) {
            FluidStack stack = (FluidStack)toTest;
            b = this.testFluid(stack);
        }
        return b != this.isBlacklistFilter();
    }

    public boolean testFluid(FluidStack toTest) {
        return false;
    }

    public boolean testItem(ItemStack toTest) {
        return false;
    }

    @Override
    public final int getTransferLimit(Object o, int transferSize) {
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return this.getTransferLimit(stack, transferSize);
        }
        if (o instanceof FluidStack) {
            FluidStack stack = (FluidStack)o;
            return this.getTransferLimit(stack, transferSize);
        }
        return 0;
    }

    public int getTransferLimit(FluidStack stack, int transferSize) {
        return 0;
    }

    public int getTransferLimit(ItemStack stack, int transferSize) {
        return 0;
    }

    public final boolean isBlacklistFilter() {
        return this.getFilterReader().isBlacklistFilter();
    }

    public IWidget createBlacklistUI() {
        return (IWidget)((ParentWidget)new ParentWidget().coverChildren()).child((IWidget)new CycleButtonWidget().value((IIntValue)new BooleanSyncValue(this::isBlacklistFilter, this::setBlacklistFilter)).stateBackground(0, (IDrawable)GTGuiTextures.BUTTON_BLACKLIST[0]).stateBackground(1, (IDrawable)GTGuiTextures.BUTTON_BLACKLIST[1]).addTooltip(0, (IDrawable)IKey.lang((String)"cover.filter.blacklist.disabled")).addTooltip(1, (IDrawable)IKey.lang((String)"cover.filter.blacklist.enabled")));
    }

    @Override
    public final int getMaxTransferSize() {
        return this.getFilterReader().getMaxTransferRate();
    }

    @Override
    public final void setMaxTransferSize(int maxStackSize) {
        this.getFilterReader().setMaxTransferRate(maxStackSize);
    }

    @Override
    public boolean showGlobalTransferLimitSlider() {
        return this.isBlacklistFilter();
    }

    @Override
    public final void setDirtyNotifiable(IDirtyNotifiable dirtyNotifiable) {
        this.dirtyNotifiable = dirtyNotifiable;
        this.getFilterReader().setDirtyNotifiable(dirtyNotifiable);
    }

    @Override
    public final void markDirty() {
        if (this.dirtyNotifiable != null) {
            this.dirtyNotifiable.markAsDirty();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.getFilterReader().deserializeNBT(tag);
        this.markDirty();
    }

    public void writeInitialSyncData(PacketBuffer packetBuffer) {
    }

    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
    }
}

