/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.facade;

import com.google.common.collect.ImmutableList;
import gregtech.api.util.GTUtility;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;

public class FacadeHelper {
    private static ImmutableList<ItemStack> validFacadeItems = null;

    public static ImmutableList<ItemStack> getValidFacadeItems() {
        if (validFacadeItems == null) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (Item item : Item.field_150901_e) {
                if (!(item instanceof ItemBlock)) continue;
                for (ItemStack subItem : GTUtility.getAllSubItems(item)) {
                    if (!FacadeHelper.isValidFacade(subItem)) continue;
                    b.add((Object)subItem);
                }
            }
            validFacadeItems = b.build();
        }
        return validFacadeItems;
    }

    public static boolean isValidFacade(ItemStack itemStack) {
        IBlockState rawBlockState = FacadeHelper.lookupBlockForItemUnsafe(itemStack);
        return rawBlockState != null && !rawBlockState.func_177230_c().hasTileEntity(rawBlockState) && !rawBlockState.func_177230_c().func_149716_u() && rawBlockState.func_185901_i() == EnumBlockRenderType.MODEL && rawBlockState.func_185917_h();
    }

    public static IBlockState lookupBlockForItem(ItemStack itemStack) {
        IBlockState rawBlockState = FacadeHelper.lookupBlockForItemUnsafe(itemStack);
        if (rawBlockState == null) {
            return Blocks.field_150348_b.func_176223_P();
        }
        return rawBlockState;
    }

    private static IBlockState lookupBlockForItemUnsafe(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        ItemBlock itemBlock = (ItemBlock)item;
        Block block = itemBlock.func_179223_d();
        int blockMetadata = itemStack.func_77973_b().getMetadata(itemStack);
        try {
            return block.func_176203_a(blockMetadata);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

