/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.ender;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.sync.GTFluidSyncHandler;
import gregtech.api.util.FluidTankSwitchShim;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.virtualregistry.EntryTypes;
import gregtech.api.util.virtualregistry.VirtualEnderRegistry;
import gregtech.api.util.virtualregistry.entries.VirtualTank;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.ender.CoverAbstractEnderLink;
import gregtech.common.covers.filter.FluidFilterContainer;
import gregtech.common.mui.widget.GTFluidSlot;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class CoverEnderFluidLink
extends CoverAbstractEnderLink<VirtualTank>
implements CoverWithUI,
ITickable,
IControllable {
    public static final int TRANSFER_RATE = 8000;
    protected CoverPump.PumpMode pumpMode = CoverPump.PumpMode.IMPORT;
    private final FluidTankSwitchShim linkedTank = new FluidTankSwitchShim((IFluidTank)this.activeEntry);
    protected final FluidFilterContainer fluidFilter = new FluidFilterContainer(this);

    public CoverEnderFluidLink(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    @Override
    protected void updateLink() {
        super.updateLink();
        if (this.linkedTank != null) {
            this.linkedTank.changeTank((IFluidTank)this.activeEntry);
        }
    }

    @Override
    protected EntryTypes<VirtualTank> getType() {
        return EntryTypes.ENDER_FLUID;
    }

    @Override
    protected String identifier() {
        return "EFLink#";
    }

    public FluidFilterContainer getFluidFilterContainer() {
        return this.fluidFilter;
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return coverable.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        Textures.ENDER_FLUID_LINK.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    @Override
    public void onRemoval() {
        this.dropInventoryContents((IItemHandlerModifiable)this.fluidFilter);
    }

    public void func_73660_a() {
        if (this.isWorkingEnabled() && this.isIoEnabled()) {
            this.transferFluids();
        }
    }

    protected void transferFluids() {
        IFluidHandler fluidHandler = (IFluidHandler)this.getCoverableView().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getAttachedSide());
        if (fluidHandler == null) {
            return;
        }
        if (this.pumpMode == CoverPump.PumpMode.IMPORT) {
            GTTransferUtils.transferFluids(fluidHandler, (IFluidHandler)this.activeEntry, 8000, this.fluidFilter::test);
        } else if (this.pumpMode == CoverPump.PumpMode.EXPORT) {
            GTTransferUtils.transferFluids((IFluidHandler)this.activeEntry, fluidHandler, 8000, this.fluidFilter::test);
        }
    }

    public void setPumpMode(CoverPump.PumpMode pumpMode) {
        this.pumpMode = pumpMode;
        this.markDirty();
    }

    public CoverPump.PumpMode getPumpMode() {
        return this.pumpMode;
    }

    @Override
    protected IWidget createSlotWidget(VirtualTank entry) {
        GTFluidSyncHandler fluidTank = GTFluidSlot.sync(entry).accessibility(false, false);
        return (IWidget)((GTFluidSlot)((GTFluidSlot)new GTFluidSlot().size(18)).background(new IDrawable[]{GTGuiTextures.FLUID_SLOT})).syncHandler(fluidTank).marginRight(2);
    }

    @Override
    protected void deleteEntry(UUID uuid, String name) {
        VirtualEnderRegistry.deleteEntry(uuid, this.getType(), name, tank -> tank.getFluidAmount() == 0);
    }

    @Override
    protected IWidget createEntrySlot() {
        return (IWidget)((GTFluidSlot)((GTFluidSlot)new GTFluidSlot().size(18)).background(new IDrawable[]{GTGuiTextures.FLUID_SLOT})).syncHandler(this.linkedTank).marginRight(2);
    }

    @Override
    protected Flow createWidgets(GuiData data, PanelSyncManager syncManager) {
        this.getFluidFilterContainer().setMaxTransferSize(1);
        EnumSyncValue pumpMode = new EnumSyncValue(CoverPump.PumpMode.class, this::getPumpMode, this::setPumpMode);
        syncManager.syncValue("pump_mode", (SyncHandler)pumpMode);
        pumpMode.updateCacheFromSource(true);
        return (Flow)((Flow)super.createWidgets(data, syncManager).child(this.getFluidFilterContainer().initUI(data, syncManager))).child((IWidget)new CoverWithUI.EnumRowBuilder<CoverPump.PumpMode>(CoverPump.PumpMode.class).value((EnumSyncValue<CoverPump.PumpMode>)pumpMode).overlay((IDrawable[])GTGuiTextures.CONVEYOR_MODE_OVERLAY).lang("cover.pump.mode").build());
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("PumpMode", this.pumpMode.ordinal());
        tagCompound.func_74782_a("Filter", (NBTBase)this.fluidFilter.serializeNBT());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.pumpMode = CoverPump.PumpMode.values()[tagCompound.func_74762_e("PumpMode")];
        this.fluidFilter.deserializeNBT(tagCompound.func_74775_l("Filter"));
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)((IFluidHandler)this.activeEntry));
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }
}

