/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.ender;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncHandler;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.ListWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IControllable;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.virtualregistry.EntryTypes;
import gregtech.api.util.virtualregistry.VirtualEnderRegistry;
import gregtech.api.util.virtualregistry.VirtualEntry;
import gregtech.common.mui.widget.InteractableText;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverAbstractEnderLink<T extends VirtualEntry>
extends CoverBase
implements CoverWithUI,
ITickable,
IControllable {
    protected static final Pattern COLOR_INPUT_PATTERN = Pattern.compile("[0-9a-fA-F]*");
    protected T activeEntry = null;
    protected String color = "FFFFFFFF";
    protected UUID playerUUID = null;
    private boolean isPrivate = false;
    private boolean workingEnabled = true;
    private boolean ioEnabled = false;

    public CoverAbstractEnderLink(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
        this.updateLink();
    }

    protected void updateLink() {
        this.activeEntry = VirtualEnderRegistry.getOrCreateEntry(this.getOwner(), this.getType(), this.createName());
        ((VirtualEntry)this.activeEntry).setColor(this.color);
        this.markDirty();
    }

    protected abstract EntryTypes<T> getType();

    public String getColorStr() {
        return this.color;
    }

    protected final String createName() {
        return this.identifier() + this.color;
    }

    protected abstract String identifier();

    protected final UUID getOwner() {
        return this.isPrivate ? this.playerUUID : null;
    }

    @Override
    public void readCustomData(int discriminator, @NotNull PacketBuffer buf) {
        super.readCustomData(discriminator, buf);
        if (discriminator == GregtechDataCodes.UPDATE_PRIVATE) {
            this.setPrivate(buf.readBoolean());
            this.updateLink();
        }
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        if (!this.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void onAttachment(@NotNull CoverableView coverableView, @NotNull EnumFacing side, @Nullable EntityPlayer player, @NotNull ItemStack itemStack) {
        super.onAttachment(coverableView, side, player, itemStack);
        if (player != null) {
            this.playerUUID = player.func_110124_au();
        }
    }

    public void updateColor(String str) {
        if (str.length() == 8) {
            this.color = str.toUpperCase();
            this.updateLink();
        }
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        ModularPanel panel = GTGuis.createPanel(this, 176, 192);
        this.playerUUID = guiData.getPlayer().func_110124_au();
        return ((ModularPanel)((ModularPanel)panel.child((IWidget)CoverWithUI.createTitleRow(this.getPickItem()))).child((IWidget)this.createWidgets((GuiData)guiData, guiSyncManager))).bindPlayerInventory();
    }

    protected Flow createWidgets(GuiData data, PanelSyncManager syncManager) {
        StringSyncValue name = new StringSyncValue(this::getColorStr, this::updateColor);
        IPanelHandler entrySelectorSH = syncManager.panel("entry_selector", this.entrySelector(this.getType()), true);
        return (Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().coverChildrenHeight()).top(24)).margin(7, 0)).widthRel(1.0f)).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().marginBottom(2)).coverChildrenHeight()).child(this.createPrivateButton())).child(this.createColorIcon())).child((IWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().height(18)).value((IStringValue)name).setPattern(COLOR_INPUT_PATTERN).widthRel(0.5f)).marginRight(2))).child(this.createEntrySlot())).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().overlay(new IDrawable[]{GTGuiTextures.MENU_OVERLAY})).background(new IDrawable[]{GTGuiTextures.MC_BUTTON})).disableHoverBackground()).addTooltipLine((IDrawable)IKey.lang((String)"cover.generic.ender.open_selector"))).onMousePressed(i -> {
            if (entrySelectorSH.isPanelOpen()) {
                entrySelectorSH.closePanel();
                entrySelectorSH.deleteCachedPanel();
            } else {
                entrySelectorSH.openPanel();
            }
            return true;
        })))).child(this.createIoRow());
    }

    protected abstract IWidget createEntrySlot();

    protected IWidget createColorIcon() {
        return (IWidget)((Widget)new DynamicDrawable(() -> new Rectangle().setColor(((VirtualEntry)this.activeEntry).getColor()).asIcon().size(16)).asWidget().background(new IDrawable[]{GTGuiTextures.SLOT}).size(18)).marginRight(2);
    }

    protected IWidget createPrivateButton() {
        return (IWidget)((ToggleButton)((ToggleButton)new ToggleButton().value((IBoolValue)new BooleanSyncValue(this::isPrivate, this::setPrivate)).tooltip(tooltip -> tooltip.setAutoUpdate(true))).background(new IDrawable[]{GTGuiTextures.PRIVATE_MODE_BUTTON[0]}).hoverBackground(new IDrawable[]{GTGuiTextures.PRIVATE_MODE_BUTTON[0]}).selectedBackground(new IDrawable[]{GTGuiTextures.PRIVATE_MODE_BUTTON[1]}).selectedHoverBackground(new IDrawable[]{GTGuiTextures.PRIVATE_MODE_BUTTON[1]}).tooltipBuilder(tooltip -> tooltip.addLine((IDrawable)IKey.lang((String)(this.isPrivate ? "cover.ender_fluid_link.private.tooltip.enabled" : "cover.ender_fluid_link.private.tooltip.disabled"))))).marginRight(2);
    }

    protected IWidget createIoRow() {
        return (IWidget)((Flow)((Flow)Flow.row().marginBottom(2)).coverChildrenHeight()).child((IWidget)((ToggleButton)((ToggleButton)new ToggleButton().value((IBoolValue)new BooleanSyncValue(this::isIoEnabled, this::setIoEnabled)).overlay(new IDrawable[]{IKey.lang(() -> this.ioEnabled ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled").color(Integer.valueOf(Color.WHITE.darker(1)))})).widthRel(0.6f)).left(0));
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.workingEnabled = isActivationAllowed;
    }

    public boolean isIoEnabled() {
        return this.ioEnabled;
    }

    protected void setIoEnabled(boolean ioEnabled) {
        this.ioEnabled = ioEnabled;
    }

    private boolean isPrivate() {
        return this.isPrivate;
    }

    private void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
        this.updateLink();
        this.writeCustomData(GregtechDataCodes.UPDATE_PRIVATE, buffer -> buffer.writeBoolean(this.isPrivate));
    }

    @Override
    public void writeInitialSyncData(PacketBuffer packetBuffer) {
        packetBuffer.func_180714_a(this.playerUUID == null ? "null" : this.playerUUID.toString());
    }

    @Override
    public void readInitialSyncData(PacketBuffer packetBuffer) {
        String uuidStr = packetBuffer.func_150789_c(36);
        this.playerUUID = uuidStr.equals("null") ? null : UUID.fromString(uuidStr);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.ioEnabled = nbt.func_74767_n("IOAllowed");
        this.isPrivate = nbt.func_74767_n("Private");
        this.workingEnabled = nbt.func_74767_n("WorkingAllowed");
        this.playerUUID = UUID.fromString(nbt.func_74779_i("PlacedUUID"));
        int color = nbt.func_74762_e("Frequency");
        this.color = Integer.toHexString(color).toUpperCase();
        this.updateLink();
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("IOAllowed", this.ioEnabled);
        nbt.func_74757_a("Private", this.isPrivate);
        nbt.func_74757_a("WorkingAllowed", this.workingEnabled);
        nbt.func_74778_a("PlacedUUID", this.playerUUID.toString());
        nbt.func_74768_a("Frequency", ((VirtualEntry)this.activeEntry).getColor());
    }

    protected PanelSyncHandler.IPanelBuilder entrySelector(EntryTypes<T> type) {
        return (syncManager, syncHandler) -> {
            ArrayList<IWidget> rows = new ArrayList<IWidget>();
            for (String name : VirtualEnderRegistry.getEntryNames(this.getOwner(), type)) {
                rows.add(this.createRow(name, syncManager, type));
            }
            return (ModularPanel)((ModularPanel)GTGuis.createPopupPanel("entry_selector", 168, 112, true).child((IWidget)((TextWidget)IKey.lang((String)"cover.generic.ender.known_channels").color(Integer.valueOf(-14540254)).asWidget().top(6)).left(4))).child((IWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)new ListWidget().children(rows).background(new IDrawable[]{GTGuiTextures.DISPLAY.asIcon().width(160).height(92)})).paddingTop(1)).size(156, 88)).left(4)).bottom(6));
        };
    }

    protected PanelSyncHandler.IPanelBuilder entryDescription(String key, T entry) {
        return (syncManager, syncHandler) -> {
            final StringSyncValue sync = new StringSyncValue(entry::getDescription, entry::setDescription);
            return (ModularPanel)((ModularPanel)GTGuis.createPopupPanel(key, 168, 42, true).child((IWidget)((TextWidget)IKey.lang((String)"cover.generic.ender.set_description.title", (Object[])new Object[]{entry.getColorStr()}).color(Integer.valueOf(-14540254)).asWidget().left(4)).top(6))).child((IWidget)((TextFieldWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget(){

                @NotNull
                public Interactable.Result onKeyPressed(char character, int keyCode) {
                    Interactable.Result result = super.onKeyPressed(character, keyCode);
                    if (result == Interactable.Result.SUCCESS && keyCode == 28) {
                        sync.setStringValue(this.getText());
                        if (syncHandler.isPanelOpen()) {
                            syncHandler.closePanel();
                        }
                    }
                    return result;
                }
            }.setTextColor(Color.WHITE.darker(1)).value((IStringValue)sync).widthRel(0.95f)).height(18)).alignX(0.5f)).bottom(6));
        };
    }

    protected IWidget createRow(String name, PanelSyncManager syncManager, EntryTypes<T> type) {
        Object entry = VirtualEnderRegistry.getEntry(this.getOwner(), type, name);
        String key = String.format("entry#%s_description", ((VirtualEntry)entry).getColorStr());
        String syncKey = PanelSyncManager.makeSyncKey((String)key, (int)(this.isPrivate ? 1 : 0));
        PanelSyncHandler panelHandler = (PanelSyncHandler)syncManager.panel(syncKey, this.entryDescription(key, entry), true);
        EnderCoverSyncHandler syncHandler = new EnderCoverSyncHandler();
        syncManager.syncValue(key + "_handler", (SyncHandler)syncHandler);
        return (IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().left(4)).marginBottom(2)).height(18)).widthRel(0.98f)).setEnabledIf(row -> VirtualEnderRegistry.hasEntry(this.getOwner(), type, name))).child((IWidget)((Widget)((Widget)new Rectangle().setColor(((VirtualEntry)entry).getColor()).asWidget().marginRight(4)).size(16)).background(new IDrawable[]{GTGuiTextures.SLOT.asIcon().size(18)}).top(1))).child((IWidget)((TextWidget)((TextWidget)((TextWidget)((TextWidget)((TextWidget)new InteractableText<T>(entry, this::updateColor).tooltip(tooltip -> tooltip.setAutoUpdate(true))).tooltipBuilder(tooltip -> {
            String desc = entry.getDescription();
            if (!desc.isEmpty()) {
                tooltip.add(desc);
            }
        })).width(64)).height(16)).top(1)).marginRight(4))).child((IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().overlay(new IDrawable[]{GuiTextures.GEAR})).addTooltipLine((IDrawable)IKey.lang((String)"cover.generic.ender.set_description.tooltip"))).onMousePressed(i -> {
            if (panelHandler.isPanelOpen()) {
                panelHandler.closePanel();
            } else {
                panelHandler.openPanel();
            }
            return true;
        }))).child(this.createSlotWidget(entry))).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().overlay(new IDrawable[]{GTGuiTextures.BUTTON_CROSS})).setEnabledIf(w -> !Objects.equals(entry.getColor(), ((VirtualEntry)this.activeEntry).getColor()))).addTooltipLine((IDrawable)IKey.lang((String)"cover.generic.ender.delete_entry"))).onMousePressed(i -> {
            this.deleteEntry(this.getOwner(), name);
            syncHandler.syncToServer(1, buffer -> {
                NetworkUtils.writeStringSafe((PacketBuffer)buffer, (String)(this.getOwner() == null ? "null" : this.getOwner().toString()));
                NetworkUtils.writeStringSafe((PacketBuffer)buffer, (String)name);
            });
            return true;
        }));
    }

    protected abstract IWidget createSlotWidget(T var1);

    protected abstract void deleteEntry(UUID var1, String var2);

    private final class EnderCoverSyncHandler
    extends SyncHandler {
        private static final int DELETE_ENTRY = 1;

        private EnderCoverSyncHandler() {
        }

        public void readOnClient(int i, PacketBuffer packetBuffer) {
        }

        public void readOnServer(int i, PacketBuffer packetBuffer) {
            if (i == 1) {
                String s = NetworkUtils.readStringSafe((PacketBuffer)packetBuffer);
                UUID uuid = "null".equals(s) ? null : UUID.fromString(s);
                String name = NetworkUtils.readStringSafe((PacketBuffer)packetBuffer);
                CoverAbstractEnderLink.this.deleteEntry(uuid, name);
            }
        }
    }
}

