/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.detector;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.util.RedstoneUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.detector.CoverDetectorBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CoverDetectorItem
extends CoverDetectorBase
implements ITickable {
    public CoverDetectorItem(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return coverable.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) != null;
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        Textures.DETECTOR_ITEM.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    public void func_73660_a() {
        if (this.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IItemHandler itemHandler = (IItemHandler)this.getCoverableView().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler == null) {
            return;
        }
        int storedItems = 0;
        int itemCapacity = itemHandler.getSlots() * itemHandler.getSlotLimit(0);
        if (itemCapacity == 0) {
            return;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            storedItems += itemHandler.getStackInSlot(i).func_190916_E();
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneValue(storedItems, itemCapacity, this.isInverted()));
    }
}

