/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.detector;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.util.RedstoneUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.detector.CoverDetectorBase;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityPowerSubstation;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import org.jetbrains.annotations.NotNull;

public class CoverDetectorEnergy
extends CoverDetectorBase
implements ITickable {
    public CoverDetectorEnergy(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return coverable.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null) != null || coverable instanceof MetaTileEntityPowerSubstation;
    }

    public long getCoverHolderCapacity() {
        CoverableView coverableView = this.getCoverableView();
        if (coverableView instanceof MetaTileEntityPowerSubstation) {
            MetaTileEntityPowerSubstation pss = (MetaTileEntityPowerSubstation)coverableView;
            return pss.getCapacityLong();
        }
        IEnergyContainer energyContainer = (IEnergyContainer)this.getCoverableView().getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null);
        if (energyContainer != null) {
            return energyContainer.getEnergyCapacity();
        }
        return 0L;
    }

    public long getCoverHolderStored() {
        CoverableView coverableView = this.getCoverableView();
        if (coverableView instanceof MetaTileEntityPowerSubstation) {
            MetaTileEntityPowerSubstation pss = (MetaTileEntityPowerSubstation)coverableView;
            return pss.getStoredLong();
        }
        IEnergyContainer energyContainer = (IEnergyContainer)this.getCoverableView().getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null);
        if (energyContainer != null) {
            return energyContainer.getEnergyStored();
        }
        return 0L;
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        Textures.DETECTOR_ENERGY.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    public void func_73660_a() {
        if (this.getOffsetTimer() % 20L != 0L) {
            return;
        }
        long storedEnergy = this.getCoverHolderStored();
        long energyCapacity = this.getCoverHolderCapacity();
        if (energyCapacity == 0L) {
            return;
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneValue(storedEnergy, energyCapacity, this.isInverted()));
    }
}

