/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.TransferMode;
import gregtech.common.covers.filter.SmartItemFilter;
import gregtech.common.pipelike.itempipe.net.ItemNetHandler;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CoverRoboticArm
extends CoverConveyor {
    protected TransferMode transferMode = TransferMode.TRANSFER_ANY;
    protected int itemsTransferBuffered;

    public CoverRoboticArm(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, int tier, int itemsPerSecond) {
        super(definition, coverableView, attachedSide, tier, itemsPerSecond);
        this.itemFilterContainer.setMaxTransferSize(1);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        if (this.conveyorMode == CoverConveyor.ConveyorMode.EXPORT) {
            Textures.ARM_OVERLAY.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
        } else {
            Textures.ARM_OVERLAY_INVERTED.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
        }
    }

    @Override
    protected int doTransferItems(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        int n;
        if (this.conveyorMode == CoverConveyor.ConveyorMode.EXPORT && itemHandler instanceof ItemNetHandler && this.transferMode == TransferMode.KEEP_EXACT) {
            return 0;
        }
        if (this.conveyorMode == CoverConveyor.ConveyorMode.IMPORT && myItemHandler instanceof ItemNetHandler && this.transferMode == TransferMode.KEEP_EXACT) {
            return 0;
        }
        switch (this.transferMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TRANSFER_ANY: {
                n = this.doTransferItemsAny(itemHandler, myItemHandler, maxTransferAmount);
                break;
            }
            case TRANSFER_EXACT: {
                n = this.doTransferExact(itemHandler, myItemHandler, maxTransferAmount);
                break;
            }
            case KEEP_EXACT: {
                n = this.doKeepExact(itemHandler, myItemHandler, maxTransferAmount);
            }
        }
        return n;
    }

    protected int doTransferExact(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        Map<ItemStack, CoverConveyor.TypeItemInfo> sourceItemAmount = this.doCountSourceInventoryItemsByType(itemHandler, myItemHandler);
        Iterator<ItemStack> iterator = sourceItemAmount.keySet().iterator();
        while (iterator.hasNext()) {
            CoverConveyor.TypeItemInfo sourceInfo = sourceItemAmount.get(iterator.next());
            int itemAmount = sourceInfo.totalCount;
            int itemToMoveAmount = this.itemFilterContainer.getTransferLimit(sourceInfo.itemStack);
            if (this.itemFilterContainer.getFilter() instanceof SmartItemFilter && !this.itemFilterContainer.isBlacklistFilter() && this.itemFilterContainer.getTransferSize() > 1 && itemToMoveAmount * 2 <= itemAmount) {
                int maxMultiplier = Math.floorDiv(maxTransferAmount, itemToMoveAmount);
                itemToMoveAmount *= Math.min(this.itemFilterContainer.getTransferSize(), maxMultiplier);
            }
            if (itemAmount >= itemToMoveAmount) {
                sourceInfo.totalCount = itemToMoveAmount;
                continue;
            }
            iterator.remove();
        }
        int itemsTransferred = 0;
        int maxTotalTransferAmount = maxTransferAmount + this.itemsTransferBuffered;
        boolean notEnoughTransferRate = false;
        for (CoverConveyor.TypeItemInfo itemInfo : sourceItemAmount.values()) {
            if (maxTotalTransferAmount >= itemInfo.totalCount) {
                boolean result = this.doTransferItemsExact(itemHandler, myItemHandler, itemInfo);
                itemsTransferred += result ? itemInfo.totalCount : 0;
                maxTotalTransferAmount -= result ? itemInfo.totalCount : 0;
                continue;
            }
            notEnoughTransferRate = true;
        }
        this.itemsTransferBuffered = itemsTransferred == 0 && notEnoughTransferRate ? (this.itemsTransferBuffered += maxTransferAmount) : 0;
        return Math.min(itemsTransferred, maxTransferAmount);
    }

    protected int doKeepExact(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        Map<Integer, CoverConveyor.GroupItemInfo> currentItemAmount = this.doCountDestinationInventoryItemsByMatchIndex(itemHandler, myItemHandler);
        Map<Integer, CoverConveyor.GroupItemInfo> sourceItemAmounts = this.doCountDestinationInventoryItemsByMatchIndex(myItemHandler, itemHandler);
        Iterator<Integer> iterator = sourceItemAmounts.keySet().iterator();
        while (iterator.hasNext()) {
            int filterSlotIndex = iterator.next();
            CoverConveyor.GroupItemInfo sourceInfo = sourceItemAmounts.get(filterSlotIndex);
            int itemToKeepAmount = this.itemFilterContainer.getTransferLimit(sourceInfo.filterSlot);
            if (this.itemFilterContainer.getFilter() instanceof SmartItemFilter && this.itemFilterContainer.getTransferSize() > 1 && itemToKeepAmount * 2 <= sourceInfo.totalCount) {
                int maxMultiplier = Math.floorDiv(sourceInfo.totalCount, itemToKeepAmount);
                itemToKeepAmount *= Math.min(this.itemFilterContainer.getTransferSize(), maxMultiplier);
            }
            int itemAmount = 0;
            if (currentItemAmount.containsKey(filterSlotIndex)) {
                CoverConveyor.GroupItemInfo destItemInfo = currentItemAmount.get(filterSlotIndex);
                itemAmount = destItemInfo.totalCount;
            }
            if (itemAmount < itemToKeepAmount) {
                sourceInfo.totalCount = itemToKeepAmount - itemAmount;
                continue;
            }
            iterator.remove();
        }
        return this.doTransferItemsByGroup(itemHandler, myItemHandler, sourceItemAmounts, maxTransferAmount);
    }

    public int getBuffer() {
        return this.itemsTransferBuffered;
    }

    public void buffer(int amount) {
        this.itemsTransferBuffered += amount;
    }

    public void clearBuffer() {
        this.itemsTransferBuffered = 0;
    }

    public void setTransferMode(TransferMode transferMode) {
        if (this.transferMode != transferMode) {
            this.transferMode = transferMode;
            this.getCoverableView().markDirty();
            this.itemFilterContainer.setMaxTransferSize(transferMode.maxStackSize);
            this.writeCustomData(GregtechDataCodes.UPDATE_TRANSFER_MODE, buffer -> buffer.writeByte(this.transferMode.ordinal()));
        }
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    private boolean shouldDisplayAmountSlider() {
        if (this.transferMode == TransferMode.TRANSFER_ANY) {
            return false;
        }
        return this.itemFilterContainer.showGlobalTransferLimitSlider();
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        return (ModularPanel)super.buildUI(guiData, guiSyncManager).height(248);
    }

    @Override
    protected ParentWidget<Flow> createUI(GuiData data, PanelSyncManager guiSyncManager) {
        EnumSyncValue transferMode = new EnumSyncValue(TransferMode.class, this::getTransferMode, this::setTransferMode);
        guiSyncManager.syncValue("transfer_mode", (SyncHandler)transferMode);
        StringSyncValue filterTransferSize = new StringSyncValue(() -> String.valueOf(this.itemFilterContainer.getTransferSize()), s -> this.itemFilterContainer.setTransferSize(Integer.parseInt(s)));
        filterTransferSize.updateCacheFromSource(true);
        return (ParentWidget)((Flow)super.createUI(data, guiSyncManager).child((IWidget)new CoverWithUI.EnumRowBuilder<TransferMode>(TransferMode.class).value((EnumSyncValue<TransferMode>)transferMode).lang("cover.generic.transfer_mode").overlay((IDrawable[])GTGuiTextures.TRANSFER_MODE_OVERLAY).build())).child((IWidget)((Flow)((Flow)Flow.row().right(0)).coverChildrenHeight()).child((IWidget)((TextFieldWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().widthRel(0.5f)).right(0)).setEnabledIf(w -> this.shouldDisplayAmountSlider())).setNumbers(0, Integer.MAX_VALUE).value((IStringValue)filterTransferSize).setTextColor(Color.WHITE.darker(1))));
    }

    @Override
    protected int getMaxStackSize() {
        return this.getTransferMode().maxStackSize;
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeByte(this.transferMode.ordinal());
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.transferMode = TransferMode.VALUES[packetBuffer.readByte()];
        this.itemFilterContainer.setMaxTransferSize(this.transferMode.maxStackSize);
    }

    @Override
    public void readCustomData(int discriminator, @NotNull PacketBuffer buf) {
        super.readCustomData(discriminator, buf);
        if (discriminator == GregtechDataCodes.UPDATE_TRANSFER_MODE) {
            this.transferMode = TransferMode.VALUES[buf.readByte()];
            this.itemFilterContainer.setMaxTransferSize(this.transferMode.maxStackSize);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferMode", this.transferMode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.transferMode = TransferMode.VALUES[tagCompound.func_74762_e("TransferMode")];
        this.itemFilterContainer.setMaxTransferSize(this.transferMode.maxStackSize);
        super.readFromNBT(tagCompound);
    }
}

