/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.FluidHandlerDelegate;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.GTTransferUtils;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.covers.DistributionMode;
import gregtech.common.covers.IIOMode;
import gregtech.common.covers.ManualImportExportMode;
import gregtech.common.covers.filter.FluidFilterContainer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverPump
extends CoverBase
implements CoverWithUI,
ITickable,
IControllable {
    public final int tier;
    public final int maxFluidTransferRate;
    protected int transferRate;
    protected PumpMode pumpMode = PumpMode.EXPORT;
    protected ManualImportExportMode manualImportExportMode = ManualImportExportMode.DISABLED;
    protected DistributionMode distributionMode = DistributionMode.INSERT_FIRST;
    protected int fluidLeftToTransferLastSecond;
    private CoverableFluidHandlerWrapper fluidHandlerWrapper;
    protected boolean isWorkingAllowed = true;
    protected FluidFilterContainer fluidFilterContainer;
    protected BucketMode bucketMode = BucketMode.MILLI_BUCKET;

    public CoverPump(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, int tier, int mbPerTick) {
        super(definition, coverableView, attachedSide);
        this.tier = tier;
        this.maxFluidTransferRate = mbPerTick;
        this.fluidLeftToTransferLastSecond = this.transferRate = mbPerTick;
        this.fluidFilterContainer = new FluidFilterContainer(this);
    }

    public void setStringTransferRate(String s) {
        this.fluidFilterContainer.setTransferSize(this.getBucketMode() == BucketMode.MILLI_BUCKET ? Integer.parseInt(s) : Integer.parseInt(s) * 1000);
    }

    public String getStringTransferRate() {
        return String.valueOf(this.getBucketMode() == BucketMode.MILLI_BUCKET ? this.fluidFilterContainer.getTransferSize() : this.fluidFilterContainer.getTransferSize() / 1000);
    }

    public void setTransferRate(int transferRate) {
        if (this.bucketMode == BucketMode.BUCKET) {
            transferRate *= 1000;
        }
        this.transferRate = MathHelper.func_76125_a((int)transferRate, (int)1, (int)this.maxFluidTransferRate);
        this.markDirty();
    }

    public int getTransferRate() {
        return this.bucketMode == BucketMode.BUCKET ? this.transferRate / 1000 : this.transferRate;
    }

    protected void adjustTransferRate(int amount) {
        this.setTransferRate(this.transferRate + (amount *= this.bucketMode == BucketMode.BUCKET ? 1000 : 1));
    }

    public void setPumpMode(PumpMode pumpMode) {
        this.pumpMode = pumpMode;
        this.writeCustomData(GregtechDataCodes.UPDATE_COVER_MODE, buf -> buf.func_179249_a((Enum)pumpMode));
        this.markDirty();
    }

    public PumpMode getPumpMode() {
        return this.pumpMode;
    }

    public void setBucketMode(BucketMode bucketMode) {
        this.bucketMode = bucketMode;
        if (this.bucketMode == BucketMode.BUCKET) {
            this.setTransferRate(this.transferRate / 1000 * 1000);
        }
        this.markDirty();
    }

    public BucketMode getBucketMode() {
        return this.bucketMode;
    }

    public ManualImportExportMode getManualImportExportMode() {
        return this.manualImportExportMode;
    }

    protected void setManualImportExportMode(ManualImportExportMode manualImportExportMode) {
        this.manualImportExportMode = manualImportExportMode;
        this.markDirty();
    }

    public FluidFilterContainer getFluidFilterContainer() {
        return this.fluidFilterContainer;
    }

    public void func_73660_a() {
        long timer = this.getOffsetTimer();
        if (this.isWorkingAllowed && this.fluidLeftToTransferLastSecond > 0) {
            this.fluidLeftToTransferLastSecond -= this.doTransferFluids(this.fluidLeftToTransferLastSecond);
        }
        if (timer % 20L == 0L) {
            this.fluidLeftToTransferLastSecond = this.transferRate;
        }
    }

    protected int doTransferFluids(int transferLimit) {
        TileEntity tileEntity = this.getNeighbor(this.getAttachedSide());
        IFluidHandler fluidHandler = tileEntity == null ? null : (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getAttachedSide().func_176734_d());
        IFluidHandler myFluidHandler = (IFluidHandler)this.getCoverableView().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getAttachedSide());
        if (fluidHandler == null || myFluidHandler == null) {
            return 0;
        }
        return this.doTransferFluidsInternal(myFluidHandler, fluidHandler, transferLimit);
    }

    protected int doTransferFluidsInternal(IFluidHandler myFluidHandler, IFluidHandler fluidHandler, int transferLimit) {
        if (this.pumpMode == PumpMode.IMPORT) {
            return GTTransferUtils.transferFluids(fluidHandler, myFluidHandler, transferLimit, this.fluidFilterContainer::test);
        }
        if (this.pumpMode == PumpMode.EXPORT) {
            return GTTransferUtils.transferFluids(myFluidHandler, fluidHandler, transferLimit, this.fluidFilterContainer::test);
        }
        return 0;
    }

    protected boolean checkInputFluid(FluidStack fluidStack) {
        return this.fluidFilterContainer.test(fluidStack);
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        ModularPanel panel = GTGuis.createPanel(this, 176, 192);
        this.getFluidFilterContainer().setMaxTransferSize(this.getMaxTransferRate());
        return ((ModularPanel)((ModularPanel)panel.child((IWidget)CoverWithUI.createTitleRow(this.getPickItem()))).child(this.createUI((GuiData)guiData, guiSyncManager))).bindPlayerInventory();
    }

    protected ParentWidget<?> createUI(GuiData data, PanelSyncManager syncManager) {
        EnumSyncValue manualIOmode = new EnumSyncValue(ManualImportExportMode.class, this::getManualImportExportMode, this::setManualImportExportMode);
        IntSyncValue throughput = new IntSyncValue(this::getTransferRate, this::setTransferRate);
        StringSyncValue throughputString = new StringSyncValue(() -> ((IntSyncValue)throughput).getStringValue(), arg_0 -> ((IntSyncValue)throughput).setStringValue(arg_0));
        EnumSyncValue pumpMode = new EnumSyncValue(PumpMode.class, this::getPumpMode, this::setPumpMode);
        syncManager.syncValue("manual_io", (SyncHandler)manualIOmode);
        syncManager.syncValue("pump_mode", (SyncHandler)pumpMode);
        syncManager.syncValue("throughput", (SyncHandler)throughput);
        Flow column = (Flow)((Flow)((Flow)((Flow)Flow.column().top(24)).margin(7, 0)).widthRel(1.0f)).coverChildrenHeight();
        if (this.createThroughputRow()) {
            column.child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().coverChildrenHeight()).marginBottom(2)).widthRel(1.0f)).child((IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().left(0)).width(18)).onMousePressed(mouseButton -> {
                int val = throughput.getValue() - this.getIncrementValue(MouseData.create((int)mouseButton));
                throughput.setValue((Object)val);
                return true;
            }).onUpdateListener(w -> w.overlay(new IDrawable[]{this.createAdjustOverlay(false)})))).child((IWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().left(18)).right(18)).setTextColor(Color.WHITE.darker(1)).setNumbers(1, this.maxFluidTransferRate).value((IStringValue)throughputString).background(new IDrawable[]{GTGuiTextures.DISPLAY}))).child((IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().right(0)).width(18)).onMousePressed(mouseButton -> {
                int val = throughput.getValue() + this.getIncrementValue(MouseData.create((int)mouseButton));
                throughput.setValue((Object)val);
                return true;
            }).onUpdateListener(w -> w.overlay(new IDrawable[]{this.createAdjustOverlay(true)}))));
        }
        if (this.createFilterRow()) {
            column.child(this.getFluidFilterContainer().initUI(data, syncManager));
        }
        if (this.createManualIOModeRow()) {
            column.child((IWidget)new CoverWithUI.EnumRowBuilder<ManualImportExportMode>(ManualImportExportMode.class).value((EnumSyncValue<ManualImportExportMode>)manualIOmode).lang("cover.generic.manual_io").overlay(new IDrawable[]{new DynamicDrawable(() -> ((PumpMode)pumpMode.getValue()).isImport() ? GTGuiTextures.MANUAL_IO_OVERLAY_OUT[0] : GTGuiTextures.MANUAL_IO_OVERLAY_IN[0]), new DynamicDrawable(() -> ((PumpMode)pumpMode.getValue()).isImport() ? GTGuiTextures.MANUAL_IO_OVERLAY_OUT[1] : GTGuiTextures.MANUAL_IO_OVERLAY_IN[1]), new DynamicDrawable(() -> ((PumpMode)pumpMode.getValue()).isImport() ? GTGuiTextures.MANUAL_IO_OVERLAY_OUT[2] : GTGuiTextures.MANUAL_IO_OVERLAY_IN[2])}).build());
        }
        if (this.createPumpModeRow()) {
            column.child((IWidget)new CoverWithUI.EnumRowBuilder<PumpMode>(PumpMode.class).value((EnumSyncValue<PumpMode>)pumpMode).lang("cover.pump.mode").overlay((IDrawable[])GTGuiTextures.CONVEYOR_MODE_OVERLAY).build());
        }
        return column;
    }

    protected boolean createThroughputRow() {
        return true;
    }

    protected boolean createFilterRow() {
        return true;
    }

    protected boolean createManualIOModeRow() {
        return true;
    }

    protected boolean createPumpModeRow() {
        return true;
    }

    protected int getMaxTransferRate() {
        return 1;
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        if (!this.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void readCustomData(int discriminator, @NotNull PacketBuffer buf) {
        super.readCustomData(discriminator, buf);
        if (discriminator == GregtechDataCodes.UPDATE_COVER_MODE) {
            this.pumpMode = (PumpMode)buf.func_179257_a(PumpMode.class);
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeByte(this.pumpMode.ordinal());
        this.getFluidFilterContainer().writeInitialSyncData(packetBuffer);
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.pumpMode = PumpMode.VALUES[packetBuffer.readByte()];
        this.getFluidFilterContainer().readInitialSyncData(packetBuffer);
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return coverable.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
    }

    @Override
    public boolean canInteractWithOutputSide() {
        return true;
    }

    @Override
    public void onRemoval() {
        this.dropInventoryContents((IItemHandlerModifiable)this.fluidFilterContainer);
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        if (this.pumpMode == PumpMode.EXPORT) {
            Textures.PUMP_OVERLAY.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
        } else {
            Textures.PUMP_OVERLAY_INVERTED.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
        }
    }

    @Override
    public <T> T getCapability(@NotNull Capability<T> capability, T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (defaultValue == null) {
                return null;
            }
            IFluidHandler delegate = (IFluidHandler)defaultValue;
            if (this.fluidHandlerWrapper == null || this.fluidHandlerWrapper.delegate != delegate) {
                this.fluidHandlerWrapper = new CoverableFluidHandlerWrapper(delegate);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandlerWrapper);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingAllowed;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.isWorkingAllowed = isActivationAllowed;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferRate", this.transferRate);
        tagCompound.func_74768_a("PumpMode", this.pumpMode.ordinal());
        tagCompound.func_74768_a("DistributionMode", this.distributionMode.ordinal());
        tagCompound.func_74757_a("WorkingAllowed", this.isWorkingAllowed);
        tagCompound.func_74768_a("ManualImportExportMode", this.manualImportExportMode.ordinal());
        tagCompound.func_74768_a("BucketMode", this.bucketMode.ordinal());
        tagCompound.func_74782_a("Filter", (NBTBase)this.fluidFilterContainer.serializeNBT());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferRate = tagCompound.func_74762_e("TransferRate");
        this.pumpMode = PumpMode.VALUES[tagCompound.func_74762_e("PumpMode")];
        this.distributionMode = DistributionMode.VALUES[tagCompound.func_74762_e("DistributionMode")];
        this.isWorkingAllowed = tagCompound.func_74767_n("WorkingAllowed");
        this.manualImportExportMode = ManualImportExportMode.VALUES[tagCompound.func_74762_e("ManualImportExportMode")];
        this.bucketMode = BucketMode.VALUES[tagCompound.func_74762_e("BucketMode")];
        NBTTagCompound filterTag = tagCompound.func_74775_l("Filter");
        if (filterTag.func_74764_b("IsBlacklist")) {
            this.fluidFilterContainer.handleLegacyNBT(filterTag);
        } else {
            this.fluidFilterContainer.deserializeNBT(filterTag);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.VOLTAGE_CASINGS[this.tier].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }

    public static enum PumpMode implements IStringSerializable,
    IIOMode
    {
        IMPORT("cover.pump.mode.import"),
        EXPORT("cover.pump.mode.export");

        public static final PumpMode[] VALUES;
        public final String localeName;

        private PumpMode(String localeName) {
            this.localeName = localeName;
        }

        @NotNull
        public String func_176610_l() {
            return this.localeName;
        }

        @Override
        public boolean isImport() {
            return this == IMPORT;
        }

        static {
            VALUES = PumpMode.values();
        }
    }

    public static enum BucketMode implements IStringSerializable
    {
        BUCKET("cover.bucket.mode.bucket"),
        MILLI_BUCKET("cover.bucket.mode.milli_bucket");

        public static final BucketMode[] VALUES;
        public final String localeName;

        private BucketMode(String localeName) {
            this.localeName = localeName;
        }

        @NotNull
        public String func_176610_l() {
            return this.localeName;
        }

        static {
            VALUES = BucketMode.values();
        }
    }

    private class CoverableFluidHandlerWrapper
    extends FluidHandlerDelegate {
        public CoverableFluidHandlerWrapper(IFluidHandler delegate) {
            super(delegate);
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            if (CoverPump.this.pumpMode == PumpMode.EXPORT && CoverPump.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return 0;
            }
            if (!CoverPump.this.checkInputFluid(resource) && CoverPump.this.manualImportExportMode == ManualImportExportMode.FILTERED) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        @Override
        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (CoverPump.this.pumpMode == PumpMode.IMPORT && CoverPump.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return null;
            }
            if (CoverPump.this.manualImportExportMode == ManualImportExportMode.FILTERED && !CoverPump.this.checkInputFluid(resource)) {
                return null;
            }
            return super.drain(resource, doDrain);
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (CoverPump.this.pumpMode == PumpMode.IMPORT && CoverPump.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return null;
            }
            if (CoverPump.this.manualImportExportMode == ManualImportExportMode.FILTERED) {
                FluidStack result = super.drain(maxDrain, false);
                if (result == null || result.amount <= 0 || !CoverPump.this.checkInputFluid(result)) {
                    return null;
                }
                return doDrain ? super.drain(maxDrain, true) : result;
            }
            return super.drain(maxDrain, doDrain);
        }
    }
}

