/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.BoolValue;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.client.renderer.texture.Textures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverMachineController
extends CoverBase
implements CoverWithUI {
    private boolean isInverted = false;
    private ControllerMode controllerMode = ControllerMode.MACHINE;

    public CoverMachineController(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    public ControllerMode getControllerMode() {
        return this.controllerMode;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean inverted) {
        this.isInverted = inverted;
        this.updateRedstoneStatus();
        this.getCoverableView().markDirty();
    }

    public void setControllerMode(ControllerMode controllerMode) {
        this.resetCurrentControllable();
        this.controllerMode = controllerMode;
        this.updateRedstoneStatus();
        this.getCoverableView().markDirty();
    }

    public List<ControllerMode> getAllowedModes(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        ArrayList<ControllerMode> results = new ArrayList<ControllerMode>();
        for (ControllerMode controllerMode : ControllerMode.VALUES) {
            IControllable controllable = null;
            if (controllerMode.side == null) {
                controllable = (IControllable)coverable.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, side);
            } else {
                Cover cover = coverable.getCoverAtSide(controllerMode.side);
                if (cover != null) {
                    controllable = cover.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
                }
            }
            if (controllable == null) continue;
            results.add(controllerMode);
        }
        return results;
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return !this.getAllowedModes(coverable, side).isEmpty();
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        if (!this.getCoverableView().getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        EnumSyncValue controllerModeValue = new EnumSyncValue(ControllerMode.class, this::getControllerMode, this::setControllerMode);
        BooleanSyncValue invertedValue = new BooleanSyncValue(this::isInverted, this::setInverted);
        guiSyncManager.syncValue("controller_mode", (SyncHandler)controllerModeValue);
        guiSyncManager.syncValue("inverted", (SyncHandler)invertedValue);
        return (ModularPanel)((ModularPanel)GTGuis.createPanel(this, 176, 112).child((IWidget)CoverWithUI.createTitleRow(this.getPickItem()))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().widthRel(1.0f)).margin(7, 0)).top(24)).coverChildrenHeight()).child((IWidget)((ParentWidget)this.createSettingsRow().child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().size(16)).left(0)).value((IBoolValue)new BoolValue.Dynamic(() -> ((BooleanSyncValue)invertedValue).getValue(), $ -> invertedValue.setValue((Object)true))).overlay(new IDrawable[]{GTGuiTextures.BUTTON_REDSTONE_ON})).selectedBackground(new IDrawable[]{GTGuiTextures.MC_BUTTON_DISABLED}))).child((IWidget)((TextWidget)IKey.lang((String)"cover.machine_controller.enable_with_redstone").asWidget().heightRel(1.0f)).left(20)))).child((IWidget)((ParentWidget)this.createSettingsRow().child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().size(16)).left(0)).value((IBoolValue)new BoolValue.Dynamic(() -> invertedValue.getValue() == false, $ -> invertedValue.setValue((Object)false))).overlay(new IDrawable[]{GTGuiTextures.BUTTON_REDSTONE_OFF})).selectedBackground(new IDrawable[]{GTGuiTextures.MC_BUTTON_DISABLED}))).child((IWidget)((TextWidget)IKey.lang((String)"cover.machine_controller.disable_with_redstone").asWidget().heightRel(1.0f)).left(20)))).child((IWidget)((Widget)((Widget)((Widget)((Widget)new Rectangle().setColor(-11184811).asWidget().height(1)).widthRel(0.9f)).alignX(0.5f)).marginBottom(4)).marginTop(4))).child((IWidget)((ParentWidget)((ParentWidget)((ParentWidget)((ParentWidget)((ParentWidget)((ParentWidget)((ParentWidget)this.createSettingsRow().height(34)).child((IWidget)((Flow)((Flow)((Flow)Flow.column().heightRel(1.0f)).coverChildrenWidth()).child((IWidget)((TextWidget)((TextWidget)IKey.lang((String)"cover.machine_controller.control").asWidget().left(0)).height(16)).marginBottom(2))).child((IWidget)this.modeButton((EnumSyncValue<ControllerMode>)controllerModeValue, ControllerMode.MACHINE).left(0)))).child((IWidget)this.modeColumn((EnumSyncValue<ControllerMode>)controllerModeValue, ControllerMode.COVER_UP, IKey.str((String)"U")).right(100))).child((IWidget)this.modeColumn((EnumSyncValue<ControllerMode>)controllerModeValue, ControllerMode.COVER_DOWN, IKey.str((String)"D")).right(80))).child((IWidget)this.modeColumn((EnumSyncValue<ControllerMode>)controllerModeValue, ControllerMode.COVER_NORTH, IKey.str((String)"N")).right(60))).child((IWidget)this.modeColumn((EnumSyncValue<ControllerMode>)controllerModeValue, ControllerMode.COVER_SOUTH, IKey.str((String)"S")).right(40))).child((IWidget)this.modeColumn((EnumSyncValue<ControllerMode>)controllerModeValue, ControllerMode.COVER_EAST, IKey.str((String)"E")).right(20))).child((IWidget)this.modeColumn((EnumSyncValue<ControllerMode>)controllerModeValue, ControllerMode.COVER_WEST, IKey.str((String)"W")).right(0))));
    }

    private Flow modeColumn(EnumSyncValue<ControllerMode> syncValue, ControllerMode mode, IKey title) {
        return (Flow)((Flow)((Flow)((Flow)Flow.column().coverChildrenHeight()).width(18)).child((IWidget)((TextWidget)((TextWidget)title.asWidget().size(16)).marginBottom(2)).alignment(Alignment.Center))).child(this.modeButton(syncValue, mode));
    }

    private Widget<?> modeButton(EnumSyncValue<ControllerMode> syncValue, ControllerMode mode) {
        IControllable controllable = this.getControllable(mode);
        if (controllable == null) {
            IKey detail = mode.side == this.getAttachedSide() ? IKey.lang((String)"cover.machine_controller.this_cover") : (mode.side != null ? IKey.lang((String)"cover.machine_controller.cover_not_controllable") : IKey.lang((String)"cover.machine_controller.machine_not_controllable"));
            return (Widget)((Widget)GTGuiTextures.MC_BUTTON.asWidget().size(18)).overlay(new IDrawable[]{GTGuiTextures.BUTTON_CROSS}).tooltip(t -> ((RichTooltip)t.addLine((IDrawable)IKey.lang((String)mode.localeName))).addLine((IDrawable)detail));
        }
        ItemStack stack = mode == ControllerMode.MACHINE ? this.getCoverableView().getStackForm() : this.getCoverableView().getCoverAtSide(mode.side).getDefinition().getDropItemStack();
        return (Widget)((ToggleButton)((ToggleButton)new ToggleButton().size(18)).value((IBoolValue)this.boolValueOf(syncValue, mode)).overlay(new IDrawable[]{new ItemDrawable(stack).asIcon().size(16)})).tooltip(t -> ((RichTooltip)t.addLine((IDrawable)IKey.lang((String)mode.localeName))).addLine((IDrawable)IKey.str((String)(TextFormatting.GRAY + stack.func_82833_r()))));
    }

    @Override
    public void onAttachment(@NotNull CoverableView coverableView, @NotNull EnumFacing side, @Nullable EntityPlayer player, @NotNull ItemStack itemStack) {
        super.onAttachment(coverableView, side, player, itemStack);
        this.controllerMode = this.getAllowedModes(this.getCoverableView(), this.getAttachedSide()).iterator().next();
        this.updateRedstoneStatus();
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        this.resetCurrentControllable();
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        Textures.MACHINE_CONTROLLER_OVERLAY.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void onRedstoneInputSignalChange(int newSignalStrength) {
        this.updateRedstoneStatus();
    }

    @Nullable
    private IControllable getControllable(ControllerMode mode) {
        EnumFacing side = mode.side;
        if (side == null) {
            return (IControllable)this.getCoverableView().getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, this.getAttachedSide());
        }
        Cover cover = this.getCoverableView().getCoverAtSide(side);
        if (cover == null) {
            return null;
        }
        return cover.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
    }

    private void resetCurrentControllable() {
        IControllable controllable = this.getControllable(this.controllerMode);
        if (controllable != null) {
            controllable.setWorkingEnabled(this.doesOtherAllowingWork());
        }
    }

    private void updateRedstoneStatus() {
        IControllable controllable = this.getControllable(this.controllerMode);
        if (controllable != null) {
            controllable.setWorkingEnabled(this.shouldAllowWorking() && this.doesOtherAllowingWork());
        }
    }

    private boolean shouldAllowWorking() {
        int inputSignal = this.getCoverableView().getInputRedstoneSignal(this.getAttachedSide(), true);
        return this.isInverted ? inputSignal > 0 : inputSignal == 0;
    }

    private boolean doesOtherAllowingWork() {
        boolean otherAllow = true;
        EnumFacing attachedSide = this.getAttachedSide();
        CoverableView coverable = this.getCoverableView();
        for (EnumFacing side : EnumFacing.values()) {
            CoverMachineController machineController;
            Cover cover;
            if (side == attachedSide || !((cover = coverable.getCoverAtSide(side)) instanceof CoverMachineController)) continue;
            CoverMachineController cover2 = machineController = (CoverMachineController)cover;
            otherAllow = otherAllow && cover2.controllerMode == this.controllerMode && cover2.shouldAllowWorking();
        }
        return otherAllow;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74757_a("Inverted", this.isInverted);
        tagCompound.func_74768_a("ControllerMode", this.controllerMode.ordinal());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.isInverted = tagCompound.func_74767_n("Inverted");
        this.controllerMode = ControllerMode.VALUES[tagCompound.func_74762_e("ControllerMode")];
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeBoolean(this.isInverted);
        packetBuffer.writeShort(this.controllerMode.ordinal());
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.isInverted = packetBuffer.readBoolean();
        this.controllerMode = ControllerMode.VALUES[packetBuffer.readShort()];
    }

    public static enum ControllerMode implements IStringSerializable
    {
        MACHINE("cover.machine_controller.mode.machine", null),
        COVER_UP("cover.machine_controller.mode.cover_up", EnumFacing.UP),
        COVER_DOWN("cover.machine_controller.mode.cover_down", EnumFacing.DOWN),
        COVER_NORTH("cover.machine_controller.mode.cover_north", EnumFacing.NORTH),
        COVER_SOUTH("cover.machine_controller.mode.cover_south", EnumFacing.SOUTH),
        COVER_EAST("cover.machine_controller.mode.cover_east", EnumFacing.EAST),
        COVER_WEST("cover.machine_controller.mode.cover_west", EnumFacing.WEST);

        public final String localeName;
        public final EnumFacing side;
        public static final ControllerMode[] VALUES;

        private ControllerMode(String localeName, EnumFacing side) {
            this.localeName = localeName;
            this.side = side;
        }

        @NotNull
        public String func_176610_l() {
            return this.localeName;
        }

        static {
            VALUES = ControllerMode.values();
        }
    }
}

