/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverItemVoiding;
import gregtech.common.covers.VoidingMode;
import gregtech.common.covers.filter.MatchResult;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CoverItemVoidingAdvanced
extends CoverItemVoiding {
    protected VoidingMode voidingMode = VoidingMode.VOID_ANY;

    public CoverItemVoidingAdvanced(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
        this.itemFilterContainer.setMaxTransferSize(1);
    }

    @Override
    protected void doTransferItems() {
        IItemHandler myItemHandler = (IItemHandler)this.getCoverableView().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getAttachedSide());
        if (myItemHandler == null) {
            return;
        }
        switch (this.voidingMode) {
            case VOID_ANY: {
                this.voidAny(myItemHandler);
                break;
            }
            case VOID_OVERFLOW: {
                this.voidOverflow(myItemHandler);
            }
        }
    }

    protected void voidOverflow(IItemHandler myItemHandler) {
        Map<ItemStack, CoverConveyor.TypeItemInfo> itemTypeCount = this.countInventoryItemsByType(myItemHandler);
        block0: for (CoverConveyor.TypeItemInfo typeItemInfo : itemTypeCount.values()) {
            int itemToVoidAmount = 0;
            if (!this.getItemFilterContainer().hasFilter()) {
                itemToVoidAmount = typeItemInfo.totalCount - this.itemFilterContainer.getTransferSize();
            } else {
                MatchResult result = this.itemFilterContainer.match(typeItemInfo.itemStack);
                itemToVoidAmount = result.getItemStack().func_190916_E();
            }
            if (itemToVoidAmount <= 0) continue;
            for (int srcIndex = 0; srcIndex < myItemHandler.getSlots(); ++srcIndex) {
                ItemStack extracted;
                ItemStack is = myItemHandler.getStackInSlot(srcIndex);
                if (!is.func_190926_b() && ItemStack.func_179545_c((ItemStack)is, (ItemStack)typeItemInfo.itemStack) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)typeItemInfo.itemStack) && !(extracted = myItemHandler.extractItem(srcIndex, itemToVoidAmount, false)).func_190926_b()) {
                    itemToVoidAmount -= extracted.func_190916_E();
                }
                if (itemToVoidAmount == 0) continue block0;
            }
        }
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        return (ModularPanel)super.buildUI(guiData, guiSyncManager).height(210);
    }

    @Override
    protected ParentWidget<Flow> createUI(GuiData data, PanelSyncManager guiSyncManager) {
        EnumSyncValue voidingMode = new EnumSyncValue(VoidingMode.class, this::getVoidingMode, this::setVoidingMode);
        guiSyncManager.syncValue("voiding_mode", (SyncHandler)voidingMode);
        StringSyncValue filterTransferSize = new StringSyncValue(() -> String.valueOf(this.itemFilterContainer.getTransferSize()), s -> this.itemFilterContainer.setTransferSize(Integer.parseInt(s)));
        filterTransferSize.updateCacheFromSource(true);
        TextFieldWidget transferTextField = (TextFieldWidget)((TextFieldWidget)new TextFieldWidget().widthRel(0.5f)).right(0);
        transferTextField.setEnabled(this.itemFilterContainer.showGlobalTransferLimitSlider() && this.voidingMode == VoidingMode.VOID_OVERFLOW);
        return (ParentWidget)((Flow)super.createUI(data, guiSyncManager).child((IWidget)new CoverWithUI.EnumRowBuilder<VoidingMode>(VoidingMode.class).value((EnumSyncValue<VoidingMode>)voidingMode).lang("cover.voiding.voiding_mode").overlay(16, (IDrawable[])GTGuiTextures.VOIDING_MODE_OVERLAY).build())).child((IWidget)((Flow)((Flow)Flow.row().right(0)).coverChildrenHeight()).child((IWidget)((TextFieldWidget)transferTextField.setEnabledIf(w -> this.itemFilterContainer.showGlobalTransferLimitSlider() && this.voidingMode == VoidingMode.VOID_OVERFLOW)).setNumbers(0, Integer.MAX_VALUE).value((IStringValue)filterTransferSize).setTextColor(Color.WHITE.darker(1))));
    }

    @Override
    protected int getMaxStackSize() {
        return this.getVoidingMode().maxStackSize;
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.ITEM_VOIDING_ADVANCED.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    public void setVoidingMode(VoidingMode voidingMode) {
        this.voidingMode = voidingMode;
        this.itemFilterContainer.setMaxTransferSize(this.getMaxStackSize());
        this.getCoverableView().markDirty();
    }

    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeByte(this.voidingMode.ordinal());
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.voidingMode = VoidingMode.VALUES[packetBuffer.readByte()];
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("VoidMode", this.voidingMode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.voidingMode = VoidingMode.VALUES[tagCompound.func_74762_e("VoidMode")];
        this.itemFilterContainer.setMaxTransferSize(this.voidingMode.maxStackSize);
        super.readFromNBT(tagCompound);
    }
}

