/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverConveyor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CoverItemVoiding
extends CoverConveyor {
    protected final NullItemHandler nullItemHandler = new NullItemHandler();

    public CoverItemVoiding(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide, 0, Integer.MAX_VALUE);
        this.isWorkingAllowed = false;
    }

    @Override
    public void func_73660_a() {
        if (this.isWorkingAllowed && this.getCoverableView().getOffsetTimer() % 20L == 0L) {
            this.doTransferItems();
        }
    }

    protected void doTransferItems() {
        IItemHandler myItemHandler = (IItemHandler)this.getCoverableView().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getAttachedSide());
        if (myItemHandler == null) {
            return;
        }
        this.voidAny(myItemHandler);
    }

    void voidAny(IItemHandler myItemHandler) {
        for (int srcIndex = 0; srcIndex < myItemHandler.getSlots(); ++srcIndex) {
            ItemStack sourceStack = myItemHandler.extractItem(srcIndex, Integer.MAX_VALUE, true);
            if (sourceStack.func_190926_b() || !this.itemFilterContainer.test(sourceStack)) continue;
            myItemHandler.extractItem(srcIndex, Integer.MAX_VALUE, false);
        }
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        return (ModularPanel)super.buildUI(guiData, guiSyncManager).height(170);
    }

    @Override
    protected ParentWidget<Flow> createUI(GuiData data, PanelSyncManager guiSyncManager) {
        BooleanSyncValue isWorking = new BooleanSyncValue(this::isWorkingEnabled, this::setWorkingEnabled);
        return (ParentWidget)super.createUI(data, guiSyncManager).child((IWidget)((Flow)((Flow)((Flow)Flow.row().height(18)).widthRel(1.0f)).marginBottom(2)).child((IWidget)((ToggleButton)((ToggleButton)new ToggleButton().value((IBoolValue)isWorking).overlay(new IDrawable[]{IKey.dynamic(() -> IKey.lang((String)(this.isWorkingAllowed ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled")).get()).color(Integer.valueOf(Color.WHITE.darker(1)))})).widthRel(0.6f)).left(0)));
    }

    @Override
    protected boolean createThroughputRow() {
        return false;
    }

    @Override
    protected boolean createConveyorModeRow() {
        return false;
    }

    @Override
    protected boolean createDistributionModeRow() {
        return false;
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.ITEM_VOIDING.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    @Override
    @NotNull
    public EnumActionResult onSoftMalletClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        boolean bl = this.isWorkingAllowed = !this.isWorkingAllowed;
        if (!playerIn.field_70170_p.field_72995_K) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.isWorkingEnabled() ? "cover.voiding.message.enabled" : "cover.voiding.message.disabled", new Object[0]), true);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.nullItemHandler);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }

    class NullItemHandler
    implements IItemHandler {
        NullItemHandler() {
        }

        public int getSlots() {
            return 9;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!CoverItemVoiding.this.itemFilterContainer.test(stack)) {
                return stack;
            }
            return ItemStack.field_190927_a;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

