/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.capability.impl.ItemHandlerDelegate;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.covers.ItemFilterMode;
import gregtech.common.covers.filter.BaseFilter;
import gregtech.common.covers.filter.BaseFilterContainer;
import gregtech.common.covers.filter.ItemFilterContainer;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverItemFilter
extends CoverBase
implements CoverWithUI {
    protected final String titleLocale;
    protected final SimpleOverlayRenderer texture;
    protected final ItemFilterContainer itemFilterContainer;
    protected ItemFilterMode filterMode = ItemFilterMode.FILTER_INSERT;
    protected boolean allowFlow = false;
    protected ItemHandlerDelegate itemHandler;

    public CoverItemFilter(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, String titleLocale, SimpleOverlayRenderer texture) {
        super(definition, coverableView, attachedSide);
        this.titleLocale = titleLocale;
        this.texture = texture;
        this.itemFilterContainer = new ItemFilterContainer(this);
    }

    @Override
    public void onAttachment(@NotNull CoverableView coverableView, @NotNull EnumFacing side, @Nullable EntityPlayer player, @NotNull ItemStack itemStack) {
        super.onAttachment(coverableView, side, player, itemStack);
        ItemStack dropStack = GTUtility.copy(1, itemStack);
        this.itemFilterContainer.setFilterStack(dropStack);
    }

    @Override
    @NotNull
    public ItemStack getPickItem() {
        return this.itemFilterContainer.getFilterStack();
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(this.itemFilterContainer.hasFilter());
        if (this.itemFilterContainer.hasFilter()) {
            packetBuffer.writeByte(this.filterMode.ordinal());
            packetBuffer.func_150788_a(this.itemFilterContainer.getFilterStack());
        }
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        if (!packetBuffer.readBoolean()) {
            return;
        }
        this.filterMode = ItemFilterMode.VALUES[packetBuffer.readByte()];
        try {
            this.itemFilterContainer.setFilterStack(packetBuffer.func_150791_c());
        }
        catch (IOException e) {
            GTLog.logger.error("Failed to read filter for CoverItemFilter! %s", (Object)this.getPos().toString());
        }
    }

    public void setFilterMode(ItemFilterMode filterMode) {
        this.filterMode = filterMode;
        this.getCoverableView().markDirty();
    }

    public ItemFilterMode getFilterMode() {
        return this.filterMode;
    }

    @NotNull
    public BaseFilter getFilter() {
        BaseFilter filter = this.getFilterContainer().getFilter();
        if (filter == null) {
            return BaseFilter.ERROR_FILTER;
        }
        return filter;
    }

    @NotNull
    public BaseFilterContainer getFilterContainer() {
        return this.itemFilterContainer;
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return coverable.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getAttachedSide()) != null;
    }

    @Override
    public boolean canPipePassThrough() {
        return true;
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        if (!playerIn.field_70170_p.field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean testItemStack(ItemStack stack) {
        return this.itemFilterContainer.test(stack);
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        EnumSyncValue filteringMode = new EnumSyncValue(ItemFilterMode.class, this::getFilterMode, this::setFilterMode);
        guiSyncManager.syncValue("filtering_mode", (SyncHandler)filteringMode);
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)this.getFilter().createPanel(guiSyncManager).size(176, 212)).padding(7)).child((IWidget)CoverWithUI.createTitleRow(this.getFilterContainer().getFilterStack()).left(4))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().widthRel(1.0f)).align(Alignment.TopLeft)).top(22)).coverChildrenHeight()).child((IWidget)new CoverWithUI.EnumRowBuilder<ItemFilterMode>(ItemFilterMode.class).value((EnumSyncValue<ItemFilterMode>)filteringMode).lang("cover.filter.mode.title").overlay(16, (IDrawable[])GTGuiTextures.FILTER_MODE_OVERLAY).build())).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().marginBottom(2)).widthRel(1.0f)).coverChildrenHeight()).setEnabledIf(b -> this.getFilterMode() != ItemFilterMode.FILTER_BOTH)).child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().overlay(new IDrawable[]{IKey.dynamic(() -> IKey.lang((String)(this.allowFlow ? "cover.generic.enabled" : "cover.generic.disabled")).get()).color(Integer.valueOf(Color.WHITE.main)).shadow(Boolean.valueOf(false))})).tooltip(tooltip -> tooltip.addLine((IDrawable)IKey.lang((String)"cover.filter.allow_flow.tooltip")))).size(72, 18)).value((IBoolValue)new BooleanSyncValue(() -> this.allowFlow, b -> {
            this.allowFlow = b;
        })))).child((IWidget)((TextWidget)IKey.lang((String)"cover.filter.allow_flow.label").asWidget().height(18)).alignX(1.0f)))).child((IWidget)((Widget)((Widget)new Rectangle().setColor(-11184811).asWidget().height(1)).widthRel(0.95f)).margin(0, 4))).child((IWidget)this.getFilter().createWidgets(guiSyncManager).left(0)))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().bottom(7)).left(7));
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        this.texture.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("FilterMode", this.filterMode.ordinal());
        tagCompound.func_74782_a("Filter", (NBTBase)this.itemFilterContainer.serializeNBT());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.filterMode = ItemFilterMode.VALUES[tagCompound.func_74762_e("FilterMode")];
        if (tagCompound.func_74764_b("IsBlacklist")) {
            this.itemFilterContainer.setFilterStack(this.getDefinition().getDropItemStack());
            this.itemFilterContainer.handleLegacyNBT(tagCompound);
            this.itemFilterContainer.setBlacklistFilter(tagCompound.func_74767_n("IsBlacklist"));
        } else {
            this.itemFilterContainer.deserializeNBT(tagCompound.func_74775_l("Filter"));
        }
    }

    @Override
    public <T> T getCapability(@NotNull Capability<T> capability, T defaultValue) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (defaultValue == null) {
                return null;
            }
            IItemHandler delegate = (IItemHandler)defaultValue;
            if (this.itemHandler == null || this.itemHandler.delegate != delegate) {
                this.itemHandler = new ItemHandlerFiltered(delegate);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        return defaultValue;
    }

    private class ItemHandlerFiltered
    extends ItemHandlerDelegate {
        public ItemHandlerFiltered(IItemHandler delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (CoverItemFilter.this.getFilterMode() == ItemFilterMode.FILTER_EXTRACT && CoverItemFilter.this.allowFlow) {
                return super.insertItem(slot, stack, simulate);
            }
            if (CoverItemFilter.this.getFilterMode() != ItemFilterMode.FILTER_EXTRACT && CoverItemFilter.this.itemFilterContainer.test(stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CoverItemFilter.this.getFilterMode() == ItemFilterMode.FILTER_INSERT && CoverItemFilter.this.allowFlow) {
                return super.extractItem(slot, amount, simulate);
            }
            if (CoverItemFilter.this.getFilterMode() != ItemFilterMode.FILTER_INSERT && CoverItemFilter.this.itemFilterContainer.test(this.getStackInSlot(slot))) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }
    }
}

