/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.util.GTTransferUtils;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverFluidVoiding;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.VoidingMode;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;

public class CoverFluidVoidingAdvanced
extends CoverFluidVoiding {
    protected VoidingMode voidingMode = VoidingMode.VOID_ANY;
    protected int transferAmount = 0;

    public CoverFluidVoidingAdvanced(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    @Override
    protected void doTransferFluids() {
        IFluidHandler myFluidHandler = (IFluidHandler)this.getCoverableView().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getAttachedSide());
        if (myFluidHandler == null) {
            return;
        }
        switch (this.voidingMode) {
            case VOID_ANY: {
                GTTransferUtils.transferFluids(myFluidHandler, (IFluidHandler)this.nullFluidTank, Integer.MAX_VALUE, this.fluidFilterContainer::test);
                break;
            }
            case VOID_OVERFLOW: {
                this.voidOverflow(myFluidHandler, this.fluidFilterContainer::test, this.transferAmount);
            }
        }
    }

    protected void voidOverflow(IFluidHandler sourceHandler, Predicate<FluidStack> fluidFilter, int keepAmount) {
        if (sourceHandler == null || fluidFilter == null) {
            return;
        }
        for (IFluidTankProperties tankProperties : sourceHandler.getTankProperties()) {
            FluidStack sourceFluid = tankProperties.getContents();
            if (this.fluidFilterContainer.hasFilter() && this.voidingMode == VoidingMode.VOID_OVERFLOW) {
                keepAmount = this.fluidFilterContainer.getFilter().getTransferLimit(sourceFluid, this.getMaxTransferRate());
            }
            if (sourceFluid == null || sourceFluid.amount == 0 || !this.getFluidFilterContainer().test(sourceFluid)) continue;
            sourceFluid.amount -= keepAmount;
            sourceHandler.drain(sourceFluid, true);
        }
    }

    public int getTransferAmount() {
        return this.fluidFilterContainer.getTransferSize();
    }

    public void setVoidingMode(VoidingMode transferMode) {
        this.voidingMode = transferMode;
        this.fluidFilterContainer.setMaxTransferSize(this.getMaxTransferRate());
        this.markDirty();
    }

    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        return (ModularPanel)super.buildUI(guiData, guiSyncManager).height(212);
    }

    @Override
    protected ParentWidget<?> createUI(GuiData data, PanelSyncManager syncManager) {
        EnumSyncValue voidingMode = new EnumSyncValue(VoidingMode.class, this::getVoidingMode, this::setVoidingMode);
        syncManager.syncValue("voiding_mode", (SyncHandler)voidingMode);
        EnumSyncValue bucketMode = new EnumSyncValue(CoverPump.BucketMode.class, this::getBucketMode, this::setBucketMode);
        bucketMode.updateCacheFromSource(true);
        syncManager.syncValue("bucket_mode", (SyncHandler)bucketMode);
        StringSyncValue filterTransferSize = new StringSyncValue(this::getStringTransferRate, this::setStringTransferRate);
        TextFieldWidget transferTextField = (TextFieldWidget)((TextFieldWidget)new TextFieldWidget().widthRel(0.5f)).right(0);
        transferTextField.setEnabled(this.fluidFilterContainer.showGlobalTransferLimitSlider() && this.voidingMode == VoidingMode.VOID_OVERFLOW);
        return (ParentWidget)((ParentWidget)super.createUI(data, syncManager).child((IWidget)new CoverWithUI.EnumRowBuilder<VoidingMode>(VoidingMode.class).value((EnumSyncValue<VoidingMode>)voidingMode).lang("cover.voiding.voiding_mode").overlay(16, (IDrawable[])GTGuiTextures.VOIDING_MODE_OVERLAY).build())).child((IWidget)new CoverWithUI.EnumRowBuilder<CoverPump.BucketMode>(CoverPump.BucketMode.class).value((EnumSyncValue<CoverPump.BucketMode>)bucketMode).overlay(new IDrawable[]{IKey.str((String)"kL"), IKey.str((String)"L")}).build().child((IWidget)((TextFieldWidget)transferTextField.setEnabledIf(w -> this.fluidFilterContainer.showGlobalTransferLimitSlider() && this.voidingMode == VoidingMode.VOID_OVERFLOW)).setNumbers(0, Integer.MAX_VALUE).value((IStringValue)filterTransferSize).setTextColor(Color.WHITE.darker(1))));
    }

    @Override
    protected int getMaxTransferRate() {
        return this.getVoidingMode().maxStackSize;
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        Textures.FLUID_VOIDING_ADVANCED.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.voidingMode = VoidingMode.VALUES[packetBuffer.readByte()];
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeByte(this.voidingMode.ordinal());
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("VoidingMode", this.voidingMode.ordinal());
        tagCompound.func_74768_a("TransferAmount", this.transferAmount);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        this.voidingMode = VoidingMode.VALUES[tagCompound.func_74762_e("VoidingMode")];
        this.fluidFilterContainer.setMaxTransferSize(this.voidingMode.maxStackSize);
        this.transferAmount = tagCompound.func_74762_e("TransferAmount");
        super.readFromNBT(tagCompound);
    }
}

