/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.util.GTTransferUtils;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.filter.FluidFilterContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class CoverFluidVoiding
extends CoverPump {
    protected final NullFluidTank nullFluidTank = new NullFluidTank();

    public CoverFluidVoiding(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide, 0, Integer.MAX_VALUE);
        this.isWorkingAllowed = false;
        this.fluidFilterContainer = new FluidFilterContainer(this);
        this.fluidFilterContainer.setMaxTransferSize(Integer.MAX_VALUE);
    }

    @Override
    public void func_73660_a() {
        if (this.isWorkingAllowed && this.getOffsetTimer() % 20L == 0L) {
            this.doTransferFluids();
        }
    }

    protected void doTransferFluids() {
        IFluidHandler myFluidHandler = (IFluidHandler)this.getCoverableView().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getAttachedSide());
        if (myFluidHandler == null) {
            return;
        }
        GTTransferUtils.transferFluids(myFluidHandler, (IFluidHandler)this.nullFluidTank, Integer.MAX_VALUE, this.fluidFilterContainer::test);
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        Textures.FLUID_VOIDING.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        return (ModularPanel)super.buildUI(guiData, guiSyncManager).height(170);
    }

    @Override
    protected ParentWidget<?> createUI(GuiData data, PanelSyncManager syncManager) {
        BooleanSyncValue isWorking = new BooleanSyncValue(this::isWorkingEnabled, this::setWorkingEnabled);
        return (ParentWidget)super.createUI(data, syncManager).child((IWidget)((Flow)((Flow)((Flow)Flow.row().height(18)).widthRel(1.0f)).marginBottom(2)).child((IWidget)((ToggleButton)((ToggleButton)new ToggleButton().value((IBoolValue)isWorking).overlay(new IDrawable[]{IKey.dynamic(() -> IKey.lang((String)(this.isWorkingAllowed ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled")).get()).color(Integer.valueOf(Color.WHITE.darker(1)))})).widthRel(0.6f)).left(0)));
    }

    @Override
    protected boolean createPumpModeRow() {
        return false;
    }

    @Override
    protected boolean createThroughputRow() {
        return false;
    }

    @Override
    @NotNull
    public EnumActionResult onSoftMalletClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        boolean bl = this.isWorkingAllowed = !this.isWorkingAllowed;
        if (!playerIn.field_70170_p.field_72995_K) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.isWorkingEnabled() ? "cover.voiding.message.enabled" : "cover.voiding.message.disabled", new Object[0]), true);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public <T> T getCapability(@NotNull Capability<T> capability, T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.nullFluidTank);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }

    class NullFluidTank
    extends FluidTank {
        public NullFluidTank() {
            super(Integer.MAX_VALUE);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (CoverFluidVoiding.this.fluidFilterContainer.test(resource)) {
                return resource.amount;
            }
            return 0;
        }
    }
}

