/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.util.GTTransferUtils;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.TransferMode;
import gregtech.common.covers.filter.BaseFilter;
import gregtech.common.covers.filter.FluidFilterContainer;
import gregtech.common.covers.filter.SimpleFluidFilter;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.message.FormattedMessage;
import org.jetbrains.annotations.NotNull;

public class CoverFluidRegulator
extends CoverPump {
    protected TransferMode transferMode = TransferMode.TRANSFER_ANY;

    public CoverFluidRegulator(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, int tier, int mbPerTick) {
        super(definition, coverableView, attachedSide, tier, mbPerTick);
        this.fluidFilterContainer = new FluidFilterContainer(this);
    }

    @Override
    protected int doTransferFluidsInternal(IFluidHandler myFluidHandler, IFluidHandler fluidHandler, int transferLimit) {
        int n;
        IFluidHandler destHandler;
        IFluidHandler sourceHandler;
        if (this.pumpMode == CoverPump.PumpMode.IMPORT) {
            sourceHandler = fluidHandler;
            destHandler = myFluidHandler;
        } else if (this.pumpMode == CoverPump.PumpMode.EXPORT) {
            sourceHandler = myFluidHandler;
            destHandler = fluidHandler;
        } else {
            return 0;
        }
        switch (this.transferMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TRANSFER_ANY: {
                n = GTTransferUtils.transferFluids(sourceHandler, destHandler, transferLimit, this.fluidFilterContainer::test);
                break;
            }
            case KEEP_EXACT: {
                n = this.doKeepExact(transferLimit, sourceHandler, destHandler, this.fluidFilterContainer::test, this.fluidFilterContainer.getTransferSize());
                break;
            }
            case TRANSFER_EXACT: {
                n = this.doTransferExact(transferLimit, sourceHandler, destHandler, this.fluidFilterContainer::test, this.fluidFilterContainer.getTransferSize());
            }
        }
        return n;
    }

    protected int doTransferExact(int transferLimit, IFluidHandler sourceHandler, IFluidHandler destHandler, Predicate<FluidStack> fluidFilter, int supplyAmount) {
        int fluidLeftToTransfer = transferLimit;
        for (IFluidTankProperties tankProperties : sourceHandler.getTankProperties()) {
            FluidStack sourceFluid = tankProperties.getContents();
            if (this.fluidFilterContainer.hasFilter()) {
                supplyAmount = this.fluidFilterContainer.getFilter().getTransferLimit(sourceFluid, supplyAmount);
            }
            if (fluidLeftToTransfer < supplyAmount) break;
            if (sourceFluid == null || sourceFluid.amount == 0 || !fluidFilter.test(sourceFluid)) continue;
            sourceFluid.amount = supplyAmount;
            if (GTTransferUtils.transferExactFluidStack(sourceHandler, destHandler, sourceFluid.copy())) {
                fluidLeftToTransfer -= sourceFluid.amount;
            }
            if (fluidLeftToTransfer == 0) break;
        }
        return transferLimit - fluidLeftToTransfer;
    }

    protected int doKeepExact(int transferLimit, IFluidHandler sourceHandler, IFluidHandler destHandler, Predicate<FluidStack> fluidFilter, int keepAmount) {
        if (sourceHandler == null || destHandler == null || fluidFilter == null) {
            return 0;
        }
        Map<FluidStack, Integer> sourceFluids = CoverFluidRegulator.collectDistinctFluids(sourceHandler, IFluidTankProperties::canDrain, fluidFilter);
        Map<FluidStack, Integer> destFluids = CoverFluidRegulator.collectDistinctFluids(destHandler, IFluidTankProperties::canFill, fluidFilter);
        int transferred = 0;
        for (FluidStack fluidStack : sourceFluids.keySet()) {
            int drainable;
            int fillResult;
            FluidStack drainedResult;
            int amountToMove;
            int amountInDest;
            if (transferred >= transferLimit) break;
            if (this.fluidFilterContainer.hasFilter()) {
                keepAmount = this.fluidFilterContainer.getFilter().getTransferLimit(fluidStack, keepAmount);
            }
            if ((amountInDest = destFluids.getOrDefault(fluidStack, 0).intValue()) >= keepAmount || (amountToMove = Math.min(transferLimit - transferred, keepAmount - amountInDest)) <= 0 || (drainedResult = sourceHandler.drain(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, amountToMove), false)) == null || drainedResult.amount <= 0 || !fluidStack.equals((Object)drainedResult) || (fillResult = destHandler.fill(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, drainable = Math.min(amountToMove, drainedResult.amount)), false)) <= 0) continue;
            int fluidToMove = Math.min(drainable, fillResult);
            FluidStack drainedActual = sourceHandler.drain(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, fluidToMove), true);
            if (drainedActual == null) {
                throw new RuntimeException("Misbehaving fluid container: drain produced null after simulation succeeded");
            }
            if (!fluidStack.equals((Object)drainedActual)) {
                throw new RuntimeException("Misbehaving fluid container: drain produced a different fluid than the simulation");
            }
            if (drainedActual.amount != fluidToMove) {
                throw new RuntimeException(new FormattedMessage("Misbehaving fluid container: drain expected: {}, actual: {}", (Object)fluidToMove, (Object)drainedActual.amount).getFormattedMessage());
            }
            int filledActual = destHandler.fill(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, fluidToMove), true);
            if (filledActual != fluidToMove) {
                throw new RuntimeException(new FormattedMessage("Misbehaving fluid container: fill expected: {}, actual: {}", (Object)fluidToMove, (Object)filledActual).getFormattedMessage());
            }
            transferred += fluidToMove;
        }
        return transferred;
    }

    private static FluidStack copyFluidStackWithAmount(FluidStack fs, int amount) {
        FluidStack fs2 = fs.copy();
        fs2.amount = amount;
        return fs2;
    }

    private static Map<FluidStack, Integer> collectDistinctFluids(IFluidHandler handler, Predicate<IFluidTankProperties> tankTypeFilter, Predicate<FluidStack> fluidTypeFilter) {
        Object2IntOpenHashMap summedFluids = new Object2IntOpenHashMap();
        Arrays.stream(handler.getTankProperties()).filter(tankTypeFilter).map(IFluidTankProperties::getContents).filter(Objects::nonNull).filter(fluidTypeFilter).forEach(arg_0 -> CoverFluidRegulator.lambda$collectDistinctFluids$1((Map)summedFluids, arg_0));
        return summedFluids;
    }

    public void setTransferMode(TransferMode transferMode) {
        if (this.transferMode != transferMode) {
            this.transferMode = transferMode;
            this.fluidFilterContainer.setMaxTransferSize(this.getMaxTransferRate());
            this.markDirty();
        }
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    private boolean shouldDisplayAmountSlider() {
        if (this.transferMode == TransferMode.TRANSFER_ANY) {
            return false;
        }
        return this.fluidFilterContainer.showGlobalTransferLimitSlider();
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        return (ModularPanel)super.buildUI(guiData, guiSyncManager).height(228);
    }

    @Override
    protected ParentWidget<?> createUI(GuiData data, PanelSyncManager syncManager) {
        EnumSyncValue transferMode = new EnumSyncValue(TransferMode.class, this::getTransferMode, this::setTransferMode);
        transferMode.updateCacheFromSource(true);
        syncManager.syncValue("transfer_mode", (SyncHandler)transferMode);
        EnumSyncValue bucketMode = new EnumSyncValue(CoverPump.BucketMode.class, this::getBucketMode, this::setBucketMode);
        bucketMode.updateCacheFromSource(true);
        syncManager.syncValue("bucket_mode", (SyncHandler)bucketMode);
        StringSyncValue filterTransferSize = new StringSyncValue(this::getStringTransferRate, this::setStringTransferRate);
        filterTransferSize.updateCacheFromSource(true);
        return (ParentWidget)((ParentWidget)super.createUI(data, syncManager).child((IWidget)new CoverWithUI.EnumRowBuilder<TransferMode>(TransferMode.class).value((EnumSyncValue<TransferMode>)transferMode).lang("cover.generic.transfer_mode").overlay((IDrawable[])GTGuiTextures.FLUID_TRANSFER_MODE_OVERLAY).build())).child((IWidget)new CoverWithUI.EnumRowBuilder<CoverPump.BucketMode>(CoverPump.BucketMode.class).value((EnumSyncValue<CoverPump.BucketMode>)bucketMode).overlay(new IDrawable[]{IKey.str((String)"kL"), IKey.str((String)"L")}).build().child((IWidget)((TextFieldWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().widthRel(0.5f)).right(0)).setEnabledIf(w -> this.shouldDisplayAmountSlider())).setNumbers(0, Integer.MAX_VALUE).value((IStringValue)filterTransferSize).setTextColor(Color.WHITE.darker(1))));
    }

    @Override
    public int getMaxTransferRate() {
        int n;
        switch (this.transferMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TRANSFER_ANY: {
                n = 1;
                break;
            }
            case TRANSFER_EXACT: {
                n = this.maxFluidTransferRate;
                break;
            }
            case KEEP_EXACT: {
                n = Integer.MAX_VALUE;
            }
        }
        return n;
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeByte(this.transferMode.ordinal());
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.transferMode = TransferMode.VALUES[packetBuffer.readByte()];
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferMode", this.transferMode.ordinal());
        tagCompound.func_74782_a("filterv2", (NBTBase)new NBTTagCompound());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        BaseFilter baseFilter;
        this.transferMode = TransferMode.VALUES[tagCompound.func_74762_e("TransferMode")];
        this.fluidFilterContainer.setMaxTransferSize(this.transferMode.maxStackSize);
        super.readFromNBT(tagCompound);
        if (!tagCompound.func_74764_b("filterv2") && tagCompound.func_74764_b("TransferAmount") && (baseFilter = this.fluidFilterContainer.getFilter()) instanceof SimpleFluidFilter) {
            SimpleFluidFilter simpleFluidFilter = (SimpleFluidFilter)baseFilter;
            simpleFluidFilter.configureFilterTanks(tagCompound.func_74762_e("TransferAmount"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.VOLTAGE_CASINGS[this.tier].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }

    private static /* synthetic */ void lambda$collectDistinctFluids$1(Map summedFluids, FluidStack fs) {
        summedFluids.putIfAbsent(fs, 0);
        summedFluids.computeIfPresent(fs, (k, v) -> v + fs.amount);
    }
}

