/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.capability.impl.FluidHandlerDelegate;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.covers.FluidFilterMode;
import gregtech.common.covers.filter.BaseFilter;
import gregtech.common.covers.filter.BaseFilterContainer;
import gregtech.common.covers.filter.FluidFilterContainer;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverFluidFilter
extends CoverBase
implements CoverWithUI {
    protected final String titleLocale;
    protected final SimpleOverlayRenderer texture;
    protected final FluidFilterContainer fluidFilterContainer = new FluidFilterContainer(this);
    protected FluidFilterMode filterMode = FluidFilterMode.FILTER_FILL;
    protected boolean allowFlow = false;
    protected FluidHandlerDelegate fluidHandler;

    public CoverFluidFilter(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, String titleLocale, SimpleOverlayRenderer texture) {
        super(definition, coverableView, attachedSide);
        this.titleLocale = titleLocale;
        this.texture = texture;
    }

    public void setFilterMode(FluidFilterMode filterMode) {
        this.filterMode = filterMode;
        this.getCoverableView().markDirty();
    }

    @Override
    public void onAttachment(@NotNull CoverableView coverableView, @NotNull EnumFacing side, @Nullable EntityPlayer player, @NotNull ItemStack itemStack) {
        super.onAttachment(coverableView, side, player, itemStack);
        ItemStack dropStack = GTUtility.copy(1, itemStack);
        this.fluidFilterContainer.setFilterStack(dropStack);
    }

    @Override
    @NotNull
    public ItemStack getPickItem() {
        return this.fluidFilterContainer.getFilterStack();
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        packetBuffer.writeByte(this.filterMode.ordinal());
        packetBuffer.writeBoolean(this.fluidFilterContainer.hasFilter());
        if (this.fluidFilterContainer.hasFilter()) {
            packetBuffer.func_150788_a(this.fluidFilterContainer.getFilterStack());
        }
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        this.filterMode = FluidFilterMode.VALUES[packetBuffer.readByte()];
        if (!packetBuffer.readBoolean()) {
            return;
        }
        try {
            this.fluidFilterContainer.setFilterStack(packetBuffer.func_150791_c());
        }
        catch (IOException e) {
            GTLog.logger.error("Failed to read filter for CoverFluidFilter! %s", (Object)this.getPos().toString());
        }
    }

    public FluidFilterMode getFilterMode() {
        return this.filterMode;
    }

    @NotNull
    public BaseFilter getFilter() {
        BaseFilter filter = this.getFilterContainer().getFilter();
        if (filter == null) {
            return BaseFilter.ERROR_FILTER;
        }
        return filter;
    }

    @NotNull
    public BaseFilterContainer getFilterContainer() {
        return this.fluidFilterContainer;
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return coverable.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getAttachedSide()) != null;
    }

    @Override
    public boolean canPipePassThrough() {
        return true;
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        if (!playerIn.field_70170_p.field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        EnumSyncValue filteringMode = new EnumSyncValue(FluidFilterMode.class, this::getFilterMode, this::setFilterMode);
        guiSyncManager.syncValue("filtering_mode", (SyncHandler)filteringMode);
        this.fluidFilterContainer.setMaxTransferSize(1);
        return (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)this.getFilter().createPanel(guiSyncManager).size(176, 212)).padding(7)).child((IWidget)CoverWithUI.createTitleRow(this.getFilterContainer().getFilterStack()))).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.column().widthRel(1.0f)).align(Alignment.TopLeft)).top(22)).coverChildrenHeight()).child((IWidget)new CoverWithUI.EnumRowBuilder<FluidFilterMode>(FluidFilterMode.class).value((EnumSyncValue<FluidFilterMode>)filteringMode).lang("cover.filter.mode.title").overlay(16, (IDrawable[])GTGuiTextures.FILTER_MODE_OVERLAY).build())).child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().marginBottom(2)).widthRel(1.0f)).coverChildrenHeight()).setEnabledIf(b -> this.getFilterMode() != FluidFilterMode.FILTER_BOTH)).child((IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().overlay(new IDrawable[]{IKey.dynamic(() -> IKey.lang((String)(this.allowFlow ? "cover.generic.enabled" : "cover.generic.disabled")).get()).color(Integer.valueOf(Color.WHITE.main)).shadow(Boolean.valueOf(false))})).tooltip(tooltip -> tooltip.addLine((IDrawable)IKey.lang((String)"cover.filter.allow_flow.tooltip")))).size(72, 18)).value((IBoolValue)new BooleanSyncValue(() -> this.allowFlow, b -> {
            this.allowFlow = b;
        })))).child((IWidget)((TextWidget)IKey.lang((String)"cover.filter.allow_flow.label").asWidget().height(18)).alignX(1.0f)))).child((IWidget)((Widget)((Widget)new Rectangle().setColor(-11184811).asWidget().height(1)).widthRel(0.95f)).margin(0, 4))).child(this.getFilter().createWidgets(guiSyncManager)))).child((IWidget)((SlotGroupWidget)SlotGroupWidget.playerInventory().bottom(7)).left(7));
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        this.texture.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    @Override
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable T defaultValue) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (defaultValue instanceof IFluidHandler) {
                IFluidHandler delegate = (IFluidHandler)defaultValue;
                if (this.fluidHandler == null || this.fluidHandler.delegate != delegate) {
                    this.fluidHandler = new FluidHandlerFiltered(delegate);
                }
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
            }
            return null;
        }
        return defaultValue;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("FilterMode", this.filterMode.ordinal());
        tagCompound.func_74782_a("Filter", (NBTBase)this.fluidFilterContainer.serializeNBT());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.filterMode = FluidFilterMode.values()[tagCompound.func_74762_e("FilterMode")];
        if (tagCompound.func_74764_b("IsBlacklist")) {
            this.fluidFilterContainer.setFilterStack(this.getDefinition().getDropItemStack());
            this.fluidFilterContainer.handleLegacyNBT(tagCompound);
            this.fluidFilterContainer.setBlacklistFilter(tagCompound.func_74767_n("IsBlacklist"));
        } else {
            this.fluidFilterContainer.deserializeNBT(tagCompound.func_74775_l("Filter"));
        }
    }

    private class FluidHandlerFiltered
    extends FluidHandlerDelegate {
        public FluidHandlerFiltered(IFluidHandler delegate) {
            super(delegate);
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            if (CoverFluidFilter.this.getFilterMode() == FluidFilterMode.FILTER_DRAIN && CoverFluidFilter.this.allowFlow) {
                return super.fill(resource, doFill);
            }
            if (CoverFluidFilter.this.getFilterMode() != FluidFilterMode.FILTER_DRAIN && CoverFluidFilter.this.fluidFilterContainer.test(resource)) {
                return super.fill(resource, doFill);
            }
            return 0;
        }

        @Override
        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (CoverFluidFilter.this.getFilterMode() == FluidFilterMode.FILTER_FILL && CoverFluidFilter.this.allowFlow) {
                return super.drain(resource, doDrain);
            }
            if (CoverFluidFilter.this.getFilterMode() != FluidFilterMode.FILTER_FILL && CoverFluidFilter.this.fluidFilterContainer.test(resource)) {
                return super.drain(resource, doDrain);
            }
            return null;
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack f = super.drain(maxDrain, false);
            return this.drain(f, doDrain);
        }
    }
}

