/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.cover.IFacadeCover;
import gregtech.api.util.GTLog;
import gregtech.client.renderer.handler.FacadeRenderer;
import gregtech.common.covers.facade.FacadeHelper;
import gregtech.common.items.behaviors.FacadeItem;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverFacade
extends CoverBase
implements IFacadeCover {
    private ItemStack facadeStack = ItemStack.field_190927_a;
    private IBlockState facadeState = Blocks.field_150348_b.func_176223_P();

    public CoverFacade(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    public void setFacadeStack(@NotNull ItemStack facadeStack) {
        this.facadeStack = facadeStack.func_77946_l();
        this.writeCustomData(GregtechDataCodes.UPDATE_FACADE_STACK, buf -> buf.func_150788_a(this.facadeStack));
        this.updateFacadeState();
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return true;
    }

    @Override
    public void onAttachment(@NotNull CoverableView coverableView, @NotNull EnumFacing side, @Nullable EntityPlayer player, @NotNull ItemStack itemStack) {
        super.onAttachment(coverableView, side, player, itemStack);
        this.setFacadeStack(FacadeItem.getFacadeStack(itemStack));
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        BlockRenderLayer oldLayer = MinecraftForgeClient.getRenderLayer();
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
        FacadeRenderer.renderBlockCover(renderState, translation, (IBlockAccess)this.getCoverableView().getWorld(), this.getCoverableView().getPos(), this.getAttachedSide().func_176745_a(), this.facadeState, plateBox, layer);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldLayer);
    }

    @Override
    public boolean canRenderInLayer(@NotNull BlockRenderLayer renderLayer) {
        return true;
    }

    @Override
    public IBlockState getVisualState() {
        return this.facadeState;
    }

    @Override
    @NotNull
    public ItemStack getPickItem() {
        ItemStack dropStack = this.getDefinition().getDropItemStack();
        FacadeItem.setFacadeStack(dropStack, this.facadeStack);
        return dropStack;
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeShort(Item.func_150891_b((Item)this.facadeStack.func_77973_b()));
        packetBuffer.writeShort(Items.field_151008_G.getDamage(this.facadeStack));
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        Item item = Item.func_150899_d((int)packetBuffer.readShort());
        short itemDamage = packetBuffer.readShort();
        this.facadeStack = new ItemStack(item, 1, (int)itemDamage);
        this.updateFacadeState();
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74782_a("Facade", (NBTBase)this.facadeStack.func_77955_b(new NBTTagCompound()));
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.facadeStack = new ItemStack(tagCompound.func_74775_l("Facade"));
        this.updateFacadeState();
    }

    @Override
    public void readCustomData(int discriminator, @NotNull PacketBuffer buf) {
        super.readCustomData(discriminator, buf);
        if (discriminator == GregtechDataCodes.UPDATE_FACADE_STACK) {
            try {
                this.facadeStack = buf.func_150791_c();
            }
            catch (IOException e) {
                GTLog.logger.error("Error reading facade stack from network", (Throwable)e);
                this.facadeStack = new ItemStack(Objects.requireNonNull(Blocks.field_150348_b));
                return;
            }
            this.updateFacadeState();
        }
    }

    @Override
    public boolean canPipePassThrough() {
        return true;
    }

    private void updateFacadeState() {
        this.facadeState = FacadeHelper.lookupBlockForItem(this.facadeStack);
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public boolean shouldAutoConnectToPipes() {
        return false;
    }

    @Override
    public boolean canRenderBackside() {
        return false;
    }

    @Override
    public void renderCoverPlate(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
    }
}

