/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.ItemHandlerDelegate;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.CoverableView;
import gregtech.api.mui.GTGuiTextures;
import gregtech.api.mui.GTGuis;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.covers.DistributionMode;
import gregtech.common.covers.IIOMode;
import gregtech.common.covers.ManualImportExportMode;
import gregtech.common.covers.filter.ItemFilterContainer;
import gregtech.common.covers.filter.MatchResult;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipe;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class CoverConveyor
extends CoverBase
implements CoverWithUI,
ITickable,
IControllable {
    public final int tier;
    public final int maxItemTransferRate;
    private int transferRate;
    protected ConveyorMode conveyorMode;
    protected DistributionMode distributionMode;
    protected ManualImportExportMode manualImportExportMode = ManualImportExportMode.DISABLED;
    protected final ItemFilterContainer itemFilterContainer;
    protected int itemsLeftToTransferLastSecond;
    private CoverableItemHandlerWrapper itemHandlerWrapper;
    protected boolean isWorkingAllowed = true;

    public CoverConveyor(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, int tier, int itemsPerSecond) {
        super(definition, coverableView, attachedSide);
        this.tier = tier;
        this.itemsLeftToTransferLastSecond = this.transferRate = (this.maxItemTransferRate = itemsPerSecond);
        this.conveyorMode = ConveyorMode.EXPORT;
        this.distributionMode = DistributionMode.INSERT_FIRST;
        this.itemFilterContainer = new ItemFilterContainer(this);
    }

    public void setTransferRate(int transferRate) {
        this.transferRate = MathHelper.func_76125_a((int)transferRate, (int)1, (int)this.maxItemTransferRate);
        CoverableView coverable = this.getCoverableView();
        coverable.markDirty();
        if (this.getWorld() != null && this.getWorld().field_72995_K) {
            TileEntity te = this.getTileEntityHere();
            if (te instanceof TileEntityItemPipe) {
                ((TileEntityItemPipe)te).resetTransferred();
            }
            if ((te = this.getNeighbor(this.getAttachedSide())) instanceof TileEntityItemPipe) {
                ((TileEntityItemPipe)te).resetTransferred();
            }
        }
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    protected void adjustTransferRate(int amount) {
        this.setTransferRate(MathHelper.func_76125_a((int)(this.transferRate + amount), (int)1, (int)this.maxItemTransferRate));
    }

    public void setConveyorMode(ConveyorMode conveyorMode) {
        this.conveyorMode = conveyorMode;
        this.writeCustomData(GregtechDataCodes.UPDATE_COVER_MODE, buf -> buf.func_179249_a((Enum)conveyorMode));
        this.markDirty();
    }

    public ConveyorMode getConveyorMode() {
        return this.conveyorMode;
    }

    public DistributionMode getDistributionMode() {
        return this.distributionMode;
    }

    public void setDistributionMode(DistributionMode distributionMode) {
        this.distributionMode = distributionMode;
        this.markDirty();
    }

    public ManualImportExportMode getManualImportExportMode() {
        return this.manualImportExportMode;
    }

    protected void setManualImportExportMode(ManualImportExportMode manualImportExportMode) {
        this.manualImportExportMode = manualImportExportMode;
        this.markDirty();
    }

    public ItemFilterContainer getItemFilterContainer() {
        return this.itemFilterContainer;
    }

    public void func_73660_a() {
        CoverableView coverable = this.getCoverableView();
        long timer = coverable.getOffsetTimer();
        if (timer % 5L == 0L && this.isWorkingAllowed && this.itemsLeftToTransferLastSecond > 0) {
            EnumFacing side = this.getAttachedSide();
            TileEntity tileEntity = coverable.getNeighbor(side);
            IItemHandler itemHandler = tileEntity == null ? null : (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
            IItemHandler myItemHandler = (IItemHandler)coverable.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (itemHandler != null && myItemHandler != null) {
                int totalTransferred = this.doTransferItems(itemHandler, myItemHandler, this.itemsLeftToTransferLastSecond);
                this.itemsLeftToTransferLastSecond -= totalTransferred;
            }
        }
        if (timer % 20L == 0L) {
            this.itemsLeftToTransferLastSecond = this.transferRate;
        }
    }

    protected int doTransferItems(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        return this.doTransferItemsAny(itemHandler, myItemHandler, maxTransferAmount);
    }

    protected int doTransferItemsAny(IItemHandler itemHandler, IItemHandler myItemHandler, int maxTransferAmount) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.moveInventoryItems(itemHandler, myItemHandler, maxTransferAmount);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.moveInventoryItems(myItemHandler, itemHandler, maxTransferAmount);
        }
        return 0;
    }

    protected int doTransferItemsByGroup(IItemHandler itemHandler, IItemHandler myItemHandler, Map<Integer, GroupItemInfo> itemInfos, int maxTransferAmount) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.moveInventoryItems(itemHandler, myItemHandler, itemInfos, maxTransferAmount);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.moveInventoryItems(myItemHandler, itemHandler, itemInfos, maxTransferAmount);
        }
        return 0;
    }

    protected Map<Integer, GroupItemInfo> doCountDestinationInventoryItemsByMatchIndex(IItemHandler itemHandler, IItemHandler myItemHandler) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.countInventoryItemsByMatchSlot(myItemHandler);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.countInventoryItemsByMatchSlot(itemHandler);
        }
        return Collections.emptyMap();
    }

    protected Map<ItemStack, TypeItemInfo> doCountSourceInventoryItemsByType(IItemHandler itemHandler, IItemHandler myItemHandler) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return this.countInventoryItemsByType(itemHandler);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return this.countInventoryItemsByType(myItemHandler);
        }
        return Collections.emptyMap();
    }

    protected boolean doTransferItemsExact(IItemHandler itemHandler, IItemHandler myItemHandler, TypeItemInfo itemInfo) {
        if (this.conveyorMode == ConveyorMode.IMPORT) {
            return CoverConveyor.moveInventoryItemsExact(itemHandler, myItemHandler, itemInfo);
        }
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            return CoverConveyor.moveInventoryItemsExact(myItemHandler, itemHandler, itemInfo);
        }
        return false;
    }

    protected static boolean moveInventoryItemsExact(IItemHandler sourceInventory, IItemHandler targetInventory, TypeItemInfo itemInfo) {
        ItemStack resultStack = itemInfo.itemStack.func_77946_l();
        int totalExtractedCount = 0;
        int itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = (Integer)itemInfo.slots.get(i);
            ItemStack extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, true);
            if (!extractedStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)resultStack, (ItemStack)extractedStack) && ItemStack.func_77970_a((ItemStack)resultStack, (ItemStack)extractedStack)) {
                totalExtractedCount += extractedStack.func_190916_E();
                itemsLeftToExtract -= extractedStack.func_190916_E();
            }
            if (itemsLeftToExtract == 0) break;
        }
        if (totalExtractedCount != itemInfo.totalCount) {
            return false;
        }
        resultStack.func_190920_e(totalExtractedCount);
        ItemStack remainder = GTTransferUtils.insertItem(targetInventory, resultStack, true);
        if (!remainder.func_190926_b()) {
            return false;
        }
        GTTransferUtils.insertItem(targetInventory, resultStack, false);
        itemsLeftToExtract = itemInfo.totalCount;
        for (int i = 0; i < itemInfo.slots.size(); ++i) {
            int slotIndex = (Integer)itemInfo.slots.get(i);
            ItemStack extractedStack = sourceInventory.extractItem(slotIndex, itemsLeftToExtract, false);
            if (!extractedStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)resultStack, (ItemStack)extractedStack) && ItemStack.func_77970_a((ItemStack)resultStack, (ItemStack)extractedStack)) {
                itemsLeftToExtract -= extractedStack.func_190916_E();
            }
            if (itemsLeftToExtract == 0) break;
        }
        return true;
    }

    protected int moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory, Map<Integer, GroupItemInfo> itemInfos, int maxTransferAmount) {
        int itemsLeftToTransfer = maxTransferAmount;
        for (int i = 0; i < sourceInventory.getSlots(); ++i) {
            ItemStack itemStack = sourceInventory.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            MatchResult matchResult = this.itemFilterContainer.match(itemStack);
            int matchSlotIndex = matchResult.getFilterIndex();
            if (!matchResult.isMatched() || !itemInfos.containsKey(matchSlotIndex)) continue;
            GroupItemInfo itemInfo = itemInfos.get(matchSlotIndex);
            ItemStack extractedStack = sourceInventory.extractItem(i, Math.min(itemInfo.totalCount, itemsLeftToTransfer), true);
            ItemStack remainderStack = GTTransferUtils.insertItem(targetInventory, extractedStack, true);
            int amountToInsert = extractedStack.func_190916_E() - remainderStack.func_190916_E();
            if (amountToInsert <= 0 || (extractedStack = sourceInventory.extractItem(i, amountToInsert, false)).func_190926_b()) continue;
            GTTransferUtils.insertItem(targetInventory, extractedStack, false);
            itemsLeftToTransfer -= extractedStack.func_190916_E();
            itemInfo.totalCount -= extractedStack.func_190916_E();
            if (itemInfo.totalCount == 0) {
                itemInfos.remove(matchSlotIndex);
                if (itemInfos.isEmpty()) break;
            }
            if (itemsLeftToTransfer == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    protected int moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory, int maxTransferAmount) {
        int itemsLeftToTransfer = maxTransferAmount;
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            MatchResult result;
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, itemsLeftToTransfer, true);
            if (sourceStack.func_190926_b() || !(result = this.itemFilterContainer.match(sourceStack)).isMatched()) continue;
            ItemStack remainder = GTTransferUtils.insertItem(targetInventory, sourceStack, true);
            int amountToInsert = sourceStack.func_190916_E() - remainder.func_190916_E();
            if (amountToInsert <= 0 || (sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false)).func_190926_b()) continue;
            GTTransferUtils.insertItem(targetInventory, sourceStack, false);
            if ((itemsLeftToTransfer -= sourceStack.func_190916_E()) == 0) break;
        }
        return maxTransferAmount - itemsLeftToTransfer;
    }

    @NotNull
    protected Map<ItemStack, TypeItemInfo> countInventoryItemsByType(@NotNull IItemHandler inventory) {
        Object2ObjectOpenCustomHashMap result = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            TypeItemInfo itemInfo;
            MatchResult matchResult;
            ItemStack itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.func_190926_b() || !(matchResult = this.itemFilterContainer.match(itemStack)).isMatched()) continue;
            if (!result.containsKey(itemStack)) {
                itemInfo = new TypeItemInfo(itemStack.func_77946_l(), matchResult.getFilterIndex(), (IntList)new IntArrayList(), 0);
                itemInfo.totalCount += itemStack.func_190916_E();
                itemInfo.slots.add(srcIndex);
                result.put(itemStack.func_77946_l(), itemInfo);
                continue;
            }
            itemInfo = (TypeItemInfo)result.get(itemStack);
            itemInfo.totalCount += itemStack.func_190916_E();
            itemInfo.slots.add(srcIndex);
        }
        return result;
    }

    @NotNull
    protected Map<Integer, GroupItemInfo> countInventoryItemsByMatchSlot(@NotNull IItemHandler inventory) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        for (int srcIndex = 0; srcIndex < inventory.getSlots(); ++srcIndex) {
            GroupItemInfo itemInfo;
            MatchResult matchResult;
            ItemStack itemStack = inventory.getStackInSlot(srcIndex);
            if (itemStack.func_190926_b() || !(matchResult = this.itemFilterContainer.match(itemStack)).isMatched()) continue;
            int matchedSlot = matchResult.getFilterIndex();
            if (!result.containsKey(matchedSlot)) {
                itemInfo = new GroupItemInfo(matchedSlot, (Set<ItemStack>)new ObjectOpenCustomHashSet((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount()), 0);
                itemInfo.itemStackTypes.add(itemStack.func_77946_l());
                itemInfo.totalCount += itemStack.func_190916_E();
                result.put(matchedSlot, itemInfo);
                continue;
            }
            itemInfo = (GroupItemInfo)result.get(matchedSlot);
            itemInfo.itemStackTypes.add(itemStack.func_77946_l());
            itemInfo.totalCount += itemStack.func_190916_E();
        }
        return result;
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return coverable.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getAttachedSide()) != null;
    }

    @Override
    public boolean canInteractWithOutputSide() {
        return true;
    }

    @Override
    public void onRemoval() {
        this.dropInventoryContents((IItemHandlerModifiable)this.itemFilterContainer);
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        if (this.conveyorMode == ConveyorMode.EXPORT) {
            Textures.CONVEYOR_OVERLAY.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
        } else {
            Textures.CONVEYOR_OVERLAY_INVERTED.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
        }
    }

    @Override
    @NotNull
    public EnumActionResult onScrewdriverClick(@NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull CuboidRayTraceResult hitResult) {
        if (!this.getCoverableView().getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (defaultValue == null) {
                return null;
            }
            IItemHandler delegate = (IItemHandler)defaultValue;
            if (this.itemHandlerWrapper == null || this.itemHandlerWrapper.delegate != delegate) {
                this.itemHandlerWrapper = new CoverableItemHandlerWrapper(delegate);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlerWrapper);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return defaultValue;
    }

    @Override
    public boolean usesMui2() {
        return true;
    }

    @Override
    public ModularPanel buildUI(SidedPosGuiData guiData, PanelSyncManager guiSyncManager) {
        ModularPanel panel = GTGuis.createPanel(this, 176, 210);
        this.getItemFilterContainer().setMaxTransferSize(this.getMaxStackSize());
        return ((ModularPanel)((ModularPanel)panel.child((IWidget)CoverWithUI.createTitleRow(this.getPickItem()))).child(this.createUI((GuiData)guiData, guiSyncManager))).bindPlayerInventory();
    }

    protected ParentWidget<Flow> createUI(GuiData data, PanelSyncManager guiSyncManager) {
        Flow column = (Flow)((Flow)((Flow)((Flow)Flow.column().top(24)).margin(7, 0)).widthRel(1.0f)).coverChildrenHeight();
        EnumSyncValue manualIOmode = new EnumSyncValue(ManualImportExportMode.class, this::getManualImportExportMode, this::setManualImportExportMode);
        EnumSyncValue conveyorMode = new EnumSyncValue(ConveyorMode.class, this::getConveyorMode, this::setConveyorMode);
        IntSyncValue throughput = new IntSyncValue(this::getTransferRate, this::setTransferRate);
        StringSyncValue formattedThroughput = new StringSyncValue(() -> ((IntSyncValue)throughput).getStringValue(), arg_0 -> ((IntSyncValue)throughput).setStringValue(arg_0));
        EnumSyncValue distributionMode = new EnumSyncValue(DistributionMode.class, this::getDistributionMode, this::setDistributionMode);
        guiSyncManager.syncValue("manual_io", (SyncHandler)manualIOmode);
        guiSyncManager.syncValue("conveyor_mode", (SyncHandler)conveyorMode);
        guiSyncManager.syncValue("distribution_mode", (SyncHandler)distributionMode);
        guiSyncManager.syncValue("throughput", (SyncHandler)throughput);
        if (this.createThroughputRow()) {
            column.child((IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)Flow.row().coverChildrenHeight()).marginBottom(2)).widthRel(1.0f)).child((IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().left(0)).width(18)).onMousePressed(mouseButton -> {
                int val = throughput.getValue() - this.getIncrementValue(MouseData.create((int)mouseButton));
                throughput.setValue(Integer.valueOf(val), true, true);
                return true;
            }).onUpdateListener(w -> w.overlay(new IDrawable[]{this.createAdjustOverlay(false)})))).child((IWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().left(18)).right(18)).setTextColor(Color.WHITE.darker(1)).setNumbers(1, this.maxItemTransferRate).value((IStringValue)formattedThroughput).background(new IDrawable[]{GTGuiTextures.DISPLAY}))).child((IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().right(0)).width(18)).onMousePressed(mouseButton -> {
                int val = throughput.getValue() + this.getIncrementValue(MouseData.create((int)mouseButton));
                throughput.setValue(Integer.valueOf(val), true, true);
                return true;
            }).onUpdateListener(w -> w.overlay(new IDrawable[]{this.createAdjustOverlay(true)}))));
        }
        if (this.createFilterRow()) {
            column.child(this.getItemFilterContainer().initUI(data, guiSyncManager));
        }
        if (this.createManualIOModeRow()) {
            column.child((IWidget)new CoverWithUI.EnumRowBuilder<ManualImportExportMode>(ManualImportExportMode.class).value((EnumSyncValue<ManualImportExportMode>)manualIOmode).lang("cover.generic.manual_io").overlay(new IDrawable[]{new DynamicDrawable(() -> ((ConveyorMode)conveyorMode.getValue()).isImport() ? GTGuiTextures.MANUAL_IO_OVERLAY_OUT[0] : GTGuiTextures.MANUAL_IO_OVERLAY_IN[0]), new DynamicDrawable(() -> ((ConveyorMode)conveyorMode.getValue()).isImport() ? GTGuiTextures.MANUAL_IO_OVERLAY_OUT[1] : GTGuiTextures.MANUAL_IO_OVERLAY_IN[1]), new DynamicDrawable(() -> ((ConveyorMode)conveyorMode.getValue()).isImport() ? GTGuiTextures.MANUAL_IO_OVERLAY_OUT[2] : GTGuiTextures.MANUAL_IO_OVERLAY_IN[2])}).build());
        }
        if (this.createConveyorModeRow()) {
            column.child((IWidget)new CoverWithUI.EnumRowBuilder<ConveyorMode>(ConveyorMode.class).value((EnumSyncValue<ConveyorMode>)conveyorMode).lang("cover.generic.io").overlay((IDrawable[])GTGuiTextures.CONVEYOR_MODE_OVERLAY).build());
        }
        if (this.createDistributionModeRow()) {
            column.child((IWidget)new CoverWithUI.EnumRowBuilder<DistributionMode>(DistributionMode.class).value((EnumSyncValue<DistributionMode>)distributionMode).overlay(16, (IDrawable[])GTGuiTextures.DISTRIBUTION_MODE_OVERLAY).lang("cover.conveyor.distribution.name").build());
        }
        return column;
    }

    protected boolean createThroughputRow() {
        return true;
    }

    protected boolean createFilterRow() {
        return true;
    }

    protected boolean createManualIOModeRow() {
        return true;
    }

    protected boolean createConveyorModeRow() {
        return true;
    }

    protected boolean createDistributionModeRow() {
        return true;
    }

    protected int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingAllowed;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.isWorkingAllowed = isActivationAllowed;
    }

    @Override
    public void readCustomData(int discriminator, @NotNull PacketBuffer buf) {
        super.readCustomData(discriminator, buf);
        if (discriminator == GregtechDataCodes.UPDATE_COVER_MODE) {
            this.conveyorMode = (ConveyorMode)buf.func_179257_a(ConveyorMode.class);
            this.getCoverableView().scheduleRenderUpdate();
        }
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.writeInitialSyncData(packetBuffer);
        packetBuffer.writeInt(this.transferRate);
        packetBuffer.writeByte(this.conveyorMode.ordinal());
        packetBuffer.writeByte(this.distributionMode.ordinal());
        packetBuffer.writeByte(this.manualImportExportMode.ordinal());
        this.getItemFilterContainer().writeInitialSyncData(packetBuffer);
    }

    @Override
    public void readInitialSyncData(@NotNull PacketBuffer packetBuffer) {
        super.readInitialSyncData(packetBuffer);
        this.transferRate = packetBuffer.readInt();
        this.conveyorMode = ConveyorMode.VALUES[packetBuffer.readByte()];
        this.distributionMode = DistributionMode.VALUES[packetBuffer.readByte()];
        this.manualImportExportMode = ManualImportExportMode.VALUES[packetBuffer.readByte()];
        this.getItemFilterContainer().readInitialSyncData(packetBuffer);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferRate", this.transferRate);
        tagCompound.func_74768_a("ConveyorMode", this.conveyorMode.ordinal());
        tagCompound.func_74768_a("DistributionMode", this.distributionMode.ordinal());
        tagCompound.func_74757_a("WorkingAllowed", this.isWorkingAllowed);
        tagCompound.func_74768_a("ManualImportExportMode", this.manualImportExportMode.ordinal());
        tagCompound.func_74782_a("Filter", (NBTBase)this.itemFilterContainer.serializeNBT());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferRate = tagCompound.func_74762_e("TransferRate");
        this.conveyorMode = ConveyorMode.VALUES[tagCompound.func_74762_e("ConveyorMode")];
        this.distributionMode = DistributionMode.VALUES[tagCompound.func_74762_e("DistributionMode")];
        this.isWorkingAllowed = tagCompound.func_74767_n("WorkingAllowed");
        this.manualImportExportMode = ManualImportExportMode.VALUES[tagCompound.func_74762_e("ManualImportExportMode")];
        NBTTagCompound filterTag = tagCompound.func_74775_l("Filter");
        if (filterTag.func_74764_b("IsBlacklist")) {
            this.itemFilterContainer.handleLegacyNBT(filterTag);
        } else {
            this.itemFilterContainer.deserializeNBT(filterTag);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.VOLTAGE_CASINGS[this.tier].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }

    public static enum ConveyorMode implements IStringSerializable,
    IIOMode
    {
        IMPORT("cover.conveyor.mode.import"),
        EXPORT("cover.conveyor.mode.export");

        public static final ConveyorMode[] VALUES;
        public final String localeName;

        private ConveyorMode(String localeName) {
            this.localeName = localeName;
        }

        @NotNull
        public String func_176610_l() {
            return this.localeName;
        }

        @Override
        public boolean isImport() {
            return this == IMPORT;
        }

        static {
            VALUES = ConveyorMode.values();
        }
    }

    protected static class TypeItemInfo {
        public final ItemStack itemStack;
        public final int filterSlot;
        public final IntList slots;
        public int totalCount;

        public TypeItemInfo(ItemStack itemStack, int filterSlot, IntList slots, int totalCount) {
            this.itemStack = itemStack;
            this.filterSlot = filterSlot;
            this.slots = slots;
            this.totalCount = totalCount;
        }
    }

    protected static class GroupItemInfo {
        public final int filterSlot;
        public final Set<ItemStack> itemStackTypes;
        public int totalCount;

        public GroupItemInfo(int filterSlot, Set<ItemStack> itemStackTypes, int totalCount) {
            this.filterSlot = filterSlot;
            this.itemStackTypes = itemStackTypes;
            this.totalCount = totalCount;
        }
    }

    private class CoverableItemHandlerWrapper
    extends ItemHandlerDelegate {
        public CoverableItemHandlerWrapper(IItemHandler delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (CoverConveyor.this.conveyorMode == ConveyorMode.EXPORT && CoverConveyor.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return stack;
            }
            if (CoverConveyor.this.manualImportExportMode == ManualImportExportMode.FILTERED && !CoverConveyor.this.itemFilterContainer.test(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CoverConveyor.this.conveyorMode == ConveyorMode.IMPORT && CoverConveyor.this.manualImportExportMode == ManualImportExportMode.DISABLED) {
                return ItemStack.field_190927_a;
            }
            if (CoverConveyor.this.manualImportExportMode == ManualImportExportMode.FILTERED) {
                ItemStack result = super.extractItem(slot, amount, true);
                if (result.func_190926_b() || !CoverConveyor.this.itemFilterContainer.test(result)) {
                    return ItemStack.field_190927_a;
                }
                return simulate ? result : super.extractItem(slot, amount, false);
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

