/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.items.behavior.CoverItemBehavior;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverDigitalInterface;
import gregtech.common.covers.CoverDigitalInterfaceWireless;
import gregtech.common.covers.CoverFacade;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.CoverFluidVoiding;
import gregtech.common.covers.CoverFluidVoidingAdvanced;
import gregtech.common.covers.CoverInfiniteWater;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverItemVoiding;
import gregtech.common.covers.CoverItemVoidingAdvanced;
import gregtech.common.covers.CoverMachineController;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.CoverScreen;
import gregtech.common.covers.CoverShutter;
import gregtech.common.covers.CoverSolarPanel;
import gregtech.common.covers.CoverStorage;
import gregtech.common.covers.detector.CoverDetectorActivity;
import gregtech.common.covers.detector.CoverDetectorActivityAdvanced;
import gregtech.common.covers.detector.CoverDetectorEnergy;
import gregtech.common.covers.detector.CoverDetectorEnergyAdvanced;
import gregtech.common.covers.detector.CoverDetectorFluid;
import gregtech.common.covers.detector.CoverDetectorFluidAdvanced;
import gregtech.common.covers.detector.CoverDetectorItem;
import gregtech.common.covers.detector.CoverDetectorItemAdvanced;
import gregtech.common.covers.detector.CoverDetectorMaintenance;
import gregtech.common.covers.ender.CoverEnderFluidLink;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.CoverDigitalInterfaceWirelessPlaceBehaviour;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class CoverBehaviors {
    private static int rollingId = 0;

    private CoverBehaviors() {
    }

    public static void init() {
        GTLog.logger.info("Registering cover behaviors...");
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.lv"), MetaItems.CONVEYOR_MODULE_LV, (def, tile, side) -> new CoverConveyor(def, tile, side, 1, 8));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.mv"), MetaItems.CONVEYOR_MODULE_MV, (def, tile, side) -> new CoverConveyor(def, tile, side, 2, 32));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.hv"), MetaItems.CONVEYOR_MODULE_HV, (def, tile, side) -> new CoverConveyor(def, tile, side, 3, 64));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.ev"), MetaItems.CONVEYOR_MODULE_EV, (def, tile, side) -> new CoverConveyor(def, tile, side, 4, 192));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.iv"), MetaItems.CONVEYOR_MODULE_IV, (def, tile, side) -> new CoverConveyor(def, tile, side, 5, 512));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.luv"), MetaItems.CONVEYOR_MODULE_LuV, (def, tile, side) -> new CoverConveyor(def, tile, side, 6, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.zpm"), MetaItems.CONVEYOR_MODULE_ZPM, (def, tile, side) -> new CoverConveyor(def, tile, side, 7, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.uv"), MetaItems.CONVEYOR_MODULE_UV, (def, tile, side) -> new CoverConveyor(def, tile, side, 8, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.lv"), MetaItems.ROBOT_ARM_LV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 1, 8));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.mv"), MetaItems.ROBOT_ARM_MV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 2, 32));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.hv"), MetaItems.ROBOT_ARM_HV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 3, 64));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.ev"), MetaItems.ROBOT_ARM_EV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 4, 192));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.iv"), MetaItems.ROBOT_ARM_IV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 5, 512));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.luv"), MetaItems.ROBOT_ARM_LuV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 6, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.zpm"), MetaItems.ROBOT_ARM_ZPM, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 7, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.uv"), MetaItems.ROBOT_ARM_UV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 8, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("ore_dictionary_filter"), MetaItems.ORE_DICTIONARY_FILTER, (def, tile, side) -> new CoverItemFilter(def, tile, side, "cover.ore_dictionary_filter.title", Textures.ORE_DICTIONARY_FILTER_OVERLAY));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("item_filter"), MetaItems.ITEM_FILTER, (def, tile, side) -> new CoverItemFilter(def, tile, side, "cover.item_filter.title", Textures.ITEM_FILTER_FILTER_OVERLAY));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid_filter"), MetaItems.FLUID_FILTER, (def, tile, side) -> new CoverFluidFilter(def, tile, side, "cover.fluid_filter.title", Textures.FLUID_FILTER_OVERLAY));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("shutter"), MetaItems.COVER_SHUTTER, CoverShutter::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.basic"), MetaItems.COVER_SOLAR_PANEL, (def, tile, side) -> new CoverSolarPanel(def, tile, side, 1L));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.ulv"), MetaItems.COVER_SOLAR_PANEL_ULV, (def, tile, side) -> new CoverSolarPanel(def, tile, side, GTValues.V[0]));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.lv"), MetaItems.COVER_SOLAR_PANEL_LV, (def, tile, side) -> new CoverSolarPanel(def, tile, side, GTValues.V[1]));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.mv"), MetaItems.COVER_SOLAR_PANEL_MV, (def, tile, side) -> new CoverSolarPanel(def, tile, side, GTValues.V[2]));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.hv"), MetaItems.COVER_SOLAR_PANEL_HV, (def, tile, side) -> new CoverSolarPanel(def, tile, side, GTValues.V[3]));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.ev"), MetaItems.COVER_SOLAR_PANEL_EV, (def, tile, side) -> new CoverSolarPanel(def, tile, side, GTValues.V[4]));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.iv"), MetaItems.COVER_SOLAR_PANEL_IV, (def, tile, side) -> new CoverSolarPanel(def, tile, side, GTValues.V[5]));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.luv"), MetaItems.COVER_SOLAR_PANEL_LUV, (def, tile, side) -> new CoverSolarPanel(def, tile, side, GTValues.V[6]));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.zpm"), MetaItems.COVER_SOLAR_PANEL_ZPM, (def, tile, side) -> new CoverSolarPanel(def, tile, side, GTValues.V[7]));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("solar_panel.uv"), MetaItems.COVER_SOLAR_PANEL_UV, (def, tile, side) -> new CoverSolarPanel(def, tile, side, GTValues.V[8]));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("machine_controller"), MetaItems.COVER_MACHINE_CONTROLLER, CoverMachineController::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("smart_filter"), MetaItems.SMART_FILTER, (def, tile, side) -> new CoverItemFilter(def, tile, side, "cover.smart_item_filter.title", Textures.SMART_FILTER_FILTER_OVERLAY));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("facade"), MetaItems.COVER_FACADE, CoverFacade::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("screen"), MetaItems.COVER_SCREEN, CoverScreen::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("energy_detector"), MetaItems.COVER_ENERGY_DETECTOR, CoverDetectorEnergy::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("energy_detector_advanced"), MetaItems.COVER_ENERGY_DETECTOR_ADVANCED, CoverDetectorEnergyAdvanced::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid_detector"), MetaItems.COVER_FLUID_DETECTOR, CoverDetectorFluid::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid_detector_advanced"), MetaItems.COVER_FLUID_DETECTOR_ADVANCED, CoverDetectorFluidAdvanced::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("item_detector"), MetaItems.COVER_ITEM_DETECTOR, CoverDetectorItem::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("item_detector_advanced"), MetaItems.COVER_ITEM_DETECTOR_ADVANCED, CoverDetectorItemAdvanced::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("activity_detector"), MetaItems.COVER_ACTIVITY_DETECTOR, CoverDetectorActivity::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("activity_detector_advanced"), MetaItems.COVER_ACTIVITY_DETECTOR_ADVANCED, CoverDetectorActivityAdvanced::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("maintenance_detector"), MetaItems.COVER_MAINTENANCE_DETECTOR, CoverDetectorMaintenance::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("infinite_water"), MetaItems.COVER_INFINITE_WATER, CoverInfiniteWater::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("ender_fluid_link"), MetaItems.COVER_ENDER_FLUID_LINK, CoverEnderFluidLink::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("cover.digital"), MetaItems.COVER_DIGITAL_INTERFACE, CoverDigitalInterface::new);
        MetaItems.COVER_DIGITAL_INTERFACE_WIRELESS.addComponents(new CoverDigitalInterfaceWirelessPlaceBehaviour(CoverBehaviors.registerCover(GTUtility.gregtechId("cover.digital.wireless"), MetaItems.COVER_DIGITAL_INTERFACE_WIRELESS.getStackForm(), CoverDigitalInterfaceWireless::new)));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.lv"), MetaItems.ELECTRIC_PUMP_LV, (def, tile, side) -> new CoverPump(def, tile, side, 1, 1280));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.mv"), MetaItems.ELECTRIC_PUMP_MV, (def, tile, side) -> new CoverPump(def, tile, side, 2, 5120));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.hv"), MetaItems.ELECTRIC_PUMP_HV, (def, tile, side) -> new CoverPump(def, tile, side, 3, 20480));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.ev"), MetaItems.ELECTRIC_PUMP_EV, (def, tile, side) -> new CoverPump(def, tile, side, 4, 81920));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.iv"), MetaItems.ELECTRIC_PUMP_IV, (def, tile, side) -> new CoverPump(def, tile, side, 5, 327680));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.luv"), MetaItems.ELECTRIC_PUMP_LuV, (def, tile, side) -> new CoverPump(def, tile, side, 6, 0x140000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.zpm"), MetaItems.ELECTRIC_PUMP_ZPM, (def, tile, side) -> new CoverPump(def, tile, side, 7, 0x500000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.uv"), MetaItems.ELECTRIC_PUMP_UV, (def, tile, side) -> new CoverPump(def, tile, side, 8, 0x1400000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid.regulator.lv"), MetaItems.FLUID_REGULATOR_LV, (def, tile, side) -> new CoverFluidRegulator(def, tile, side, 1, 1280));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid.regulator.mv"), MetaItems.FLUID_REGULATOR_MV, (def, tile, side) -> new CoverFluidRegulator(def, tile, side, 2, 5120));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid.regulator.hv"), MetaItems.FLUID_REGULATOR_HV, (def, tile, side) -> new CoverFluidRegulator(def, tile, side, 3, 20480));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid.regulator.ev"), MetaItems.FLUID_REGULATOR_EV, (def, tile, side) -> new CoverFluidRegulator(def, tile, side, 4, 81920));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid.regulator.iv"), MetaItems.FLUID_REGULATOR_IV, (def, tile, side) -> new CoverFluidRegulator(def, tile, side, 5, 327680));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid.regulator.luv"), MetaItems.FLUID_REGULATOR_LUV, (def, tile, side) -> new CoverFluidRegulator(def, tile, side, 6, 0x140000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid.regulator.zpm"), MetaItems.FLUID_REGULATOR_ZPM, (def, tile, side) -> new CoverFluidRegulator(def, tile, side, 7, 0x500000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid.regulator.uv"), MetaItems.FLUID_REGULATOR_UV, (def, tile, side) -> new CoverFluidRegulator(def, tile, side, 8, 0x1400000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.uhv"), MetaItems.CONVEYOR_MODULE_UHV, (def, tile, side) -> new CoverConveyor(def, tile, side, 9, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.uev"), MetaItems.CONVEYOR_MODULE_UEV, (def, tile, side) -> new CoverConveyor(def, tile, side, 10, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.uiv"), MetaItems.CONVEYOR_MODULE_UIV, (def, tile, side) -> new CoverConveyor(def, tile, side, 11, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.uxv"), MetaItems.CONVEYOR_MODULE_UXV, (def, tile, side) -> new CoverConveyor(def, tile, side, 12, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("conveyor.opv"), MetaItems.CONVEYOR_MODULE_OpV, (def, tile, side) -> new CoverConveyor(def, tile, side, 13, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.uhv"), MetaItems.ROBOT_ARM_UHV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 9, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.uev"), MetaItems.ROBOT_ARM_UEV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 10, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.uiv"), MetaItems.ROBOT_ARM_UIV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 11, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.uxv"), MetaItems.ROBOT_ARM_UXV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 12, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("robotic_arm.opv"), MetaItems.ROBOT_ARM_OpV, (def, tile, side) -> new CoverRoboticArm(def, tile, side, 13, 1024));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.uhv"), MetaItems.ELECTRIC_PUMP_UHV, (def, tile, side) -> new CoverPump(def, tile, side, 9, 0x1400000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.uev"), MetaItems.ELECTRIC_PUMP_UEV, (def, tile, side) -> new CoverPump(def, tile, side, 10, 0x1400000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.uiv"), MetaItems.ELECTRIC_PUMP_UIV, (def, tile, side) -> new CoverPump(def, tile, side, 11, 0x1400000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.uxv"), MetaItems.ELECTRIC_PUMP_UXV, (def, tile, side) -> new CoverPump(def, tile, side, 12, 0x1400000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("pump.opv"), MetaItems.ELECTRIC_PUMP_OpV, (def, tile, side) -> new CoverPump(def, tile, side, 13, 0x1400000));
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid_voiding"), MetaItems.COVER_FLUID_VOIDING, CoverFluidVoiding::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("fluid_voiding.advanced"), MetaItems.COVER_FLUID_VOIDING_ADVANCED, CoverFluidVoidingAdvanced::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("item_voiding"), MetaItems.COVER_ITEM_VOIDING, CoverItemVoiding::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("item_voiding.advanced"), MetaItems.COVER_ITEM_VOIDING_ADVANCED, CoverItemVoidingAdvanced::new);
        CoverBehaviors.registerBehavior(GTUtility.gregtechId("storage"), MetaItems.COVER_STORAGE, CoverStorage::new);
    }

    public static void registerBehavior(@NotNull ResourceLocation coverId, @NotNull MetaItem.MetaValueItem placerItem, @NotNull CoverDefinition.CoverCreator behaviorCreator) {
        placerItem.addComponents(new CoverItemBehavior(CoverBehaviors.registerCover(coverId, placerItem.getStackForm(), behaviorCreator)));
    }

    @NotNull
    public static CoverDefinition registerCover(@NotNull ResourceLocation coverId, @NotNull ItemStack itemStack, @NotNull CoverDefinition.CoverCreator behaviorCreator) {
        CoverDefinition coverDefinition = new CoverDefinition(coverId, behaviorCreator, itemStack);
        GregTechAPI.COVER_REGISTRY.func_177775_a(rollingId++, coverId, coverDefinition);
        return coverDefinition;
    }
}

