/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.explosive;

import gregtech.common.creativetab.GTCreativeTabs;
import gregtech.common.entities.EntityGTExplosive;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockGTExplosive
extends Block {
    private final boolean canRedstoneActivate;
    private final boolean explodeOnMine;
    private final int fuseLength;

    public BlockGTExplosive(Material materialIn, boolean canRedstoneActivate, boolean explodeOnMine, int fuseLength) {
        super(materialIn);
        this.canRedstoneActivate = canRedstoneActivate;
        this.explodeOnMine = explodeOnMine;
        this.fuseLength = fuseLength;
        this.func_149647_a(GTCreativeTabs.TAB_GREGTECH_TOOLS);
    }

    protected abstract EntityGTExplosive createEntity(World var1, BlockPos var2, EntityLivingBase var3);

    public float func_149638_a(@NotNull Entity exploder) {
        return 1.0f;
    }

    public boolean canBeReplacedByLeaves(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos) {
        return false;
    }

    public boolean func_149721_r(@NotNull IBlockState state) {
        return true;
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean func_149659_a(@NotNull Explosion explosion) {
        return false;
    }

    public void explode(World world, BlockPos pos, EntityLivingBase exploder) {
        if (!world.field_72995_K) {
            EntityGTExplosive entity = this.createEntity(world, pos, exploder);
            entity.func_184534_a(this.fuseLength);
            world.func_72838_d((Entity)entity);
            world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void func_180652_a(@NotNull World world, @NotNull BlockPos pos, @NotNull Explosion explosion) {
        if (!world.field_72995_K) {
            EntityGTExplosive entity = this.createEntity(world, pos, explosion.func_94613_c());
            entity.func_184534_a(world.field_73012_v.nextInt(this.fuseLength / 4) + this.fuseLength / 8);
            world.func_72838_d((Entity)entity);
        }
    }

    public boolean func_180639_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!(stack.func_190926_b() || stack.func_77973_b() != Items.field_151033_d && stack.func_77973_b() != Items.field_151059_bz)) {
            this.explode(world, pos, (EntityLivingBase)player);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            if (stack.func_77973_b() == Items.field_151033_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            } else if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180653_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, float chance, int fortune) {
        EntityPlayer player;
        if (this.explodeOnMine && !(player = (EntityPlayer)this.harvesters.get()).func_70093_af()) {
            this.explode(world, pos, (EntityLivingBase)player);
            return;
        }
        super.func_180653_a(world, pos, state, chance, fortune);
    }

    public void func_180634_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entity) {
        EntityArrow arrow;
        if (!world.field_72995_K && entity instanceof EntityArrow && (arrow = (EntityArrow)entity).func_70027_ad()) {
            EntityLivingBase living;
            Entity entity2 = arrow.field_70250_c;
            this.explode(world, pos, entity2 instanceof EntityLivingBase ? (living = (EntityLivingBase)entity2) : null);
            world.func_175698_g(pos);
        }
    }

    public void func_176213_c(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (this.canRedstoneActivate && world.func_175640_z(pos)) {
            this.explode(world, pos, null);
            world.func_175698_g(pos);
        }
    }

    public void func_189540_a(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos) {
        if (this.canRedstoneActivate && world.func_175640_z(pos)) {
            this.explode(world, pos, null);
            world.func_175698_g(pos);
        }
    }

    public void func_190948_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        if (this.explodeOnMine) {
            tooltip.add(I18n.func_135052_a((String)"tile.gt_explosive.breaking_tooltip", (Object[])new Object[0]));
        }
        if (!this.canRedstoneActivate) {
            tooltip.add(I18n.func_135052_a((String)"tile.gt_explosive.lighting_tooltip", (Object[])new Object[0]));
        }
    }
}

