/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.properties.PropertyMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;

public abstract class BlockMaterialBase
extends Block {
    public BlockMaterialBase(Material material) {
        super(material);
    }

    @NotNull
    public ItemStack getItem(@NotNull gregtech.api.unification.material.Material material) {
        return GTUtility.toItem(this.func_176223_P().func_177226_a((IProperty)this.getVariantProperty(), (Comparable)material));
    }

    @NotNull
    public gregtech.api.unification.material.Material getGtMaterial(int meta) {
        if (meta >= this.getVariantProperty().getAllowedValues().size()) {
            meta = 0;
        }
        return (gregtech.api.unification.material.Material)this.getVariantProperty().getAllowedValues().get(meta);
    }

    @NotNull
    public gregtech.api.unification.material.Material getGtMaterial(@NotNull ItemStack stack) {
        return this.getGtMaterial(stack.func_77960_j());
    }

    @NotNull
    public gregtech.api.unification.material.Material getGtMaterial(@NotNull IBlockState state) {
        return (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.getVariantProperty());
    }

    @NotNull
    public IBlockState getBlock(@NotNull gregtech.api.unification.material.Material material) {
        return this.func_176223_P().func_177226_a((IProperty)this.getVariantProperty(), (Comparable)material);
    }

    @NotNull
    public abstract PropertyMaterial getVariantProperty();

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariantProperty()});
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.getVariantProperty(), (Comparable)this.getGtMaterial(meta));
    }

    public int func_176201_c(@NotNull IBlockState state) {
        return this.getVariantProperty().getAllowedValues().indexOf((Object)state.func_177229_b((IProperty)this.getVariantProperty()));
    }

    public int func_180651_a(@NotNull IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> list) {
        for (IBlockState state : this.field_176227_L.func_177619_a()) {
            if (this.getGtMaterial(state) == Materials.NULL) continue;
            list.add((Object)GTUtility.toItem(state));
        }
    }

    @NotNull
    public MapColor func_180659_g(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        return this.func_149688_o(state).func_151565_r();
    }

    public int getFlammability(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(world.func_180495_p(pos));
        if (material.hasFlag(MaterialFlags.FLAMMABLE)) {
            return 20;
        }
        return super.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(world.func_180495_p(pos));
        if (material.hasFlag(MaterialFlags.FLAMMABLE)) {
            return 5;
        }
        return super.getFireSpreadSpeed(world, pos, face);
    }
}

