/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.block.ItemBlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.util.GTLog;
import gregtech.client.model.MaterialStateMapper;
import gregtech.client.model.modelfactories.MaterialBlockModelLoader;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMaterialBase;
import gregtech.common.blocks.properties.PropertyMaterial;
import gregtech.common.creativetab.GTCreativeTabs;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockFrame
extends BlockMaterialBase {
    public static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 1.0, 0.95);

    public static BlockFrame create(gregtech.api.unification.material.Material[] materials) {
        final PropertyMaterial property = PropertyMaterial.create("variant", materials);
        return new BlockFrame(){

            @Override
            @NotNull
            public PropertyMaterial getVariantProperty() {
                return property;
            }
        };
    }

    private BlockFrame() {
        super(Material.field_151573_f);
        this.func_149663_c("frame");
        this.func_149711_c(3.0f);
        this.func_149752_b(6.0f);
        this.func_149647_a(GTCreativeTabs.TAB_GREGTECH_MATERIALS);
    }

    public String getHarvestTool(@NotNull IBlockState state) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        if (ModHandler.isMaterialWood(material)) {
            return "axe";
        }
        return "wrench";
    }

    @NotNull
    public SoundType getSoundType(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @Nullable Entity entity) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        if (ModHandler.isMaterialWood(material)) {
            return SoundType.field_185848_a;
        }
        return SoundType.field_185852_e;
    }

    public SoundType getSoundType(ItemStack stack) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(stack);
        if (ModHandler.isMaterialWood(material)) {
            return SoundType.field_185848_a;
        }
        return SoundType.field_185852_e;
    }

    public int getHarvestLevel(@NotNull IBlockState state) {
        return 1;
    }

    @NotNull
    public Material func_149688_o(@NotNull IBlockState state) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        if (ModHandler.isMaterialWood(material)) {
            return Material.field_151575_d;
        }
        return super.func_149688_o(state);
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean replaceWithFramedPipe(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, ItemStack stackInHand, EnumFacing facing) {
        BlockPipe blockPipe = (BlockPipe)((ItemBlockPipe)stackInHand.func_77973_b()).func_179223_d();
        if (((IPipeType)blockPipe.getItemPipeType(stackInHand)).getThickness() < 1.0f) {
            ItemBlock itemBlock = (ItemBlock)stackInHand.func_77973_b();
            IBlockState pipeState = blockPipe.func_176223_P();
            itemBlock.placeBlockAt(stackInHand, playerIn, worldIn, pos, facing, 0.0f, 0.0f, 0.0f, pipeState);
            IPipeTile pipeTile = blockPipe.getPipeTileEntity((IBlockAccess)worldIn, pos);
            if (!(pipeTile instanceof TileEntityPipeBase)) {
                GTLog.logger.error("Pipe was not placed!");
                return false;
            }
            ((TileEntityPipeBase)pipeTile).setFrameMaterial(this.getGtMaterial(state));
            SoundType type = blockPipe.getSoundType(state, worldIn, pos, (Entity)playerIn);
            worldIn.func_184133_a(playerIn, pos, type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stackInHand.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public boolean removeFrame(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        TileEntityPipeBase pipeTile;
        gregtech.api.unification.material.Material frameMaterial;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPipeBase && (frameMaterial = (pipeTile = (TileEntityPipeBase)te).getFrameMaterial()) != null) {
            pipeTile.setFrameMaterial(null);
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getItem(frameMaterial));
            ToolHelper.damageItem(stack, (EntityLivingBase)player);
            ToolHelper.playToolSound(stack, player);
            return true;
        }
        return false;
    }

    public boolean func_180639_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlockPipe) {
            return this.replaceWithFramedPipe(world, pos, state, player, stack, facing);
        }
        if (stack.func_77973_b().getToolClasses(stack).contains("crowbar")) {
            return this.removeFrame(world, pos, player, stack);
        }
        BlockFrame frameBlock = BlockFrame.getFrameBlockFromItem(stack);
        if (frameBlock == null) {
            return false;
        }
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        blockPos.func_189533_g((Vec3i)pos);
        for (int i = 0; i < 32; ++i) {
            if (world.func_180495_p((BlockPos)blockPos).func_177230_c() instanceof BlockFrame) {
                blockPos.func_189536_c(EnumFacing.UP);
                continue;
            }
            TileEntity te = world.func_175625_s((BlockPos)blockPos);
            if (te instanceof IPipeTile && ((IPipeTile)te).getFrameMaterial() != null) {
                blockPos.func_189536_c(EnumFacing.UP);
                continue;
            }
            if (this.func_176196_c(world, (BlockPos)blockPos)) {
                world.func_175656_a((BlockPos)blockPos, frameBlock.func_176203_a(stack.func_77973_b().func_77647_b(stack.func_77952_i())));
                SoundType type = this.getSoundType(stack);
                world.func_184133_a(null, pos, type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                blockPos.func_185344_t();
                return true;
            }
            if (te instanceof TileEntityPipeBase && ((TileEntityPipeBase)te).getFrameMaterial() == null) {
                ((TileEntityPipeBase)te).setFrameMaterial(frameBlock.getGtMaterial(stack));
                SoundType type = this.getSoundType(stack);
                world.func_184133_a(null, pos, type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                blockPos.func_185344_t();
                return true;
            }
            blockPos.func_185344_t();
            return false;
        }
        blockPos.func_185344_t();
        return false;
    }

    public void func_180634_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, Entity entityIn) {
        entityIn.field_70159_w = MathHelper.func_151237_a((double)entityIn.field_70159_w, (double)-0.15, (double)0.15);
        entityIn.field_70179_y = MathHelper.func_151237_a((double)entityIn.field_70179_y, (double)-0.15, (double)0.15);
        entityIn.field_70143_R = 0.0f;
        if (entityIn.field_70181_x < -0.15) {
            entityIn.field_70181_x = -0.15;
        }
        if (entityIn.func_70093_af() && entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = 0.0;
        }
        if (entityIn.field_70123_F) {
            entityIn.field_70181_x = 0.3;
        }
    }

    @NotNull
    public EnumPushReaction func_149656_h(@NotNull IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public AxisAlignedBB func_180646_a(@NotNull IBlockState blockState, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        return COLLISION_BOX;
    }

    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(@NotNull IBlockState state) {
        return false;
    }

    @NotNull
    public BlockFaceShape func_193383_a(@NotNull IBlockAccess worldIn, @NotNull IBlockState state, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_190948_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        if (ConfigHolder.misc.debug) {
            tooltip.add("MetaItem Id: frame" + this.getGtMaterial(stack).toCamelCaseString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new MaterialStateMapper(MaterialIconType.frameGt, s -> this.getGtMaterial((IBlockState)s).getMaterialIconSet()));
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)this.func_176201_c(state), (ModelResourceLocation)MaterialBlockModelLoader.registerItemModel(MaterialIconType.frameGt, this.getGtMaterial(state).getMaterialIconSet()));
        }
    }

    @Nullable
    public static BlockFrame getFrameBlockFromItem(ItemStack stack) {
        Block block;
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && (block = ((ItemBlock)item).func_179223_d()) instanceof BlockFrame) {
            return (BlockFrame)block;
        }
        return null;
    }
}

