/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.client.model.MaterialStateMapper;
import gregtech.client.model.modelfactories.MaterialBlockModelLoader;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMaterialBase;
import gregtech.common.blocks.properties.PropertyMaterial;
import gregtech.common.creativetab.GTCreativeTabs;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockCompressed
extends BlockMaterialBase {
    public static BlockCompressed create(gregtech.api.unification.material.Material[] materials) {
        final PropertyMaterial property = PropertyMaterial.create("variant", materials);
        return new BlockCompressed(){

            @Override
            @NotNull
            public PropertyMaterial getVariantProperty() {
                return property;
            }
        };
    }

    private BlockCompressed() {
        super(Material.field_151573_f);
        this.func_149663_c("compressed");
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(GTCreativeTabs.TAB_GREGTECH_MATERIALS);
    }

    @NotNull
    public Material func_149688_o(@NotNull IBlockState state) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        if (material.hasProperty(PropertyKey.GEM)) {
            return Material.field_151576_e;
        }
        if (material.hasProperty(PropertyKey.INGOT)) {
            return Material.field_151573_f;
        }
        if (material.hasProperty(PropertyKey.DUST)) {
            return Material.field_151595_p;
        }
        return Material.field_151576_e;
    }

    @NotNull
    public SoundType getSoundType(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @Nullable Entity entity) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        if (material.hasProperty(PropertyKey.GEM)) {
            return SoundType.field_185851_d;
        }
        if (material.hasProperty(PropertyKey.INGOT)) {
            return SoundType.field_185852_e;
        }
        if (material.hasProperty(PropertyKey.DUST)) {
            return SoundType.field_185855_h;
        }
        return SoundType.field_185851_d;
    }

    public String getHarvestTool(@NotNull IBlockState state) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        if (material.isSolid()) {
            return "pickaxe";
        }
        if (material.hasProperty(PropertyKey.DUST)) {
            return "shovel";
        }
        return "pickaxe";
    }

    public int getHarvestLevel(@NotNull IBlockState state) {
        gregtech.api.unification.material.Material material = this.getGtMaterial(state);
        if (material.hasProperty(PropertyKey.DUST)) {
            return material.getBlockHarvestLevel();
        }
        return 0;
    }

    public void func_190948_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        if (ConfigHolder.misc.debug) {
            tooltip.add("MetaItem Id: block" + this.getGtMaterial(stack).toCamelCaseString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new MaterialStateMapper(MaterialIconType.block, s -> this.getGtMaterial((IBlockState)s).getMaterialIconSet()));
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)this.func_176201_c(state), (ModelResourceLocation)MaterialBlockModelLoader.registerItemModel(MaterialIconType.block, this.getGtMaterial(state).getMaterialIconSet()));
        }
    }
}

