/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ItemGTToolbelt;
import gregtech.api.util.GTUtility;
import java.awt.Color;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public final class ToolChargeBarRenderer {
    private static final double BAR_W = 12.0;
    private static final Color colorShadow = new Color(0, 0, 0, 255);
    private static final Color colorBG = new Color(14, 1, 22, 255);
    private static final Color colorBarLeftEnergy = new Color(0, 101, 178, 255);
    private static final Color colorBarRightEnergy = new Color(217, 238, 255, 255);
    private static final Color colorBarLeftDurability = new Color(20, 124, 0, 255);
    private static final Color colorBarRightDurability = new Color(115, 255, 89, 255);
    private static final Color colorBarLeftDepleted = new Color(122, 0, 0, 255);
    private static final Color colorBarRightDepleted = new Color(255, 27, 27, 255);

    public static void render(double level, int xPosition, int yPosition, int offset, boolean shadow, Color left, Color right, boolean doDepletedColor) {
        double width = level * 12.0;
        if (doDepletedColor && level <= 0.25) {
            left = colorBarLeftDepleted;
            right = colorBarRightDepleted;
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        ToolChargeBarRenderer.drawShadow(worldrenderer, xPosition + 2, yPosition + 13 - offset, 13.0, shadow ? 2.0 : 1.0);
        ToolChargeBarRenderer.drawGrad(worldrenderer, xPosition + 2, yPosition + 13 - offset, (12.0 + width) / 2.0, left, right);
        ToolChargeBarRenderer.drawBG(worldrenderer, xPosition + 2 + 12, yPosition + 13 - offset, 12.0 - width);
        if (offset == 2) {
            ToolChargeBarRenderer.overpaintVanillaRenderBug(worldrenderer, xPosition, yPosition);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    private static void drawGrad(BufferBuilder renderer, int x, int y, double width, Color left, Color right) {
        renderer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(left.getRed(), left.getGreen(), left.getBlue(), left.getAlpha()).func_181675_d();
        renderer.func_181662_b((double)x, (double)y + 1.0, 0.0).func_181669_b(left.getRed(), left.getGreen(), left.getBlue(), left.getAlpha()).func_181675_d();
        renderer.func_181662_b((double)x + width, (double)y + 1.0, 0.0).func_181669_b(right.getRed(), right.getGreen(), right.getBlue(), right.getAlpha()).func_181675_d();
        renderer.func_181662_b((double)x + width, (double)y, 0.0).func_181669_b(right.getRed(), right.getGreen(), right.getBlue(), right.getAlpha()).func_181675_d();
    }

    private static void drawShadow(BufferBuilder renderer, int x, int y, double width, double height) {
        renderer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(colorShadow.getRed(), colorShadow.getGreen(), colorShadow.getBlue(), colorShadow.getAlpha()).func_181675_d();
        renderer.func_181662_b((double)x, (double)y + height, 0.0).func_181669_b(colorShadow.getRed(), colorShadow.getGreen(), colorShadow.getBlue(), colorShadow.getAlpha()).func_181675_d();
        renderer.func_181662_b((double)x + width, (double)y + height, 0.0).func_181669_b(colorShadow.getRed(), colorShadow.getGreen(), colorShadow.getBlue(), colorShadow.getAlpha()).func_181675_d();
        renderer.func_181662_b((double)x + width, (double)y, 0.0).func_181669_b(colorShadow.getRed(), colorShadow.getGreen(), colorShadow.getBlue(), colorShadow.getAlpha()).func_181675_d();
    }

    private static void drawBG(BufferBuilder renderer, int x, int y, double width) {
        renderer.func_181662_b((double)x - width, (double)y, 0.0).func_181669_b(colorBG.getRed(), colorBG.getGreen(), colorBG.getBlue(), colorBG.getAlpha()).func_181675_d();
        renderer.func_181662_b((double)x - width, (double)y + 1.0, 0.0).func_181669_b(colorBG.getRed(), colorBG.getGreen(), colorBG.getBlue(), colorBG.getAlpha()).func_181675_d();
        renderer.func_181662_b((double)x, (double)y + 1.0, 0.0).func_181669_b(colorBG.getRed(), colorBG.getGreen(), colorBG.getBlue(), colorBG.getAlpha()).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(colorBG.getRed(), colorBG.getGreen(), colorBG.getBlue(), colorBG.getAlpha()).func_181675_d();
    }

    private static void overpaintVanillaRenderBug(BufferBuilder worldrenderer, int xPosition, int yPosition) {
        ToolChargeBarRenderer.drawShadow(worldrenderer, xPosition + 2 + 12, yPosition + 13, 1.0, 1.0);
    }

    public static void renderBarsTool(IGTTool tool, ItemStack stack, int xPosition, int yPosition) {
        Item item;
        ItemGTToolbelt toolbelt;
        ItemStack selected;
        if (tool instanceof ItemGTToolbelt && !(selected = (toolbelt = (ItemGTToolbelt)tool).getSelectedTool(stack)).func_190926_b() && (item = selected.func_77973_b()) instanceof IGTTool) {
            IGTTool toool;
            tool = toool = (IGTTool)item;
            stack = selected;
        }
        boolean renderedDurability = false;
        NBTTagCompound tag = GTUtility.getOrCreateNbtCompound(stack);
        if (!tag.func_74767_n("Unbreakable")) {
            renderedDurability = ToolChargeBarRenderer.renderDurabilityBar(stack.func_77973_b().getDurabilityForDisplay(stack), xPosition, yPosition);
        }
        if (tool.isElectric()) {
            ToolChargeBarRenderer.renderElectricBar(tool.getCharge(stack), tool.getMaxCharge(stack), xPosition, yPosition, renderedDurability);
        }
    }

    public static void renderBarsItem(MetaItem<?> metaItem, ItemStack stack, int xPosition, int yPosition) {
        IElectricItem electricItem;
        boolean renderedDurability = false;
        Object valueItem = metaItem.getItem(stack);
        if (valueItem != null && ((MetaItem.MetaValueItem)valueItem).getDurabilityManager() != null) {
            renderedDurability = ToolChargeBarRenderer.renderDurabilityBar(stack, ((MetaItem.MetaValueItem)valueItem).getDurabilityManager(), xPosition, yPosition);
        }
        if ((electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null)) != null) {
            ToolChargeBarRenderer.renderElectricBar(electricItem.getCharge(), electricItem.getMaxCharge(), xPosition, yPosition, renderedDurability);
        }
    }

    private static void renderElectricBar(long charge, long maxCharge, int xPosition, int yPosition, boolean renderedDurability) {
        if (charge > 0L && maxCharge > 0L) {
            double level = (double)charge / (double)maxCharge;
            ToolChargeBarRenderer.render(level, xPosition, yPosition, renderedDurability ? 2 : 0, true, colorBarLeftEnergy, colorBarRightEnergy, true);
        }
    }

    private static boolean renderDurabilityBar(ItemStack stack, IItemDurabilityManager manager, int xPosition, int yPosition) {
        double level = manager.getDurabilityForDisplay(stack);
        if (level == 0.0 && !manager.showEmptyBar(stack)) {
            return false;
        }
        if (level == 1.0 && !manager.showFullBar(stack)) {
            return false;
        }
        Pair<Color, Color> colors = manager.getDurabilityColorsForDisplay(stack);
        boolean doDepletedColor = manager.doDamagedStateColors(stack);
        Color left = colors != null ? (Color)colors.getLeft() : colorBarLeftDurability;
        Color right = colors != null ? (Color)colors.getRight() : colorBarRightDurability;
        ToolChargeBarRenderer.render(1.0 - level, xPosition, yPosition, 0, true, left, right, doDepletedColor);
        return true;
    }

    private static boolean renderDurabilityBar(double level, int xPosition, int yPosition) {
        ToolChargeBarRenderer.render(1.0 - level, xPosition, yPosition, 0, true, colorBarLeftDurability, colorBarRightDurability, true);
        return true;
    }

    private ToolChargeBarRenderer() {
    }
}

