/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.shader.postprocessing;

import org.jetbrains.annotations.NotNull;

public enum BloomType {
    GAUSSIAN,
    UNITY,
    UNREAL,
    DISABLED;


    public int getValue() {
        int n;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case GAUSSIAN: {
                n = 0;
                break;
            }
            case UNITY: {
                n = 1;
                break;
            }
            case UNREAL: {
                n = 2;
                break;
            }
            case DISABLED: {
                n = -1;
            }
        }
        return n;
    }

    @NotNull
    public static BloomType fromValue(int value) {
        BloomType bloomType;
        switch (value) {
            case 0: {
                bloomType = GAUSSIAN;
                break;
            }
            case 1: {
                bloomType = UNITY;
                break;
            }
            case 2: {
                bloomType = UNREAL;
                break;
            }
            default: {
                bloomType = DISABLED;
            }
        }
        return bloomType;
    }
}

