/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.custom;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.client.texture.IconRegistrar;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumChest;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumStorage;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class QuantumStorageRenderer
implements IconRegistrar {
    private static final Cuboid6 glassBox = new Cuboid6(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);
    private static final EnumMap<EnumFacing, Cuboid6> boxFacingMap = new EnumMap(EnumFacing.class);
    private static final TextTexture textRenderer = new TextTexture().setWidth(32);
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite glassTexture;

    public QuantumStorageRenderer() {
        Textures.iconRegisters.add(this);
    }

    @Override
    public void registerIcons(@NotNull TextureMap textureMap) {
        this.glassTexture = textureMap.func_174942_a(new ResourceLocation("gregtech:blocks/overlay/machine/overlay_screen_glass"));
    }

    public <T extends MetaTileEntityQuantumStorage<?>> void renderMachine(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, T mte) {
        EnumFacing frontFacing = mte.getFrontFacing();
        int tier = ((ITieredMetaTileEntity)((Object)mte)).getTier();
        Textures.renderFace(renderState, translation, pipeline, frontFacing, glassBox, this.glassTexture, BlockRenderLayer.CUTOUT_MIPPED);
        TextureAtlasSprite hullTexture = Textures.VOLTAGE_CASINGS[tier].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.bySide(EnumFacing.NORTH));
        if (mte.isConnected()) {
            hullTexture = Textures.QUANTUM_CASING.getParticleSprite();
        }
        for (EnumFacing facing : boxFacingMap.keySet()) {
            if (facing == frontFacing) continue;
            Textures.renderFace(renderState, translation, pipeline, facing, boxFacingMap.get(facing), hullTexture, BlockRenderLayer.CUTOUT_MIPPED);
            Textures.renderFace(renderState, translation, pipeline, facing.func_176734_d(), boxFacingMap.get(facing), hullTexture, BlockRenderLayer.CUTOUT_MIPPED);
        }
        if (frontFacing.func_176740_k() == EnumFacing.Axis.Y) {
            return;
        }
        Textures.renderFace(renderState, translation, pipeline, frontFacing, boxFacingMap.get(EnumFacing.DOWN), hullTexture, BlockRenderLayer.CUTOUT_MIPPED);
        Textures.renderFace(renderState, translation, pipeline, frontFacing, boxFacingMap.get(EnumFacing.UP), hullTexture, BlockRenderLayer.CUTOUT_MIPPED);
        EnumFacing facing = frontFacing.func_176735_f();
        Textures.renderFace(renderState, translation, pipeline, frontFacing, boxFacingMap.get(facing), hullTexture, BlockRenderLayer.CUTOUT_MIPPED);
        Textures.renderFace(renderState, translation, pipeline, frontFacing, boxFacingMap.get(facing.func_176734_d()), hullTexture, BlockRenderLayer.CUTOUT_MIPPED);
    }

    public static void renderChestStack(double x, double y, double z, MetaTileEntityQuantumChest machine, ItemStack stack, long count, float partialTicks) {
        if (!ConfigHolder.client.enableFancyChestRender || stack.func_190926_b() || count == 0L) {
            return;
        }
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        World world = machine.getWorld();
        QuantumStorageRenderer.setLightingCorrectly((IBlockAccess)world, machine.getPos());
        EnumFacing frontFacing = machine.getFrontFacing();
        if (QuantumStorageRenderer.canRender(x, y, z, 8.0 * MathHelper.func_151237_a((double)((double)Minecraft.func_71410_x().field_71474_y.field_151451_c / 8.0), (double)1.0, (double)2.5))) {
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            float tick = (float)world.func_72820_D() + partialTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)(tick * (float)Math.PI * 2.0f / 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            itemRenderer.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        QuantumStorageRenderer.renderAmountText(x, y, z, count, frontFacing);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void renderTankFluid(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, FluidTank tank, IBlockAccess world, BlockPos pos, EnumFacing frontFacing) {
        FluidStack stack = tank.getFluid();
        if (stack == null || stack.amount == 0 || !ConfigHolder.client.enableFancyChestRender) {
            return;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return;
        }
        if (world != null) {
            renderState.setBrightness(world, pos);
        }
        Cuboid6 partialFluidBox = new Cuboid6(0.06640625, 0.12890625, 0.06640625, 0.93359375, 0.93359375, 0.93359375);
        double fillFraction = (double)stack.amount / (double)tank.getCapacity();
        boolean gas = fluid.isGaseous(stack);
        if (gas) {
            partialFluidBox.min.y = Math.max(13.9375 - 11.875 * fillFraction, 2.0) / 16.0;
        } else {
            partialFluidBox.max.y = Math.min(11.875 * fillFraction + 2.0625, 14.0) / 16.0;
        }
        renderState.setFluidColour(stack);
        ResourceLocation fluidStill = fluid.getStill(stack);
        TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStill.toString());
        Textures.renderFace(renderState, translation, pipeline, frontFacing, partialFluidBox, fluidStillSprite, BlockRenderLayer.CUTOUT_MIPPED);
        Textures.renderFace(renderState, translation, pipeline, gas ? EnumFacing.DOWN : EnumFacing.UP, partialFluidBox, fluidStillSprite, BlockRenderLayer.CUTOUT_MIPPED);
        GlStateManager.func_179117_G();
        renderState.reset();
    }

    public static boolean canRender(double x, double y, double z, double range) {
        double distance = x * x + y * y + z * z;
        return distance < range * range;
    }

    public static void renderTankAmount(double x, double y, double z, EnumFacing frontFacing, long amount) {
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        QuantumStorageRenderer.renderAmountText(x, y, z, amount, frontFacing);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void renderAmountText(double x, double y, double z, long amount, EnumFacing frontFacing) {
        if (!ConfigHolder.client.enableFancyChestRender || !QuantumStorageRenderer.canRender(x, y, z, 64.0)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179109_b((float)((float)(frontFacing.func_82601_c() * -1) / 16.0f), (float)((float)(frontFacing.func_96559_d() * -1) / 16.0f), (float)((float)(frontFacing.func_82599_e() * -1) / 16.0f));
        RenderUtil.moveToFace(0.0, 0.0, 0.0, frontFacing);
        if (frontFacing.func_176740_k() == EnumFacing.Axis.Y) {
            RenderUtil.rotateToFace(frontFacing, EnumFacing.SOUTH);
        } else {
            RenderUtil.rotateToFace(frontFacing, null);
        }
        String amountText = TextFormattingUtil.formatLongToCompactString(amount, 4);
        GlStateManager.func_179152_a((float)0.015625f, (float)0.015625f, (float)0.0f);
        GlStateManager.func_179109_b((float)-32.0f, (float)-32.0f, (float)0.0f);
        GlStateManager.func_179140_f();
        textRenderer.setText(amountText);
        textRenderer.draw(0.0, 24.0, 64, 28);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static void setLightingCorrectly(IBlockAccess world, BlockPos pos) {
        int actualLight = world.func_175626_b(pos, 0);
        float lightmapXCoord = actualLight & 0xFFFF;
        float lightmapYCoord = actualLight >> 16;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapXCoord, (float)lightmapYCoord);
    }

    static {
        boxFacingMap.put(EnumFacing.UP, new Cuboid6(0.0, 0.875, 0.0, 1.0, 1.0, 1.0));
        boxFacingMap.put(EnumFacing.DOWN, new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.125, 1.0));
        boxFacingMap.put(EnumFacing.WEST, new Cuboid6(0.0, 0.0, 0.0, 0.125, 1.0, 1.0));
        boxFacingMap.put(EnumFacing.EAST, new Cuboid6(0.875, 0.0, 0.0, 1.0, 1.0, 1.0));
        boxFacingMap.put(EnumFacing.SOUTH, new Cuboid6(0.0, 0.0, 0.875, 1.0, 1.0, 1.0));
        boxFacingMap.put(EnumFacing.NORTH, new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 0.125));
    }
}

