/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.custom;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.texture.IconRegistrar;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class DrumRenderer
implements IconRegistrar {
    private final String basePath;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] textures;

    public DrumRenderer(String basePath) {
        this.basePath = basePath;
        Textures.iconRegisters.add(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(@NotNull TextureMap textureMap) {
        String formattedBase = "gregtech:blocks/" + this.basePath;
        this.textures = new TextureAtlasSprite[3];
        this.textures[0] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/top"));
        this.textures[1] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/side"));
        this.textures[2] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/bottom"));
    }

    @SideOnly(value=Side.CLIENT)
    public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing rotation) {
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            TextureAtlasSprite baseSprite = renderSide == EnumFacing.UP ? this.textures[0] : (renderSide == EnumFacing.DOWN ? this.textures[2] : this.textures[1]);
            Textures.renderFace(renderState, translation, pipeline, renderSide, Cuboid6.full, baseSprite, BlockRenderLayer.CUTOUT_MIPPED);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.textures[0];
    }
}

