/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.cube;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.resources.ResourceHelper;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class SimpleOrientedCubeRenderer
implements ICubeRenderer {
    private final String basePath;
    @SideOnly(value=Side.CLIENT)
    private Map<CubeSide, TextureAtlasSprite> sprites;
    @SideOnly(value=Side.CLIENT)
    private Map<CubeSide, TextureAtlasSprite> spritesEmissive;

    public SimpleOrientedCubeRenderer(String basePath) {
        this.basePath = basePath;
        Textures.CUBE_RENDERER_REGISTRY.put(basePath, this);
        Textures.iconRegisters.add(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        String modID = "gregtech";
        String basePath = this.basePath;
        String[] split = this.basePath.split(":");
        if (split.length == 2) {
            modID = split[0];
            basePath = split[1];
        }
        this.sprites = new EnumMap<CubeSide, TextureAtlasSprite>(CubeSide.class);
        this.spritesEmissive = new EnumMap<CubeSide, TextureAtlasSprite>(CubeSide.class);
        for (CubeSide cubeSide : CubeSide.VALUES) {
            String fullPath = String.format("blocks/%s/%s", basePath, cubeSide.name().toLowerCase());
            this.sprites.put(cubeSide, textureMap.func_174942_a(new ResourceLocation(modID, fullPath)));
            String emissive = fullPath + "_emissive";
            if (!ResourceHelper.doResourcepacksHaveTexture(modID, emissive, true)) continue;
            this.spritesEmissive.put(cubeSide, textureMap.func_174942_a(new ResourceLocation(modID, emissive)));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite() {
        return this.sprites.get((Object)CubeSide.FRONT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing frontFacing, boolean isActive, boolean isWorkingEnabled) {
        IVertexOperation[] lightPipeline = ConfigHolder.client.machinesEmissiveTextures ? (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new LightMapOperation(240, 240)) : pipeline;
        Textures.renderFace(renderState, translation, pipeline, frontFacing, bounds, this.sprites.get((Object)CubeSide.FRONT), BlockRenderLayer.CUTOUT_MIPPED);
        if (this.spritesEmissive.containsKey((Object)CubeSide.FRONT)) {
            Textures.renderFace(renderState, translation, lightPipeline, frontFacing, bounds, this.sprites.get((Object)CubeSide.FRONT), BloomEffectUtil.getEffectiveBloomLayer());
        }
        Textures.renderFace(renderState, translation, pipeline, frontFacing.func_176734_d(), bounds, this.sprites.get((Object)CubeSide.BACK), BlockRenderLayer.CUTOUT_MIPPED);
        if (this.spritesEmissive.containsKey((Object)CubeSide.BACK)) {
            Textures.renderFace(renderState, translation, lightPipeline, frontFacing.func_176734_d(), bounds, this.sprites.get((Object)CubeSide.BACK), BloomEffectUtil.getEffectiveBloomLayer());
        }
        EnumFacing left = frontFacing.func_176740_k() != EnumFacing.Axis.Y ? frontFacing.func_176735_f() : EnumFacing.NORTH;
        Textures.renderFace(renderState, translation, pipeline, left, bounds, this.sprites.get((Object)CubeSide.LEFT), BlockRenderLayer.CUTOUT_MIPPED);
        if (this.spritesEmissive.containsKey((Object)CubeSide.LEFT)) {
            Textures.renderFace(renderState, translation, lightPipeline, left, bounds, this.sprites.get((Object)CubeSide.LEFT), BloomEffectUtil.getEffectiveBloomLayer());
        }
        Textures.renderFace(renderState, translation, pipeline, left.func_176734_d(), bounds, this.sprites.get((Object)CubeSide.RIGHT), BlockRenderLayer.CUTOUT_MIPPED);
        if (this.spritesEmissive.containsKey((Object)CubeSide.RIGHT)) {
            Textures.renderFace(renderState, translation, lightPipeline, left.func_176734_d(), bounds, this.sprites.get((Object)CubeSide.RIGHT), BloomEffectUtil.getEffectiveBloomLayer());
        }
        EnumFacing up = frontFacing.func_176740_k() != EnumFacing.Axis.Y ? EnumFacing.UP : EnumFacing.WEST;
        Textures.renderFace(renderState, translation, pipeline, up, bounds, this.sprites.get((Object)CubeSide.TOP), BlockRenderLayer.CUTOUT_MIPPED);
        if (this.spritesEmissive.containsKey((Object)CubeSide.TOP)) {
            Textures.renderFace(renderState, translation, lightPipeline, up, bounds, this.sprites.get((Object)CubeSide.TOP), BloomEffectUtil.getEffectiveBloomLayer());
        }
        Textures.renderFace(renderState, translation, pipeline, up.func_176734_d(), bounds, this.sprites.get((Object)CubeSide.BOTTOM), BlockRenderLayer.CUTOUT_MIPPED);
        if (this.spritesEmissive.containsKey((Object)CubeSide.BOTTOM)) {
            Textures.renderFace(renderState, translation, lightPipeline, up.func_176734_d(), bounds, this.sprites.get((Object)CubeSide.BOTTOM), BloomEffectUtil.getEffectiveBloomLayer());
        }
    }

    private static enum CubeSide {
        FRONT,
        BACK,
        RIGHT,
        LEFT,
        TOP,
        BOTTOM;

        public static final CubeSide[] VALUES;

        static {
            VALUES = CubeSide.values();
        }
    }
}

