/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.scene;

import codechicken.lib.vec.Vector3;
import gregtech.api.util.Position;
import gregtech.api.util.PositionedRect;
import gregtech.api.util.Size;
import gregtech.client.utils.RenderUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.function.Consumer;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

@SideOnly(value=Side.CLIENT)
public abstract class WorldSceneRenderer {
    protected static final FloatBuffer MODELVIEW_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer PROJECTION_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final IntBuffer VIEWPORT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    protected static final FloatBuffer PIXEL_DEPTH_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer OBJECT_POS_BUFFER = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
    public final World world;
    public final Collection<BlockPos> renderedBlocks = new ObjectOpenHashSet();
    private Consumer<WorldSceneRenderer> beforeRender;
    private Consumer<WorldSceneRenderer> afterRender;
    private Consumer<RayTraceResult> onLookingAt;
    private int clearColor;
    private RayTraceResult lastTraceResult;
    private Vector3f eyePos = new Vector3f(0.0f, 0.0f, 10.0f);
    private Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);

    public WorldSceneRenderer(World world) {
        this.world = world;
    }

    public WorldSceneRenderer setBeforeWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.beforeRender = callback;
        return this;
    }

    public WorldSceneRenderer setAfterWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.afterRender = callback;
        return this;
    }

    public WorldSceneRenderer addRenderedBlocks(@Nullable Collection<BlockPos> blocks) {
        if (blocks != null) {
            this.renderedBlocks.addAll(blocks);
        }
        return this;
    }

    public WorldSceneRenderer setOnLookingAt(Consumer<RayTraceResult> onLookingAt) {
        this.onLookingAt = onLookingAt;
        return this;
    }

    public void setClearColor(int clearColor) {
        this.clearColor = clearColor;
    }

    public RayTraceResult getLastTraceResult() {
        return this.lastTraceResult;
    }

    public void render(float x, float y, float width, float height, int mouseX, int mouseY) {
        Vector3f hitPos;
        RayTraceResult result;
        PositionedRect positionedRect = this.getPositionedRect((int)x, (int)y, (int)width, (int)height);
        PositionedRect mouse = this.getPositionedRect(mouseX, mouseY, 0, 0);
        mouseX = mouse.position.x;
        mouseY = mouse.position.y;
        this.setupCamera(positionedRect);
        this.drawWorld();
        this.lastTraceResult = null;
        if (this.onLookingAt != null && mouseX > positionedRect.position.x && mouseX < positionedRect.position.x + positionedRect.size.width && mouseY > positionedRect.position.y && mouseY < positionedRect.position.y + positionedRect.size.height && (result = this.rayTrace(hitPos = WorldSceneRenderer.unProject(mouseX, mouseY))) != null) {
            this.lastTraceResult = null;
            this.lastTraceResult = result;
            this.onLookingAt.accept(result);
        }
        WorldSceneRenderer.resetCamera();
    }

    public Vector3f getEyePos() {
        return this.eyePos;
    }

    public Vector3f getLookAt() {
        return this.lookAt;
    }

    public Vector3f getWorldUp() {
        return this.worldUp;
    }

    public void setCameraLookAt(Vector3f eyePos, Vector3f lookAt, Vector3f worldUp) {
        this.eyePos = eyePos;
        this.lookAt = lookAt;
        this.worldUp = worldUp;
    }

    public void setCameraLookAt(Vector3f lookAt, double radius, double rotationPitch, double rotationYaw) {
        this.lookAt = lookAt;
        Vector3 vecX = new Vector3(Math.cos(rotationPitch), 0.0, Math.sin(rotationPitch));
        Vector3 vecY = new Vector3(0.0, Math.tan(rotationYaw) * vecX.mag(), 0.0);
        Vector3 pos = vecX.copy().add(vecY).normalize().multiply(radius);
        this.eyePos = pos.add((double)lookAt.x, (double)lookAt.y, (double)lookAt.z).vector3f();
    }

    protected PositionedRect getPositionedRect(int x, int y, int width, int height) {
        return new PositionedRect(new Position(x, y), new Size(width, height));
    }

    protected void setupCamera(PositionedRect positionedRect) {
        int x = positionedRect.getPosition().x;
        int y = positionedRect.getPosition().y;
        int width = positionedRect.getSize().width;
        int height = positionedRect.getSize().height;
        GlStateManager.func_179123_a();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179083_b((int)x, (int)y, (int)width, (int)height);
        this.clearView(x, y, width, height);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        GLU.gluPerspective((float)60.0f, (float)aspectRatio, (float)0.1f, (float)10000.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GLU.gluLookAt((float)this.eyePos.x, (float)this.eyePos.y, (float)this.eyePos.z, (float)this.lookAt.x, (float)this.lookAt.y, (float)this.lookAt.z, (float)this.worldUp.x, (float)this.worldUp.y, (float)this.worldUp.z);
    }

    protected void clearView(int x, int y, int width, int height) {
        RenderUtil.setGlClearColorFromInt(this.clearColor, this.clearColor >> 24);
        GlStateManager.func_179086_m((int)16640);
    }

    protected static void resetCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GlStateManager.func_179083_b((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
        GlStateManager.func_179099_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawWorld() {
        if (this.beforeRender != null) {
            this.beforeRender.accept(this);
        }
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_175072_h();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        try {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
                WorldSceneRenderer.setDefaultPassRenderState(pass);
                BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                BlockRendererDispatcher blockrendererdispatcher = mc.func_175602_ab();
                for (BlockPos pos : this.renderedBlocks) {
                    IBlockState state = this.world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150350_a || !block.canRenderInLayer(state = state.func_185899_b((IBlockAccess)this.world, pos), layer)) continue;
                    blockrendererdispatcher.func_175018_a(state, pos, (IBlockAccess)this.world, buffer);
                }
                Tessellator.func_178181_a().func_78381_a();
                Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        for (int pass = 0; pass < 2; ++pass) {
            ForgeHooksClient.setRenderPass((int)pass);
            WorldSceneRenderer.setDefaultPassRenderState(pass);
            for (BlockPos pos : this.renderedBlocks) {
                TileEntity tile = this.world.func_175625_s(pos);
                if (tile == null || !tile.shouldRenderInPass(pass)) continue;
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f);
            }
        }
        ForgeHooksClient.setRenderPass((int)-1);
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        if (this.afterRender != null) {
            this.afterRender.accept(this);
        }
    }

    public static void setDefaultPassRenderState(int pass) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass == 0) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179132_a((boolean)false);
        }
    }

    public RayTraceResult rayTrace(Vector3f hitPos) {
        Vec3d startPos = new Vec3d((double)this.eyePos.x, (double)this.eyePos.y, (double)this.eyePos.z);
        hitPos.scale(2.0f);
        Vec3d endPos = new Vec3d((double)hitPos.x - startPos.field_72450_a, (double)hitPos.y - startPos.field_72448_b, (double)hitPos.z - startPos.field_72449_c);
        return this.world.func_72933_a(startPos, endPos);
    }

    public static Vector3f project(BlockPos pos) {
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluProject((float)((float)pos.func_177958_n() + 0.5f), (float)((float)pos.func_177956_o() + 0.5f), (float)((float)pos.func_177952_p() + 0.5f), (FloatBuffer)MODELVIEW_MATRIX_BUFFER, (FloatBuffer)PROJECTION_MATRIX_BUFFER, (IntBuffer)VIEWPORT_BUFFER, (FloatBuffer)OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float winX = OBJECT_POS_BUFFER.get();
        float winY = OBJECT_POS_BUFFER.get();
        float winZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(winX, winY, winZ);
    }

    public static Vector3f unProject(int mouseX, int mouseY) {
        GL11.glReadPixels((int)mouseX, (int)mouseY, (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)PIXEL_DEPTH_BUFFER);
        PIXEL_DEPTH_BUFFER.rewind();
        float pixelDepth = PIXEL_DEPTH_BUFFER.get();
        PIXEL_DEPTH_BUFFER.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluUnProject((float)mouseX, (float)mouseY, (float)pixelDepth, (FloatBuffer)MODELVIEW_MATRIX_BUFFER, (FloatBuffer)PROJECTION_MATRIX_BUFFER, (IntBuffer)VIEWPORT_BUFFER, (FloatBuffer)OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float posX = OBJECT_POS_BUFFER.get();
        float posY = OBJECT_POS_BUFFER.get();
        float posZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(posX, posY, posZ);
    }

    protected RayTraceResult screenPos2BlockPosFace(int mouseX, int mouseY, int x, int y, int width, int height) {
        GlStateManager.func_179126_j();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f hitPos = WorldSceneRenderer.unProject(mouseX, mouseY);
        RayTraceResult result = this.rayTrace(hitPos);
        WorldSceneRenderer.resetCamera();
        return result;
    }

    protected Vector3f blockPos2ScreenPos(BlockPos pos, boolean depth, int x, int y, int width, int height) {
        GlStateManager.func_179126_j();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f winPos = WorldSceneRenderer.project(pos);
        WorldSceneRenderer.resetCamera();
        return winPos;
    }
}

