/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.resources.ResourceHelper;
import gregtech.client.texture.IconRegistrar;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICubeRenderer
extends IconRegistrar {
    public static final String EMISSIVE = "_emissive";

    @SideOnly(value=Side.CLIENT)
    default public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        this.render(renderState, translation, pipeline, Cuboid6.full);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite();

    @SideOnly(value=Side.CLIENT)
    default public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds) {
        for (EnumFacing side : EnumFacing.values()) {
            this.renderSided(side, bounds, renderState, pipeline, translation);
        }
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderSided(EnumFacing side, CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        this.renderSided(side, Cuboid6.full, renderState, pipeline, translation);
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderSided(EnumFacing side, Cuboid6 bounds, CCRenderState renderState, IVertexOperation[] pipeline, Matrix4 translation) {
        this.renderOrientedState(renderState, translation, pipeline, bounds, side, false, false);
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderOriented(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing frontFacing) {
        this.renderOrientedState(renderState, translation, pipeline, bounds, frontFacing, false, false);
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderOriented(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing frontFacing) {
        this.renderOriented(renderState, translation, pipeline, Cuboid6.full, frontFacing);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOrientedState(CCRenderState var1, Matrix4 var2, IVertexOperation[] var3, Cuboid6 var4, EnumFacing var5, boolean var6, boolean var7);

    @SideOnly(value=Side.CLIENT)
    default public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing frontFacing, boolean isActive, boolean isWorkingEnabled) {
        this.renderOrientedState(renderState, translation, pipeline, Cuboid6.full, frontFacing, isActive, isWorkingEnabled);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public static TextureAtlasSprite getResource(@NotNull TextureMap textureMap, @NotNull String modid, @NotNull String name) {
        if (ResourceHelper.doResourcepacksHaveTexture(modid, name, true)) {
            return textureMap.func_174942_a(new ResourceLocation(modid, name));
        }
        return null;
    }
}

