/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import gregtech.client.renderer.IRenderSetup;
import gregtech.client.utils.EffectRenderContext;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public abstract class GTParticle {
    public double posX;
    public double posY;
    public double posZ;
    private double renderRange = -1.0;
    private double squaredRenderRange = -1.0;
    private boolean expired;

    protected GTParticle(double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public boolean shouldRender(@NotNull EffectRenderContext context) {
        if (this.squaredRenderRange < 0.0) {
            return true;
        }
        return context.renderViewEntity().func_174824_e(context.partialTicks()).func_186679_c(this.posX, this.posY, this.posZ) <= this.squaredRenderRange;
    }

    public final boolean isAlive() {
        return !this.expired;
    }

    public final boolean isExpired() {
        return this.expired;
    }

    public final void setExpired() {
        if (this.expired) {
            return;
        }
        this.expired = true;
        this.onExpired();
    }

    public boolean shouldDisableDepth() {
        return false;
    }

    public final double getRenderRange() {
        return this.renderRange;
    }

    public final double getSquaredRenderRange() {
        return this.squaredRenderRange;
    }

    public final void setRenderRange(double renderRange) {
        this.renderRange = renderRange;
        this.squaredRenderRange = renderRange >= 0.0 ? renderRange * renderRange : -1.0;
    }

    public void onUpdate() {
    }

    protected void onExpired() {
    }

    public void renderParticle(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context) {
    }

    @Nullable
    public IRenderSetup getRenderSetup() {
        return null;
    }
}

