/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.modelfactories;

import gregtech.client.utils.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BakedModelHandler {
    private static final StateMapperBase SIMPLE_STATE_MAPPER = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return BakedModelHandler.getSimpleModelLocation(state.func_177230_c());
        }
    };
    private final List<BlockFluidBase> fluidBlocks = new ArrayList<BlockFluidBase>();

    private static ModelResourceLocation getSimpleModelLocation(Block block) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block), "");
    }

    public void addFluidBlock(BlockFluidBase fluidBase) {
        this.fluidBlocks.add(fluidBase);
        ModelLoader.setCustomStateMapper((Block)fluidBase, (IStateMapper)SIMPLE_STATE_MAPPER);
    }

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        for (BlockFluidBase fluidBlock : this.fluidBlocks) {
            Fluid fluid = (Fluid)ObfuscationReflectionHelper.getPrivateValue(BlockFluidBase.class, (Object)fluidBlock, (String)"definedFluid");
            ModelFluid modelFluid = new ModelFluid(fluid);
            IBakedModel bakedModel = modelFluid.bake(modelFluid.getDefaultState(), DefaultVertexFormats.field_176599_b, RenderUtil::getTexture);
            ModelResourceLocation resourceLocation = BakedModelHandler.getSimpleModelLocation((Block)fluidBlock);
            event.getModelRegistry().func_82595_a((Object)resourceLocation, (Object)bakedModel);
        }
    }
}

