/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import gregtech.api.fluids.GTFluidRegistration;
import gregtech.api.items.metaitem.MetaOreDictItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ItemGTToolbelt;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.GTLog;
import gregtech.api.util.IBlockOre;
import gregtech.api.util.Mods;
import gregtech.api.util.input.KeyBind;
import gregtech.client.model.customtexture.CustomTextureModelHandler;
import gregtech.client.model.customtexture.MetadataSectionCTM;
import gregtech.client.renderer.handler.FacadeRenderer;
import gregtech.client.renderer.handler.MetaTileEntityRenderer;
import gregtech.client.renderer.pipe.CableRenderer;
import gregtech.client.renderer.pipe.FluidPipeRenderer;
import gregtech.client.renderer.pipe.ItemPipeRenderer;
import gregtech.client.renderer.pipe.LaserPipeRenderer;
import gregtech.client.renderer.pipe.OpticalPipeRenderer;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.ItemRenderCompat;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.CommonProxy;
import gregtech.common.ConfigHolder;
import gregtech.common.MetaEntities;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final String[] clearRecipes = new String[]{"quantum_tank", "quantum_chest", "super_chest", "super_tank", "drum.", "_tank", "fluid_cell"};

    @Override
    public void onPreLoad() {
        super.onPreLoad();
        SoundSystemConfig.setNumberNormalChannels((int)ConfigHolder.client.maxNumSounds);
        if (!Mods.CTM.isModLoaded()) {
            Minecraft.func_71410_x().field_110452_an.func_110504_a((IMetadataSectionSerializer)new MetadataSectionCTM.Serializer(), MetadataSectionCTM.class);
            MinecraftForge.EVENT_BUS.register((Object)CustomTextureModelHandler.INSTANCE);
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)CustomTextureModelHandler.INSTANCE);
        }
        MetaTileEntityRenderer.preInit();
        CableRenderer.INSTANCE.preInit();
        FluidPipeRenderer.INSTANCE.preInit();
        ItemPipeRenderer.INSTANCE.preInit();
        OpticalPipeRenderer.INSTANCE.preInit();
        LaserPipeRenderer.INSTANCE.preInit();
        MetaEntities.initRenderers();
        MinecraftForge.EVENT_BUS.register(KeyBind.class);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        ClientProxy.registerColors();
    }

    @Override
    public void onPostLoad() {
        super.onPostLoad();
        ItemRenderCompat.init();
        FacadeRenderer.init();
    }

    public static void registerColors() {
        MetaBlocks.registerColors();
        MetaItems.registerColors();
        ToolItems.registerColors();
    }

    @SubscribeEvent
    public static void textureStitchPre(@NotNull TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        GTFluidRegistration.INSTANCE.registerSprites(map);
        Textures.register(map);
        PipeRenderer.initializeRestrictor(map);
        CableRenderer.INSTANCE.registerIcons(map);
        FluidPipeRenderer.INSTANCE.registerIcons(map);
        ItemPipeRenderer.INSTANCE.registerIcons(map);
        OpticalPipeRenderer.INSTANCE.registerIcons(map);
        LaserPipeRenderer.INSTANCE.registerIcons(map);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        MetaBlocks.registerStateMappers();
        MetaBlocks.registerItemModels();
        MetaItems.registerModels();
        ToolItems.registerModels();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerBakedModels(ModelBakeEvent event) {
        GTLog.logger.info("Registering special item models");
        MetaItems.registerBakedModels(event);
        ToolItems.registerBakedModels(event);
    }

    @SubscribeEvent
    public static void addMaterialFormulaHandler(@NotNull ItemTooltipEvent event) {
        Block block;
        ItemStack itemStack = event.getItemStack();
        if (!(!(itemStack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d()) instanceof BlockFrame || block instanceof BlockCompressed || block instanceof IBlockOre || block instanceof IFluidBlock)) {
            return;
        }
        List<Object> tooltips = new ArrayList();
        UnificationEntry unificationEntry = OreDictUnifier.getUnificationEntry(itemStack);
        if (itemStack.func_77973_b() instanceof MetaOreDictItem) {
            MetaOreDictItem oreDictItem = (MetaOreDictItem)itemStack.func_77973_b();
            Optional optional = OreDictUnifier.getOreDictionaryNames(itemStack).stream().findFirst();
            if (optional.isPresent() && oreDictItem.OREDICT_TO_FORMULA.containsKey(optional.get()) && !oreDictItem.OREDICT_TO_FORMULA.get(optional.get()).isEmpty()) {
                tooltips.add(TextFormatting.YELLOW + oreDictItem.OREDICT_TO_FORMULA.get(optional.get()));
            }
        } else if (unificationEntry != null && unificationEntry.material != null) {
            if (unificationEntry.material.getChemicalFormula() != null && !unificationEntry.material.getChemicalFormula().isEmpty()) {
                tooltips.add(TextFormatting.YELLOW + unificationEntry.material.getChemicalFormula());
            }
        } else if (itemStack.func_77942_o()) {
            NBTTagCompound compound;
            tooltips = FluidTooltipUtil.getFluidTooltip(itemStack.func_77978_p().func_74779_i("FluidName"));
            if ((tooltips == null || tooltips.size() == 0) && (compound = itemStack.func_77978_p()) != null && compound.func_150297_b("Fluid", 10)) {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Fluid"));
                tooltips = FluidTooltipUtil.getFluidTooltip(fluidStack);
            }
        } else if (itemStack.func_77973_b().equals(Items.field_151131_as)) {
            tooltips = FluidTooltipUtil.getFluidTooltip(Materials.Water.getFluid());
        } else if (itemStack.func_77973_b().equals(Items.field_151129_at)) {
            tooltips = FluidTooltipUtil.getFluidTooltip(Materials.Lava.getFluid());
        }
        if (tooltips != null) {
            for (String string : tooltips) {
                if (string == null || string.isEmpty()) continue;
                event.getToolTip().add(string);
            }
        }
    }

    @SubscribeEvent
    public static void addNBTClearingTooltip(ItemTooltipEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player != null) {
            ItemStack stackResult;
            InventoryCrafting inv = null;
            InventoryCraftResult result = null;
            if (player.field_71070_bA instanceof ContainerWorkbench) {
                inv = ((ContainerWorkbench)player.field_71070_bA).field_75162_e;
                result = ((ContainerWorkbench)player.field_71070_bA).field_75160_f;
            } else if (player.field_71070_bA instanceof ContainerPlayer) {
                inv = ((ContainerPlayer)player.field_71070_bA).field_75181_e;
                result = ((ContainerPlayer)player.field_71070_bA).field_75179_f;
            }
            if (inv != null && (stackResult = result.func_70301_a(0)) == event.getItemStack() && !stackResult.func_190926_b() && ItemStack.func_179545_c((ItemStack)stackResult, (ItemStack)event.getItemStack())) {
                String unlocalizedName = stackResult.func_77977_a();
                String namespace = stackResult.func_77973_b().getRegistryName().func_110624_b();
                for (String key : clearRecipes) {
                    if (!unlocalizedName.contains(key) || !namespace.equals("gregtech")) continue;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack craftStack = inv.func_70301_a(i);
                        if (craftStack.func_190926_b() || craftStack.func_77969_a(stackResult) && craftStack.func_77942_o()) continue;
                        return;
                    }
                    event.getToolTip().add(I18n.func_135052_a((String)"gregtech.universal.clear_nbt_recipe.tooltip", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void cleanupDebugTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        boolean isAdvanced = event.getFlags().func_194127_a();
        List tooltip = event.getToolTip();
        if (isAdvanced) {
            if (stack.func_77973_b() instanceof IGTTool) {
                tooltip.remove(I18n.func_135052_a((String)"item.durability", (Object[])new Object[]{stack.func_77958_k() - stack.func_77952_i(), stack.func_77958_k()}));
                tooltip.remove(net.minecraft.util.text.translation.I18n.func_74838_a((String)"endercore.tooltip.durability") + " " + (stack.func_77958_k() - stack.func_77952_i()) + "/" + stack.func_77958_k());
            }
            String nbtTags = null;
            String registryName = null;
            if (stack.func_77978_p() != null) {
                nbtTags = TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"item.nbt_tags", (Object[])new Object[]{stack.func_77978_p().func_150296_c().size()});
                tooltip.remove(nbtTags);
            }
            if (stack.func_77973_b().getRegistryName() != null) {
                registryName = TextFormatting.DARK_GRAY + stack.func_77973_b().getRegistryName().toString();
                tooltip.remove(registryName);
                tooltip.remove(stack.func_77973_b().getRegistryName().toString());
            }
            if (ClientProxy.hasActuallyAdvancedInfo(tooltip)) {
                int[] oreIds;
                if (TooltipHelper.isShiftDown() && (oreIds = OreDictionary.getOreIDs((ItemStack)event.getItemStack())).length > 0) {
                    tooltip.remove(net.minecraft.util.text.translation.I18n.func_74838_a((String)"endercore.tooltip.oreDictNames"));
                    for (int i : oreIds) {
                        tooltip.remove("  - " + OreDictionary.getOreName((int)i));
                    }
                }
            } else {
                if (nbtTags != null) {
                    tooltip.add(nbtTags);
                }
                if (registryName != null) {
                    tooltip.add(registryName);
                }
            }
        }
    }

    private static boolean hasActuallyAdvancedInfo(List<String> tooltip) {
        if (tooltip.contains(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.actuallyadditions.extraInfo.desc", (Object[])new Object[0]) + ":")) {
            return true;
        }
        if (tooltip.contains(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.actuallyadditions.ctrlForMoreInfo.desc", (Object[])new Object[0]))) {
            return true;
        }
        if (tooltip.contains(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + "Advanced Info:")) {
            return true;
        }
        return tooltip.contains(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + "Press CTRL for Advanced Info");
    }

    @Override
    public boolean isFancyGraphics() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onMouseEvent(@NotNull MouseEvent event) {
        ItemStack stack;
        Item item;
        if (!ConfigHolder.client.toolbeltConfig.enableToolbeltScrollingCapture) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getDwheel() != 0 && player.func_70093_af() && (item = (stack = player.func_184614_ca()).func_77973_b()) instanceof ItemGTToolbelt) {
            ItemGTToolbelt toolbelt = (ItemGTToolbelt)item;
            stack = stack.func_77946_l();
            toolbelt.changeSelectedToolMousewheel(event.getDwheel(), stack);
            InventoryPlayer inv = Minecraft.func_71410_x().field_71439_g.field_71071_by;
            inv.field_70462_a.set(inv.field_70461_c, (Object)stack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayPostEvent(RenderGameOverlayEvent.Post event) {
        GuiIngame guiIngame;
        if (!ConfigHolder.client.toolbeltConfig.enableToolbeltHotbarDisplay) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR && (guiIngame = Minecraft.func_71410_x().field_71456_v) instanceof GuiIngameForge) {
            GuiIngameForge gui = (GuiIngameForge)guiIngame;
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
            Item item = stack.func_77973_b();
            if (item instanceof ItemGTToolbelt) {
                ItemGTToolbelt toolbelt = (ItemGTToolbelt)item;
                ClientProxy.renderToolbeltHotbar(gui, stack, toolbelt, event.getResolution(), event.getPartialTicks());
            }
        }
    }

    private static void renderToolbeltHotbar(GuiIngameForge gui, ItemStack stack, ItemGTToolbelt toolbelt, ScaledResolution sr, float partialTicks) {
        Entity entity;
        Minecraft mc = Minecraft.func_71410_x();
        int offset = 31;
        int slots = Math.min(9, toolbelt.getSlotCount(stack));
        GuiIngameForge.left_height += offset - 6;
        if (slots > 4) {
            GuiIngameForge.right_height += offset - 6;
        }
        if ((entity = mc.func_175606_aa()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(GuiIngame.field_110330_c);
            int i = sr.func_78326_a() / 2;
            float f = gui.field_73735_i;
            gui.field_73735_i = -90.0f;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            gui.func_73729_b(i - 91, sr.func_78328_b() - 22 - offset, 0, 0, slots * 20 - 18, 22);
            gui.func_73729_b(i - 91 + slots * 20 - 18, sr.func_78328_b() - 22 - offset, 162, 0, 20, 22);
            int selected = toolbelt.getSelectedSlot(stack);
            if (selected != -1) {
                gui.func_73729_b(i - 91 - 1 + selected * 20, sr.func_78328_b() - 22 - 1 - offset, 0, 22, 24, 24);
            }
            gui.field_73735_i = -80.0f;
            GlStateManager.func_179091_B();
            RenderHelper.func_74520_c();
            for (int l = 0; l < slots; ++l) {
                ItemStack stack1 = toolbelt.getToolInSlot(stack, l);
                if (stack1.func_190926_b()) continue;
                int i1 = i - 90 + l * 20 + 2;
                int j1 = sr.func_78328_b() - 16 - 3 - offset;
                gui.func_184044_a(i1, j1, partialTicks, entityplayer, stack1);
            }
            gui.field_73735_i = f;
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
        }
    }
}

