/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.shape;

import com.google.gson.JsonObject;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.api.worldgen.shape.IBlockGeneratorAccess;
import gregtech.api.worldgen.shape.ShapeGenerator;
import java.util.Random;
import net.minecraft.util.math.Vec3i;

public class SphereGenerator
extends ShapeGenerator {
    private int radiusMin;
    private int radiusMax;

    public SphereGenerator() {
    }

    public SphereGenerator(int radiusMin, int radiusMax) {
        this.radiusMin = radiusMin;
        this.radiusMax = radiusMax;
    }

    @Override
    public void loadFromConfig(JsonObject object) {
        int[] data = OreConfigUtils.getIntRange(object.get("radius"));
        this.radiusMin = data[0];
        this.radiusMax = data[1];
    }

    @Override
    public Vec3i getMaxSize() {
        return new Vec3i(this.radiusMax * 2, this.radiusMax * 2, this.radiusMax * 2);
    }

    @Override
    public void generate(Random gridRandom, IBlockGeneratorAccess relativeBlockAccess) {
        int sphereRadius = this.radiusMin >= this.radiusMax ? this.radiusMin : this.radiusMin + gridRandom.nextInt(this.radiusMax - this.radiusMin);
        for (int x = -sphereRadius; x <= sphereRadius; ++x) {
            for (int z = -sphereRadius; z <= sphereRadius; ++z) {
                for (int y = -sphereRadius; y <= sphereRadius; ++y) {
                    if (x * x + y * y + z * z > sphereRadius * sphereRadius) continue;
                    relativeBlockAccess.generateBlock(x, y, z);
                }
            }
        }
    }
}

