/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.bedrockFluids;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.util.FileUtility;
import gregtech.api.util.GTLog;
import gregtech.api.util.random.XoShiRo256PlusPlusRandom;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinSaveData;
import gregtech.api.worldgen.bedrockFluids.ChunkPosDimension;
import gregtech.api.worldgen.config.BedrockFluidDepositDefinition;
import gregtech.core.network.packets.PacketFluidVeinList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BedrockFluidVeinHandler {
    public static final LinkedHashMap<BedrockFluidDepositDefinition, Integer> veinList = new LinkedHashMap();
    private static final Map<Integer, HashMap<Integer, Integer>> totalWeightMap = new HashMap<Integer, HashMap<Integer, Integer>>();
    public static HashMap<ChunkPosDimension, FluidVeinWorldEntry> veinCache = new HashMap();
    public static int saveDataVersion;
    public static final int MAX_FLUID_SAVE_DATA_VERSION = 2;
    public static final int VEIN_CHUNK_SIZE = 8;
    public static final int MAXIMUM_VEIN_OPERATIONS = 100000;

    @Nullable
    public static FluidVeinWorldEntry getFluidVeinWorldEntry(@NotNull World world, int chunkX, int chunkZ) {
        if (world.field_72995_K) {
            return null;
        }
        ChunkPosDimension coords = new ChunkPosDimension(world.field_73011_w.getDimension(), BedrockFluidVeinHandler.getVeinCoord(chunkX), BedrockFluidVeinHandler.getVeinCoord(chunkZ));
        FluidVeinWorldEntry worldEntry = veinCache.get((Object)coords);
        if (worldEntry == null) {
            BedrockFluidDepositDefinition definition = null;
            int query = world.func_72964_e(BedrockFluidVeinHandler.getVeinCoord(chunkX), BedrockFluidVeinHandler.getVeinCoord(chunkZ)).func_76617_a(90210L).nextInt();
            Biome biome = world.getBiomeForCoordsBody(new BlockPos(chunkX << 4, 64, chunkZ << 4));
            int totalWeight = BedrockFluidVeinHandler.getTotalWeight(world.field_73011_w, biome);
            if (totalWeight > 0) {
                int weight = Math.abs(query % totalWeight);
                for (Map.Entry<BedrockFluidDepositDefinition, Integer> entry : veinList.entrySet()) {
                    int veinWeight = entry.getValue() + entry.getKey().getBiomeWeightModifier().apply(biome);
                    if (veinWeight <= 0 || !entry.getKey().getDimensionFilter().test(world.field_73011_w) || (weight -= veinWeight) >= 0) continue;
                    definition = entry.getKey();
                    break;
                }
            }
            XoShiRo256PlusPlusRandom random = new XoShiRo256PlusPlusRandom(961L * (long)chunkX + (long)chunkZ * 31L + (long)Long.hashCode(world.func_72905_C()));
            int maximumYield = 0;
            if (definition != null) {
                maximumYield = definition.getMaximumYield() - definition.getMinimumYield() <= 0 ? definition.getMinimumYield() : ((Random)random).nextInt(definition.getMaximumYield() - definition.getMinimumYield()) + definition.getMinimumYield();
                maximumYield = Math.min(maximumYield, definition.getMaximumYield());
            }
            worldEntry = new FluidVeinWorldEntry(definition, maximumYield, 100000);
            veinCache.put(coords, worldEntry);
        }
        return worldEntry;
    }

    public static int getTotalWeight(@NotNull WorldProvider provider, Biome biome) {
        int biomeID;
        Map dimMap;
        int dim = provider.getDimension();
        if (!totalWeightMap.containsKey(dim)) {
            totalWeightMap.put(dim, new HashMap());
        }
        if ((dimMap = (Map)totalWeightMap.get(dim)).containsKey(biomeID = Biome.func_185362_a((Biome)biome))) {
            return (Integer)dimMap.get(biomeID);
        }
        int totalWeight = 0;
        for (Map.Entry<BedrockFluidDepositDefinition, Integer> entry : veinList.entrySet()) {
            if (!entry.getKey().getDimensionFilter().test(provider)) continue;
            totalWeight += entry.getKey().getBiomeWeightModifier().apply(biome).intValue();
            totalWeight += entry.getKey().getWeight();
        }
        if (totalWeight == 0 && !veinList.isEmpty()) {
            GTLog.logger.error("Bedrock Fluid Vein weight was 0 in biome {}", (Object)biome.field_76791_y);
        }
        dimMap.put(biomeID, totalWeight);
        return totalWeight;
    }

    public static void addFluidDeposit(BedrockFluidDepositDefinition definition) {
        veinList.put(definition, definition.getWeight());
    }

    public static void recalculateChances(boolean mutePackets) {
        totalWeightMap.clear();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !mutePackets) {
            HashMap<FluidVeinWorldEntry, Integer> packetMap = new HashMap<FluidVeinWorldEntry, Integer>();
            for (Map.Entry<ChunkPosDimension, FluidVeinWorldEntry> entry : veinCache.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                packetMap.put(entry.getValue(), entry.getValue().getDefinition().getWeight());
            }
            GregTechAPI.networkHandler.sendToAll(new PacketFluidVeinList(packetMap));
        }
    }

    public static int getFluidYield(World world, int chunkX, int chunkZ) {
        FluidVeinWorldEntry info = BedrockFluidVeinHandler.getFluidVeinWorldEntry(world, chunkX, chunkZ);
        if (info == null) {
            return 0;
        }
        return info.getFluidYield();
    }

    public static int getDepletedFluidYield(World world, int chunkX, int chunkZ) {
        FluidVeinWorldEntry info = BedrockFluidVeinHandler.getFluidVeinWorldEntry(world, chunkX, chunkZ);
        if (info == null || info.getDefinition() == null) {
            return 0;
        }
        return info.getDefinition().getDepletedYield();
    }

    public static int getOperationsRemaining(World world, int chunkX, int chunkZ) {
        FluidVeinWorldEntry info = BedrockFluidVeinHandler.getFluidVeinWorldEntry(world, chunkX, chunkZ);
        if (info == null) {
            return 0;
        }
        return info.getOperationsRemaining();
    }

    @Nullable
    public static Fluid getFluidInChunk(World world, int chunkX, int chunkZ) {
        FluidVeinWorldEntry info = BedrockFluidVeinHandler.getFluidVeinWorldEntry(world, chunkX, chunkZ);
        if (info == null || info.getDefinition() == null) {
            return null;
        }
        return info.getDefinition().getStoredFluid();
    }

    public static void depleteVein(World world, int chunkX, int chunkZ, int amount, boolean ignoreVeinStats) {
        FluidVeinWorldEntry info = BedrockFluidVeinHandler.getFluidVeinWorldEntry(world, chunkX, chunkZ);
        if (info == null) {
            return;
        }
        if (ignoreVeinStats) {
            info.decreaseOperations(amount);
            return;
        }
        BedrockFluidDepositDefinition definition = info.getDefinition();
        if (definition == null || definition.getDepletionChance() == 0) {
            return;
        }
        if (definition.getDepletionChance() == 100 || GTValues.RNG.nextInt(100) <= definition.getDepletionChance()) {
            info.decreaseOperations(definition.getDepletionAmount());
            BedrockFluidVeinSaveData.setDirty();
        }
    }

    public static int getVeinCoord(int chunkCoord) {
        if (saveDataVersion >= 2) {
            return Math.floorDiv(chunkCoord, 8);
        }
        return chunkCoord / 8;
    }

    public static class FluidVeinWorldEntry {
        private BedrockFluidDepositDefinition vein;
        private int fluidYield;
        private int operationsRemaining;

        public FluidVeinWorldEntry(BedrockFluidDepositDefinition vein, int fluidYield, int operationsRemaining) {
            this.vein = vein;
            this.fluidYield = fluidYield;
            this.operationsRemaining = operationsRemaining;
        }

        private FluidVeinWorldEntry() {
        }

        public BedrockFluidDepositDefinition getDefinition() {
            return this.vein;
        }

        public int getFluidYield() {
            return this.fluidYield;
        }

        public int getOperationsRemaining() {
            return this.operationsRemaining;
        }

        public void setOperationsRemaining(int amount) {
            this.operationsRemaining = amount;
        }

        public void decreaseOperations(int amount) {
            this.operationsRemaining = Math.max(0, this.operationsRemaining - amount);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("fluidYield", this.fluidYield);
            tag.func_74768_a("operationsRemaining", this.operationsRemaining);
            if (this.vein != null) {
                tag.func_74778_a("vein", this.vein.getDepositName());
            }
            return tag;
        }

        @NotNull
        public static FluidVeinWorldEntry readFromNBT(@NotNull NBTTagCompound tag) {
            FluidVeinWorldEntry info = new FluidVeinWorldEntry();
            info.fluidYield = tag.func_74762_e("fluidYield");
            info.operationsRemaining = tag.func_74762_e("operationsRemaining");
            if (tag.func_74764_b("vein")) {
                String s = tag.func_74779_i("vein");
                for (BedrockFluidDepositDefinition definition : veinList.keySet()) {
                    if (!FileUtility.nativeSepToSlash(s).equalsIgnoreCase(definition.getDepositName())) continue;
                    info.vein = definition;
                }
            }
            return info;
        }
    }
}

