/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.virtualregistry.entries;

import gregtech.api.util.virtualregistry.EntryTypes;
import gregtech.api.util.virtualregistry.VirtualEntry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.Nullable;

public class VirtualTank
extends VirtualEntry
implements IFluidTank,
IFluidHandler {
    protected static final String CAPACITY_KEY = "capacity";
    protected static final String FLUID_KEY = "fluid";
    private static final int DEFAULT_CAPACITY = 64000;
    @Nullable
    private FluidStack fluidStack = null;
    private int capacity;
    private final IFluidTankProperties[] props = new IFluidTankProperties[]{VirtualTank.createProperty(this)};

    public VirtualTank(int capacity) {
        this.capacity = capacity;
    }

    public VirtualTank() {
        this(64000);
    }

    public EntryTypes<VirtualTank> getType() {
        return EntryTypes.ENDER_FLUID;
    }

    public FluidStack getFluid() {
        return this.fluidStack;
    }

    public void setFluid(FluidStack fluid) {
        this.fluidStack = fluid;
    }

    public int getFluidAmount() {
        return this.fluidStack == null ? 0 : this.fluidStack.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.props;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VirtualTank)) {
            return false;
        }
        VirtualTank other = (VirtualTank)o;
        if (this.fluidStack == null && other.fluidStack == null) {
            return super.equals(o);
        }
        if (this.fluidStack == null || other.fluidStack == null) {
            return false;
        }
        if (this.fluidStack.isFluidStackIdentical(other.fluidStack)) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74768_a(CAPACITY_KEY, this.capacity);
        if (this.fluidStack != null) {
            tag.func_74782_a(FLUID_KEY, (NBTBase)this.fluidStack.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.capacity = nbt.func_74762_e(CAPACITY_KEY);
        if (nbt.func_74764_b(FLUID_KEY)) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l(FLUID_KEY)));
        }
    }

    public int fill(FluidStack fluidStack, boolean doFill) {
        if (fluidStack == null || fluidStack.amount <= 0 || this.fluidStack != null && !fluidStack.isFluidEqual(this.fluidStack)) {
            return 0;
        }
        int fillAmt = Math.min(fluidStack.amount, this.getCapacity() - this.getFluidAmount());
        if (doFill) {
            if (this.fluidStack == null) {
                this.fluidStack = new FluidStack(fluidStack, fillAmt);
            } else {
                this.fluidStack.amount += fillAmt;
            }
        }
        return fillAmt;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return resource == null || !resource.isFluidEqual(this.fluidStack) ? null : this.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int amount, boolean doDrain) {
        if (this.fluidStack == null || amount <= 0) {
            return null;
        }
        int drainAmt = Math.min(this.getFluidAmount(), amount);
        FluidStack drainedFluid = new FluidStack(this.fluidStack, drainAmt);
        if (doDrain) {
            this.fluidStack.amount -= drainAmt;
            if (this.fluidStack.amount <= 0) {
                this.fluidStack = null;
            }
        }
        return drainedFluid;
    }

    private static IFluidTankProperties createProperty(final VirtualTank tank) {
        return new IFluidTankProperties(){

            @Nullable
            public FluidStack getContents() {
                FluidStack contents = tank.getFluid();
                return contents == null ? null : contents.copy();
            }

            public int getCapacity() {
                return tank.getCapacity();
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrain() {
                return true;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return true;
            }
        };
    }
}

