/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.virtualregistry;

import gregtech.api.util.virtualregistry.EntryTypes;
import gregtech.api.util.virtualregistry.VirtualEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualRegistryMap
implements INBTSerializable<NBTTagCompound> {
    private final Map<EntryTypes<?>, Map<String, VirtualEntry>> registryMap = new HashMap();

    public VirtualRegistryMap(NBTTagCompound tag) {
        this.deserializeNBT(tag);
    }

    public VirtualRegistryMap() {
    }

    @Nullable
    public <T extends VirtualEntry> T getEntry(EntryTypes<T> type, String name) {
        if (!this.contains(type, name)) {
            return null;
        }
        return (T)this.registryMap.get(type).get(name);
    }

    public void addEntry(String name, VirtualEntry entry) {
        this.registryMap.computeIfAbsent(entry.getType(), k -> new HashMap()).put(name, entry);
    }

    public boolean contains(EntryTypes<?> type, String name) {
        if (!this.registryMap.containsKey(type)) {
            return false;
        }
        return this.registryMap.get(type).containsKey(name);
    }

    public void deleteEntry(EntryTypes<?> type, String name) {
        this.registryMap.get(type).remove(name);
    }

    public void clear() {
        this.registryMap.clear();
    }

    public Set<String> getEntryNames(EntryTypes<?> type) {
        return this.registryMap.get(type).keySet();
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        for (EntryTypes<?> type : this.registryMap.keySet()) {
            NBTTagCompound entriesTag = new NBTTagCompound();
            Map<String, VirtualEntry> entries = this.registryMap.get(type);
            for (String name : entries.keySet()) {
                entriesTag.func_74782_a(name, (NBTBase)entries.get(name).serializeNBT());
            }
            tag.func_74782_a(type.toString(), (NBTBase)entriesTag);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (String entryType : nbt.func_150296_c()) {
            EntryTypes<VirtualEntry> type = entryType.contains(":") ? EntryTypes.fromLocation(entryType) : EntryTypes.fromString(entryType);
            if (type == null) continue;
            NBTTagCompound virtualEntries = nbt.func_74775_l(entryType);
            for (String name : virtualEntries.func_150296_c()) {
                NBTTagCompound entry = virtualEntries.func_74775_l(name);
                this.addEntry(name, type.createInstance(entry));
            }
        }
    }
}

