/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.virtualregistry;

import gregtech.api.util.virtualregistry.EntryTypes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public abstract class VirtualEntry
implements INBTSerializable<NBTTagCompound> {
    public static final String DEFAULT_COLOR = "FFFFFFFF";
    protected static final String COLOR_KEY = "color";
    protected static final String DESC_KEY = "description";
    private int color = -1;
    private String colorStr = "FFFFFFFF";
    @NotNull
    private String description = "";

    public abstract EntryTypes<? extends VirtualEntry> getType();

    public String getColorStr() {
        return this.colorStr;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = this.parseColor(color);
        this.colorStr = color.toUpperCase();
    }

    public void setColor(int color) {
        this.setColor(Integer.toHexString(color));
    }

    private int parseColor(String s) {
        long tmp = Long.parseLong(s, 16);
        if (tmp > Integer.MAX_VALUE) {
            tmp -= 0x100000000L;
        }
        return (int)tmp;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull String desc) {
        this.description = desc;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VirtualEntry)) {
            return false;
        }
        VirtualEntry other = (VirtualEntry)o;
        return this.getType() == other.getType() && this.color == other.color;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(COLOR_KEY, this.colorStr);
        if (this.description != null && !this.description.isEmpty()) {
            tag.func_74778_a(DESC_KEY, this.description);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.setColor(nbt.func_74779_i(COLOR_KEY));
        if (nbt.func_74764_b(DESC_KEY)) {
            this.setDescription(nbt.func_74779_i(DESC_KEY));
        }
    }
}

