/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.virtualregistry;

import gregtech.api.util.GTLog;
import gregtech.api.util.virtualregistry.EntryTypes;
import gregtech.api.util.virtualregistry.VirtualEntry;
import gregtech.api.util.virtualregistry.VirtualRegistryMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualEnderRegistry
extends WorldSavedData {
    private static final String DATA_ID = "gregtech.virtual_entry_data";
    private static final String OLD_DATA_ID = "gregtech.vtank_data";
    private static final String PUBLIC_KEY = "Public";
    private static final String PRIVATE_KEY = "Private";
    private static final Map<UUID, VirtualRegistryMap> VIRTUAL_REGISTRIES = new HashMap<UUID, VirtualRegistryMap>();

    public VirtualEnderRegistry(String name) {
        super(name);
    }

    public static <T extends VirtualEntry> T getEntry(@Nullable UUID owner, EntryTypes<T> type, String name) {
        return VirtualEnderRegistry.getRegistry(owner).getEntry(type, name);
    }

    public static void addEntry(@Nullable UUID owner, String name, VirtualEntry entry) {
        VirtualEnderRegistry.getRegistry(owner).addEntry(name, entry);
    }

    public static boolean hasEntry(@Nullable UUID owner, EntryTypes<?> type, String name) {
        return VirtualEnderRegistry.getRegistry(owner).contains(type, name);
    }

    @NotNull
    public static <T extends VirtualEntry> T getOrCreateEntry(@Nullable UUID owner, EntryTypes<T> type, String name) {
        if (!VirtualEnderRegistry.hasEntry(owner, type, name)) {
            VirtualEnderRegistry.addEntry(owner, name, type.createInstance());
        }
        return VirtualEnderRegistry.getEntry(owner, type, name);
    }

    public static void deleteEntry(@Nullable UUID owner, EntryTypes<?> type, String name) {
        VirtualRegistryMap registry = VirtualEnderRegistry.getRegistry(owner);
        if (registry.contains(type, name)) {
            registry.deleteEntry(type, name);
            return;
        }
        GTLog.logger.warn("Attempted to delete {} entry {} of type {}, which does not exist", (Object)(owner == null ? "public" : String.format("private [%s]", owner)), (Object)name, type);
    }

    public static <T extends VirtualEntry> void deleteEntry(@Nullable UUID owner, EntryTypes<T> type, String name, Predicate<T> shouldDelete) {
        T entry = VirtualEnderRegistry.getEntry(owner, type, name);
        if (entry != null && shouldDelete.test(entry)) {
            VirtualEnderRegistry.deleteEntry(owner, type, name);
        }
    }

    public static Set<String> getEntryNames(UUID owner, EntryTypes<?> type) {
        return VirtualEnderRegistry.getRegistry(owner).getEntryNames(type);
    }

    public static void clearMaps() {
        VIRTUAL_REGISTRIES.clear();
    }

    private static VirtualRegistryMap getRegistry(UUID owner) {
        return VIRTUAL_REGISTRIES.computeIfAbsent(owner, key -> new VirtualRegistryMap());
    }

    public static Map<UUID, Map<String, IFluidTank>> createTankMap() {
        HashMap<UUID, Map<String, IFluidTank>> map = new HashMap<UUID, Map<String, IFluidTank>>();
        for (UUID uuid : VIRTUAL_REGISTRIES.keySet()) {
            map.put(uuid, new HashMap());
            for (String name : VirtualEnderRegistry.getEntryNames(uuid, EntryTypes.ENDER_FLUID)) {
                ((Map)map.get(uuid)).put(name, (IFluidTank)VirtualEnderRegistry.getEntry(uuid, EntryTypes.ENDER_FLUID, name));
            }
        }
        return map;
    }

    public final void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b(PUBLIC_KEY)) {
            VIRTUAL_REGISTRIES.put(null, new VirtualRegistryMap(nbt.func_74775_l(PUBLIC_KEY)));
        }
        if (nbt.func_74764_b(PRIVATE_KEY)) {
            NBTTagCompound privateEntries = nbt.func_74775_l(PRIVATE_KEY);
            for (String owner : privateEntries.func_150296_c()) {
                NBTTagCompound privateMap = privateEntries.func_74775_l(owner);
                VIRTUAL_REGISTRIES.put(UUID.fromString(owner), new VirtualRegistryMap(privateMap));
            }
        }
    }

    @NotNull
    public final NBTTagCompound func_189551_b(@NotNull NBTTagCompound tag) {
        NBTTagCompound privateTag = new NBTTagCompound();
        for (UUID owner : VIRTUAL_REGISTRIES.keySet()) {
            NBTTagCompound mapTag = VIRTUAL_REGISTRIES.get(owner).serializeNBT();
            if (owner != null) {
                privateTag.func_74782_a(owner.toString(), (NBTBase)mapTag);
                continue;
            }
            tag.func_74782_a(PUBLIC_KEY, (NBTBase)mapTag);
        }
        tag.func_74782_a(PRIVATE_KEY, (NBTBase)privateTag);
        return tag;
    }

    public boolean func_76188_b() {
        return true;
    }

    public static void initializeStorage(World world) {
        MapStorage storage = world.func_175693_T();
        VirtualEnderRegistry instance = (VirtualEnderRegistry)storage.func_75742_a(VirtualEnderRegistry.class, DATA_ID);
        VirtualEnderRegistry old = (VirtualEnderRegistry)storage.func_75742_a(VirtualEnderRegistry.class, OLD_DATA_ID);
        if (instance == null) {
            instance = new VirtualEnderRegistry(DATA_ID);
            storage.func_75745_a(DATA_ID, (WorldSavedData)instance);
        }
        if (old != null) {
            instance.func_76184_a(old.serializeNBT());
            File file = world.func_72860_G().func_75758_b(OLD_DATA_ID);
            String[] split = file.getName().split("\\.");
            StringBuilder stringBuilder = new StringBuilder(split[0]).append('.').append(split[1]).append(".backup").append('.').append(split[2]);
            if (file.renameTo(new File(file.getParent(), stringBuilder.toString()))) {
                file.deleteOnExit();
                GTLog.logger.warn("Moved Virtual Tank Data to new format, created backup!");
            }
        }
    }
}

