/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.virtualregistry;

import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.virtualregistry.VirtualEntry;
import gregtech.api.util.virtualregistry.entries.VirtualTank;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class EntryTypes<T extends VirtualEntry> {
    private static final Map<ResourceLocation, EntryTypes<?>> TYPES_MAP = new Object2ObjectOpenHashMap();
    public static final EntryTypes<VirtualTank> ENDER_FLUID = EntryTypes.addEntryType(GTUtility.gregtechId("ender_fluid"), VirtualTank::new);
    private final ResourceLocation location;
    private final Supplier<T> factory;

    private EntryTypes(ResourceLocation location, Supplier<T> supplier) {
        this.location = location;
        this.factory = supplier;
    }

    public T createInstance(NBTTagCompound nbt) {
        T entry = this.createInstance();
        ((VirtualEntry)entry).deserializeNBT(nbt);
        return entry;
    }

    public T createInstance() {
        return (T)((VirtualEntry)this.factory.get());
    }

    public String toString() {
        return this.location.toString();
    }

    @Nullable
    public static EntryTypes<? extends VirtualEntry> fromString(String name) {
        return TYPES_MAP.getOrDefault(GTUtility.gregtechId(name), null);
    }

    @Nullable
    public static EntryTypes<? extends VirtualEntry> fromLocation(String location) {
        return TYPES_MAP.getOrDefault(new ResourceLocation(location), null);
    }

    public static <E extends VirtualEntry> EntryTypes<E> addEntryType(ResourceLocation location, Supplier<E> supplier) {
        EntryTypes<E> type = new EntryTypes<E>(location, supplier);
        if (!TYPES_MAP.containsKey(location)) {
            TYPES_MAP.put(location, type);
        } else {
            GTLog.logger.warn("Entry \"{}\" is already registered!", (Object)location);
        }
        return type;
    }
}

