/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.random;

import gregtech.api.util.random.SplitMix64Random;
import gregtech.api.util.random.Util;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

class XoRoShiRo128PlusRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private long s0;
    private long s1;
    private static final long[] JUMP = new long[]{-2337365368286915419L, 1659688472399708668L};
    private static final long[] LONG_JUMP = new long[]{-3266927057705177477L, -2459076376072127807L};

    protected XoRoShiRo128PlusRandom(long s0, long s1) {
        this.s0 = s0;
        this.s1 = s1;
    }

    public XoRoShiRo128PlusRandom() {
        this(Util.randomSeed());
    }

    public XoRoShiRo128PlusRandom(long seed) {
        this.setSeed(seed);
    }

    public XoRoShiRo128PlusRandom copy() {
        return new XoRoShiRo128PlusRandom(this.s0, this.s1);
    }

    @Override
    public long nextLong() {
        long s0 = this.s0;
        long s1 = this.s1;
        long result = s0 + s1;
        this.s0 = Long.rotateLeft(s0, 24) ^ (s1 ^= s0) ^ s1 << 16;
        this.s1 = Long.rotateLeft(s1, 37);
        return result;
    }

    @Override
    public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    @Override
    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    @Override
    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = this.nextLong();
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t >>> Long.numberOfLeadingZeros(nMinus1) & nMinus1;
        }
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = this.nextLong() >>> 1;
        }
        return t;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public double nextDoubleFast() {
        return Double.longBitsToDouble(0x3FF0000000000000L | this.nextLong() >>> 12) - 1.0;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    @Override
    public void nextBytes(byte @NotNull [] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = this.nextLong();
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    @NotNull
    protected XoRoShiRo128PlusRandom jump(long @NotNull [] jump) {
        long s0 = 0L;
        long s1 = 0L;
        for (long element : jump) {
            for (int b = 0; b < 64; ++b) {
                if ((element & 1L << b) != 0L) {
                    s0 ^= this.s0;
                    s1 ^= this.s1;
                }
                this.nextLong();
            }
        }
        this.s0 = s0;
        this.s1 = s1;
        return this;
    }

    @NotNull
    public XoRoShiRo128PlusRandom jump() {
        return this.jump(JUMP);
    }

    @NotNull
    public XoRoShiRo128PlusRandom longJump() {
        return this.jump(LONG_JUMP);
    }

    @NotNull
    public XoRoShiRo128PlusRandom split() {
        this.nextLong();
        XoRoShiRo128PlusRandom split = this.copy();
        long h0 = this.s0;
        long h1 = this.s1;
        long h2 = this.s0 + 6171709007915041769L;
        long h3 = this.s1 + -5504830798508614797L;
        h2 = Long.rotateLeft(h2, 50);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 52);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 30);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 41);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 54);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 48);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 38);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 37);
        h3 ^= (h1 += h2);
        h2 = Long.rotateLeft(h2, 62);
        h0 ^= (h2 += h3);
        h3 = Long.rotateLeft(h3, 34);
        h1 ^= (h3 += h0);
        h0 = Long.rotateLeft(h0, 5);
        h2 ^= (h0 += h1);
        h1 = Long.rotateLeft(h1, 36);
        split.s0 = h0;
        split.s1 = h1 += h2;
        return split;
    }

    @Override
    public void setSeed(long seed) {
        SplitMix64Random r = new SplitMix64Random(seed);
        this.s0 = r.nextLong();
        this.s1 = r.nextLong();
    }

    public void setState(long @NotNull [] state) {
        if (state.length != 2) {
            throw new IllegalArgumentException("The argument array contains " + state.length + " longs instead of " + 2);
        }
        this.s0 = state[0];
        this.s1 = state[1];
    }
}

