/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.oreglob;

import gregtech.api.unification.OreDictUnifier;
import gregtech.api.util.oreglob.OreGlobCompileResult;
import gregtech.api.util.oreglob.OreGlobCompiler;
import gregtech.api.util.oreglob.OreGlobTextBuilder;
import gregtech.api.util.oreglob.OreGlobTextFormatting;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class OreGlob {
    private static OreGlobCompiler compiler;

    @NotNull
    public static OreGlobCompileResult compile(@NotNull String expression, boolean ignoreCase) {
        if (compiler == null) {
            throw new IllegalStateException("Compiler unavailable");
        }
        return compiler.compile(expression, ignoreCase);
    }

    @ApiStatus.Internal
    public static void setCompiler(@NotNull OreGlobCompiler compiler) {
        OreGlob.compiler = compiler;
    }

    @NotNull
    public abstract <V extends OreGlobTextBuilder> V visualize(@NotNull V var1);

    public abstract boolean matches(@NotNull String var1);

    public final boolean matchesAny(@NotNull ItemStack stack) {
        return this.matchesAny(OreDictUnifier.getOreDictionaryNames(stack), true);
    }

    public final boolean matchesAll(@NotNull ItemStack stack) {
        return this.matchesAll(OreDictUnifier.getOreDictionaryNames(stack), true);
    }

    public final boolean matchesAny(@NotNull Collection<String> inputs, boolean specialEmptyMatch) {
        if (specialEmptyMatch && inputs.isEmpty()) {
            return this.matches("");
        }
        for (String input : inputs) {
            if (!this.matches(input)) continue;
            return true;
        }
        return false;
    }

    public final boolean matchesAll(@NotNull Collection<String> inputs, boolean specialEmptyMatch) {
        if (specialEmptyMatch && inputs.isEmpty()) {
            return this.matches("");
        }
        for (String input : inputs) {
            if (this.matches(input)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final List<String> toFormattedString() {
        return this.visualize(new OreGlobTextBuilder(OreGlobTextFormatting.DEFAULT_FORMATTING)).getLines();
    }

    @NotNull
    public final List<String> toFormattedString(@NotNull String indent) {
        return this.visualize(new OreGlobTextBuilder(OreGlobTextFormatting.DEFAULT_FORMATTING, indent)).getLines();
    }

    public final String toString() {
        return String.join((CharSequence)"\n", this.visualize(new OreGlobTextBuilder(OreGlobTextFormatting.NO_FORMATTING)).getLines());
    }
}

