/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.interpolate;

import gregtech.api.util.function.TriConsumer;
import net.minecraft.util.ITickable;

public class RGBInterpolator
implements ITickable {
    private final int speed;
    private float r = 255.0f;
    private float g = 0.0f;
    private float b = 0.0f;
    private final TriConsumer<Number, Number, Number> interpolate;
    private final TriConsumer<Number, Number, Number> callback;
    private boolean isOn = false;

    public RGBInterpolator(int speed, TriConsumer<Number, Number, Number> interpolate, TriConsumer<Number, Number, Number> callback) {
        this.speed = speed;
        this.interpolate = interpolate;
        this.callback = callback;
    }

    public void func_73660_a() {
        if (this.isOn) {
            if (this.r == 255.0f && this.g < 255.0f) {
                this.b -= Math.min((float)this.speed, this.b);
                this.g += Math.min((float)this.speed, 255.0f - this.g);
            } else if (this.g == 255.0f && this.b < 255.0f) {
                this.r -= Math.min((float)this.speed, this.r);
                this.b += Math.min((float)this.speed, 255.0f - this.b);
            } else if (this.b == 255.0f && this.r < 255.0f) {
                this.g -= Math.min((float)this.speed, this.g);
                this.r += Math.min((float)this.speed, 255.0f - this.r);
            }
            this.interpolate.accept(Float.valueOf(this.r / 255.0f), Float.valueOf(this.g / 255.0f), Float.valueOf(this.b / 255.0f));
        }
    }

    public void stop() {
        this.callback.accept(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
        this.isOn = false;
    }

    public void start() {
        this.isOn = true;
    }

    public boolean isActivated() {
        return this.isOn;
    }
}

