/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.interpolate;

import gregtech.api.util.interpolate.IEase;
import java.util.function.Consumer;
import net.minecraft.util.ITickable;

public class Interpolator
implements ITickable {
    private final float from;
    private final float to;
    private final int duration;
    private final IEase ease;
    private final Consumer<Number> interpolate;
    private final Consumer<Number> callback;
    private int tick = 0;

    public Interpolator(float from, float to, int duration, IEase ease, Consumer<Number> interpolate) {
        this(from, to, duration, ease, interpolate, null);
    }

    public Interpolator(float from, float to, int duration, IEase ease, Consumer<Number> interpolate, Consumer<Number> callback) {
        this.from = from;
        this.to = to;
        this.duration = duration;
        this.ease = ease;
        this.interpolate = interpolate;
        this.callback = callback;
    }

    public void reset() {
        this.tick = 0;
    }

    public Interpolator start() {
        this.tick = 1;
        return this;
    }

    public boolean isFinish() {
        return this.tick == this.duration;
    }

    public void func_73660_a() {
        if (this.tick < 1 || this.tick > this.duration) {
            return;
        }
        if (this.tick == this.duration) {
            this.callback.accept(Float.valueOf(this.ease.getInterpolation((float)this.tick * 1.0f / (float)this.duration) * (this.to - this.from) + this.from));
        }
        this.interpolate.accept(Float.valueOf(this.ease.getInterpolation((float)this.tick * 1.0f / (float)this.duration) * (this.to - this.from) + this.from));
        ++this.tick;
    }
}

