/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.interpolate;

import gregtech.api.util.interpolate.IEase;

public enum Eases implements IEase
{
    LINEAR{

        @Override
        public float getInterpolation(float t) {
            return t;
        }
    }
    ,
    QUAD_IN{

        @Override
        public float getInterpolation(float t) {
            return t * t;
        }
    }
    ,
    QUAD_IN_OUT{

        @Override
        public float getInterpolation(float t) {
            if (t <= 0.5f) {
                return 2.0f * t * t;
            }
            t = -2.0f * t + 2.0f;
            return 1.0f - t * t * 0.5f;
        }
    }
    ,
    QUAD_OUT{

        @Override
        public float getInterpolation(float t) {
            return -t * (t - 2.0f);
        }
    };

}

