/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GTUtility;
import java.math.BigInteger;
import java.text.NumberFormat;

public class TextFormattingUtil {
    private static final long[] metricSuffixValues = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final BigInteger[] metricBigSuffixValues = new BigInteger[]{BigInteger.TEN.pow(3), BigInteger.TEN.pow(6), BigInteger.TEN.pow(9), BigInteger.TEN.pow(12), BigInteger.TEN.pow(15), BigInteger.TEN.pow(18), BigInteger.TEN.pow(21), BigInteger.TEN.pow(24), BigInteger.TEN.pow(27), BigInteger.TEN.pow(30)};
    private static final char[] metricSuffixChars = new char[]{'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y', 'R', 'Q'};
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();

    public static String formatLongToCompactString(long value, int precision) {
        int i;
        if (value == 0L || (double)Math.abs(value) < Math.pow(10.0, precision)) {
            return TextFormattingUtil.formatNumbers(value);
        }
        StringBuilder stb = new StringBuilder();
        if (value < 0L) {
            stb.append('-');
            long l = value = value == Long.MIN_VALUE ? Long.MAX_VALUE : -value;
        }
        if ((i = GTUtility.nearestLesserOrEqual(metricSuffixValues, value)) == -1) {
            return stb.append(value).toString();
        }
        long suffixValue = metricSuffixValues[i];
        stb.append(value / suffixValue);
        long truncatedDigit = value % suffixValue / (suffixValue / (long)Math.pow(10.0, precision - 3));
        if (truncatedDigit > 0L) {
            stb.append('.').append(truncatedDigit);
        }
        return stb.append(metricSuffixChars[i]).toString();
    }

    public static String formatBigIntToCompactString(BigInteger value, int precision) {
        if (BigInteger.ZERO.equals(value) || value.abs().compareTo(BigInteger.TEN.pow(precision)) < 0) {
            return value.toString();
        }
        StringBuilder stb = new StringBuilder();
        if (value.signum() == -1) {
            stb.append('-');
            value = value.abs();
        }
        int c = 0;
        while (value.compareTo(metricBigSuffixValues[c]) >= 0) {
            ++c;
        }
        return stb.append(value.divide(metricBigSuffixValues[c - 1])).append('.').append(value.toString(), 4, precision + 1).append(metricSuffixChars[c - 1]).toString();
    }

    public static String formatLongToCompactString(long value) {
        return TextFormattingUtil.formatLongToCompactString(value, 3);
    }

    public static String formatNumbers(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(double number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatNumbers(Object number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String formatStringWithNewlines(String toFormat, int maxLength) {
        String[] name = toFormat.split(" ");
        StringBuilder builder = new StringBuilder();
        int length = 0;
        for (String s : name) {
            if ((length += s.length()) > maxLength) {
                builder.append("\n");
                builder.append(s);
                length = 0;
                continue;
            }
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append(s);
        }
        return builder.toString();
    }
}

