/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import org.jetbrains.annotations.NotNull;

public final class SmallDigits {
    private static final int SMALL_DOWN_NUMBER_BASE = 8320;
    private static final int SMALL_UP_NUMBER_BASE = 8320;
    private static final int NUMBER_BASE = 48;
    private static final int FORMATTING_SYMBOL = 167;

    private SmallDigits() {
    }

    @NotNull
    public static String toSmallUpNumbers(String string) {
        return SmallDigits.convert(string, 8320);
    }

    @NotNull
    public static String toSmallDownNumbers(String string) {
        return SmallDigits.convert(string, 8320);
    }

    @NotNull
    private static String convert(@NotNull String string, int base) {
        char[] chars = string.toCharArray();
        boolean hasPrefix = false;
        boolean hasFormat = false;
        for (int i = 0; i < chars.length; ++i) {
            if (hasFormat) {
                hasFormat = false;
                continue;
            }
            char c = chars[i];
            if (c == '-') {
                hasPrefix = true;
                continue;
            }
            if (c == '\u00a7') {
                hasFormat = true;
                continue;
            }
            if (Character.isDigit(c)) {
                if (hasPrefix) continue;
                chars[i] = SmallDigits.convertToBase(c, base);
                continue;
            }
            hasPrefix = false;
        }
        return new String(chars);
    }

    private static char convertToBase(char c, int base) {
        return (char)(base + (c - 48));
    }
}

