/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.capability.IMultipleTankHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlayedFluidHandler {
    private final List<OverlayedTank> overlayedTanks = new ArrayList<OverlayedTank>();

    public OverlayedFluidHandler(@NotNull IMultipleTankHandler tank) {
        IMultipleTankHandler.ITankEntry[] entries = tank.getFluidTanks().toArray(new IMultipleTankHandler.ITankEntry[0]);
        Arrays.sort(entries, IMultipleTankHandler.ENTRY_COMPARATOR);
        for (IMultipleTankHandler.ITankEntry fluidTank : entries) {
            for (IFluidTankProperties property : fluidTank.getTankProperties()) {
                this.overlayedTanks.add(new OverlayedTank(property, fluidTank.allowSameFluidFill()));
            }
        }
    }

    public void reset() {
        for (OverlayedTank overlayedTank : this.overlayedTanks) {
            overlayedTank.reset();
        }
    }

    public int insertFluid(@NotNull FluidStack fluid, int amountToInsert) {
        int inserted;
        if (amountToInsert <= 0) {
            return 0;
        }
        int totalInserted = 0;
        boolean distinctFillPerformed = false;
        for (OverlayedTank overlayedTank : this.overlayedTanks) {
            if (!fluid.isFluidEqual(overlayedTank.fluid)) continue;
            inserted = overlayedTank.tryInsert(fluid, amountToInsert);
            if (inserted > 0) {
                totalInserted += inserted;
                if ((amountToInsert -= inserted) <= 0) {
                    return totalInserted;
                }
            }
            if (overlayedTank.allowSameFluidFill) continue;
            distinctFillPerformed = true;
        }
        for (OverlayedTank overlayedTank : this.overlayedTanks) {
            if (distinctFillPerformed && !overlayedTank.allowSameFluidFill || !overlayedTank.isEmpty() || !overlayedTank.property.canFillFluidType(fluid) || (inserted = overlayedTank.tryInsert(fluid, amountToInsert)) <= 0) continue;
            totalInserted += inserted;
            if ((amountToInsert -= inserted) <= 0) {
                return totalInserted;
            }
            if (overlayedTank.allowSameFluidFill) continue;
            distinctFillPerformed = true;
        }
        return totalInserted;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean lineBreak) {
        StringBuilder stb = new StringBuilder("OverlayedFluidHandler[").append(this.overlayedTanks.size()).append(";");
        if (lineBreak) {
            stb.append("\n  ");
        }
        for (int i = 0; i < this.overlayedTanks.size(); ++i) {
            OverlayedTank overlayedTank;
            FluidStack fluid;
            if (i != 0) {
                stb.append(',');
            }
            if (lineBreak) {
                stb.append("\n  ");
            }
            if ((fluid = (overlayedTank = this.overlayedTanks.get(i)).fluid) == null || fluid.amount == 0) {
                stb.append("None 0 / ").append(overlayedTank.property.getCapacity());
                continue;
            }
            stb.append(fluid.getFluid().getName()).append(' ').append(fluid.amount).append(" / ").append(overlayedTank.property.getCapacity());
        }
        if (lineBreak) {
            stb.append('\n');
        }
        return stb.append(']').toString();
    }

    private static class OverlayedTank {
        private final IFluidTankProperties property;
        private final boolean allowSameFluidFill;
        @Nullable
        private FluidStack fluid;

        OverlayedTank(@NotNull IFluidTankProperties property, boolean allowSameFluidFill) {
            this.property = property;
            this.allowSameFluidFill = allowSameFluidFill;
            this.reset();
        }

        public boolean isEmpty() {
            return this.fluid == null || this.fluid.amount <= 0;
        }

        public int tryInsert(@NotNull FluidStack fluid, int amount) {
            if (this.fluid == null) {
                this.fluid = fluid.copy();
                this.fluid.amount = Math.min(this.property.getCapacity(), amount);
                return this.fluid.amount;
            }
            int maxInsert = Math.min(this.property.getCapacity() - this.fluid.amount, amount);
            if (maxInsert > 0) {
                this.fluid.amount += maxInsert;
                return maxInsert;
            }
            return 0;
        }

        public void reset() {
            FluidStack fluid = this.property.getContents();
            this.fluid = fluid != null ? fluid.copy() : null;
        }
    }
}

