/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.GTLog;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkUtil {
    public static void writeFluidStack(@NotNull PacketBuffer to, @Nullable FluidStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack == null) {
            to.writeBoolean(false);
        } else {
            to.writeBoolean(true);
            stack.writeToNBT(tag);
        }
        to.func_150786_a(tag);
    }

    @Nullable
    public static FluidStack readFluidStack(@NotNull PacketBuffer from) {
        if (from.readBoolean()) {
            NBTTagCompound tag;
            try {
                tag = from.func_150793_b();
            }
            catch (IOException e) {
                GTLog.logger.error("Exception reading a FluidStack from a PacketBuffer!", (Throwable)e);
                return null;
            }
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        }
        return null;
    }

    public static void writeFluid(@NotNull PacketBuffer to, @Nullable Fluid fluid) {
        if (fluid == null) {
            to.writeBoolean(false);
        } else {
            to.writeBoolean(true);
            to.func_180714_a(fluid.getName());
        }
    }

    @Nullable
    public static Fluid readFluid(@NotNull PacketBuffer from) {
        if (from.readBoolean()) {
            return FluidRegistry.getFluid((String)from.func_150789_c(Short.MAX_VALUE));
        }
        return null;
    }

    public static void writeItemStack(@NotNull PacketBuffer to, @NotNull ItemStack stack) {
        to.func_150788_a(stack);
    }

    @NotNull
    public static ItemStack readItemStack(@NotNull PacketBuffer from) {
        try {
            return from.func_150791_c();
        }
        catch (IOException e) {
            GTLog.logger.error("Exception reading an ItemStack from a PacketBuffer!", (Throwable)e);
            return ItemStack.field_190927_a;
        }
    }
}

